/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data.BlockStruct;

import Reika.DragonAPI.Instantiable.Data.BlockStruct.AbstractSearch;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockBox;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import net.minecraft.world.World;

public class IterativeRecurser {
    private final HashSet<Coordinate> searchedCoords = new HashSet();
    private Collection<Coordinate> activeSearches = new ArrayList<Coordinate>();
    public BlockBox limit = BlockBox.infinity();

    public IterativeRecurser(int x, int y, int z) {
        this.activeSearches.add(new Coordinate(x, y, z));
    }

    public void run(World world, AbstractSearch.PropagationCondition propagation) {
        while (!this.tick(world, propagation)) {
        }
    }

    public boolean tick(World world, AbstractSearch.PropagationCondition propagation) {
        ArrayList<Coordinate> current = new ArrayList<Coordinate>(this.activeSearches);
        this.activeSearches.clear();
        for (Coordinate s : current) {
            Collection<Coordinate> li = s.getAdjacentCoordinates();
            ArrayList li2 = new ArrayList();
            for (Coordinate c : li) {
                if (c.yCoord < 0 || c.yCoord >= 256 || this.searchedCoords.contains(c) || !propagation.isValidLocation(world, c.xCoord, c.yCoord, c.zCoord, s) || !this.limit.isBlockInside(c.xCoord, c.yCoord, c.zCoord)) continue;
                this.searchedCoords.add(c);
                this.activeSearches.add(c);
            }
        }
        return this.activeSearches.isEmpty();
    }

    public Collection<Coordinate> getResult() {
        return Collections.unmodifiableCollection(this.searchedCoords);
    }
}

