/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data.BlockStruct;

import Reika.DragonAPI.Instantiable.Data.BlockStruct.AbstractSearch;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Libraries.World.ReikaBlockHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import net.minecraft.block.Block;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class OpenPathFinder
implements AbstractSearch.PropagationCondition {
    public final int searchRadius;
    public final EnumSet<PassRules> rules = EnumSet.noneOf(PassRules.class);
    private final Coordinate startLocation;
    private final Coordinate endLocation;
    public static final Collection<PassRules> defaultRules = Collections.unmodifiableSet(EnumSet.of(PassRules.SOFT));

    public OpenPathFinder(Coordinate c1, Coordinate c2, int r) {
        this.startLocation = c1;
        this.endLocation = c2;
        this.searchRadius = Math.max(r, c2.getTaxicabDistanceTo(c1));
    }

    @Override
    public final boolean isValidLocation(World world, int x, int y, int z, Coordinate from) {
        if (this.startLocation.equals(x, y, z) || this.endLocation.equals(x, y, z)) {
            return true;
        }
        if (!this.startLocation.isWithinDistOnAllCoords(x, y, z, this.searchRadius)) {
            return false;
        }
        return this.isValidBlock(world, x, y, z);
    }

    protected boolean isValidBlock(World world, int x, int y, int z) {
        return OpenPathFinder.isEmptyBlock(world, x, y, z, this.rules);
    }

    public static boolean isEmptyBlock(World world, int x, int y, int z, Collection<PassRules> rules) {
        Block b = world.func_147439_a(x, y, z);
        if (rules.contains((Object)PassRules.SMALLNONSOLID) && OpenPathFinder.isSmallPassable(world, x, y, z, b)) {
            return true;
        }
        if (!rules.contains((Object)PassRules.LIQUIDS) && ReikaBlockHelper.isLiquid(b)) {
            return false;
        }
        if (rules.contains((Object)PassRules.SOFT) && ReikaWorldHelper.softBlocks((IBlockAccess)world, x, y, z)) {
            return true;
        }
        return b.isAir((IBlockAccess)world, x, y, z);
    }

    private static boolean isSmallPassable(World world, int x, int y, int z, Block b) {
        double vol = ReikaBlockHelper.getBlockVolume(world, x, y, z);
        double thresh = b.func_149668_a(world, x, y, z) == null ? 0.0625 : 0.0078125;
        return vol <= thresh;
    }

    public static enum PassRules {
        SOFT,
        LIQUIDS,
        SMALLNONSOLID;

    }
}

