/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data.BlockStruct;

import Reika.DragonAPI.Instantiable.Data.BlockStruct.BlockArray;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Maps.ItemHashMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class StructuredBlockArray
extends BlockArray {
    private final HashMap<Coordinate, BlockKey> data = new HashMap();
    public final World world;

    public StructuredBlockArray(World world) {
        this.world = world;
    }

    @Override
    public Coordinate getNextBlock() {
        if (this.data.isEmpty()) {
            return null;
        }
        Coordinate li = this.data.keySet().iterator().next();
        return li;
    }

    @Override
    public Coordinate getNthBlock(int n) {
        return super.getNthBlock(n);
    }

    @Override
    public Set<Coordinate> keySet() {
        return Collections.unmodifiableSet(this.data.keySet());
    }

    @Override
    public Coordinate getNextAndMoveOn() {
        if (this.data.isEmpty()) {
            return null;
        }
        Coordinate li = this.data.keySet().iterator().next();
        this.data.remove(li);
        super.removeKey(li);
        return li;
    }

    @Override
    public boolean addBlockCoordinate(int x, int y, int z) {
        if (this.overflow) {
            return false;
        }
        if (this.hasBlock(x, y, z)) {
            return false;
        }
        super.addBlockCoordinate(x, y, z);
        Block b = this.world.func_147439_a(x, y, z);
        int meta = this.world.func_72805_g(x, y, z);
        Coordinate c = new Coordinate(x, y, z);
        this.data.put(c, new BlockKey(b, meta));
        return true;
    }

    public BlockKey getBlockKeyRelativeToMinXYZ(int dx, int dy, int dz) {
        int z;
        int y;
        int x = dx + this.getMinX();
        return this.hasBlock(x, y = dy + this.getMinY(), z = dz + this.getMinZ()) ? this.data.get(new Coordinate(x, y, z)) : null;
    }

    public Block getBlockRelativeToMinXYZ(int dx, int dy, int dz) {
        int z;
        int y;
        int x = dx + this.getMinX();
        return this.hasBlock(x, y = dy + this.getMinY(), z = dz + this.getMinZ()) ? this.data.get((Object)new Coordinate((int)x, (int)y, (int)z)).blockID : null;
    }

    public int getMetaRelativeToMinXYZ(int dx, int dy, int dz) {
        int z;
        int y;
        int x = dx + this.getMinX();
        return this.hasBlock(x, y = dy + this.getMinY(), z = dz + this.getMinZ()) ? this.data.get((Object)new Coordinate((int)x, (int)y, (int)z)).metadata : -1;
    }

    public BlockKey getBlockKeyAt(int x, int y, int z) {
        return this.hasBlock(x, y, z) ? this.data.get(new Coordinate(x, y, z)) : null;
    }

    public Block getBlockAt(int x, int y, int z) {
        return this.hasBlock(x, y, z) ? this.data.get((Object)new Coordinate((int)x, (int)y, (int)z)).blockID : null;
    }

    public int getMetaAt(int x, int y, int z) {
        return this.hasBlock(x, y, z) ? this.data.get((Object)new Coordinate((int)x, (int)y, (int)z)).metadata : -1;
    }

    public final boolean hasNonAirBlock(int x, int y, int z) {
        Block b = this.getBlockAt(x, y, z);
        return b != null && b != Blocks.field_150350_a && b.func_149688_o() != Material.field_151579_a && !(b instanceof BlockAir);
    }

    @Override
    public Coordinate getRandomBlock() {
        Coordinate a = super.getRandomBlock();
        return a;
    }

    @Override
    public void remove(int x, int y, int z) {
        super.remove(x, y, z);
        this.data.remove(new Coordinate(x, y, z));
    }

    public int getNumberOf(Block id, int meta) {
        int count = 0;
        for (Coordinate li : this.data.keySet()) {
            BlockKey block = this.data.get(li);
            if (!block.match(id, meta)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public BlockArray offset(int x, int y, int z) {
        super.offset(x, y, z);
        HashMap<Coordinate, BlockKey> map = new HashMap<Coordinate, BlockKey>();
        for (Coordinate c : this.data.keySet()) {
            map.put(c.offset(x, y, z), this.data.get(c));
        }
        this.data.clear();
        this.data.putAll(map);
        return this;
    }

    public int getMidX() {
        return this.getMinX() + this.getSizeX() / 2;
    }

    public int getMidY() {
        return this.getMinY() + this.getSizeY() / 2;
    }

    public int getMidZ() {
        return this.getMinZ() + this.getSizeZ() / 2;
    }

    @Override
    public String toString() {
        return this.data.size() + ": " + this.data.toString();
    }

    @Override
    protected BlockArray instantiate() {
        return new StructuredBlockArray(this.world);
    }

    @Override
    public void copyTo(BlockArray copy) {
        super.copyTo(copy);
        if (copy instanceof StructuredBlockArray) {
            ((StructuredBlockArray)copy).data.putAll(this.data);
        }
    }

    @Override
    public void addAll(BlockArray arr) {
        super.addAll(arr);
        if (arr instanceof StructuredBlockArray) {
            this.data.putAll(((StructuredBlockArray)arr).data);
        }
    }

    public ItemHashMap<Integer> getItems() {
        ItemHashMap<Integer> map = new ItemHashMap<Integer>();
        for (Coordinate c : this.data.keySet()) {
            BlockKey bk = this.data.get(c);
            if (bk.blockID instanceof BlockAir || Item.func_150898_a((Block)bk.blockID) == null) continue;
            ItemStack is = bk.asItemStack();
            Integer get = map.get(is);
            int amt = get != null ? get : 0;
            map.put(is, (Integer)(amt + 1));
        }
        return map;
    }

    @Override
    public BlockArray rotate90Degrees(int ox, int oz, boolean left) {
        StructuredBlockArray b = (StructuredBlockArray)super.rotate90Degrees(ox, oz, left);
        for (Coordinate c : this.data.keySet()) {
            BlockKey bc = this.data.get(c);
            Coordinate c2 = c.rotate90About(ox, oz, left);
            b.data.put(c2, bc);
        }
        return b;
    }

    @Override
    public BlockArray rotate180Degrees(int ox, int oz) {
        StructuredBlockArray b = (StructuredBlockArray)super.rotate180Degrees(ox, oz);
        for (Coordinate c : this.data.keySet()) {
            BlockKey bc = this.data.get(c);
            Coordinate c2 = c.rotate180About(ox, oz);
            b.data.put(c2, bc);
        }
        return b;
    }

    @Override
    public void clear() {
        super.clear();
        this.data.clear();
    }

    @Override
    public BlockArray flipX() {
        StructuredBlockArray b = (StructuredBlockArray)super.flipX();
        for (Coordinate c : this.data.keySet()) {
            BlockKey bc = this.data.get(c);
            Coordinate c2 = new Coordinate(-c.xCoord, c.yCoord, c.zCoord);
            b.data.put(c2, bc);
        }
        return b;
    }

    @Override
    public BlockArray flipZ() {
        StructuredBlockArray b = (StructuredBlockArray)super.flipZ();
        for (Coordinate c : this.data.keySet()) {
            BlockKey bc = this.data.get(c);
            Coordinate c2 = new Coordinate(c.xCoord, c.yCoord, -c.zCoord);
            b.data.put(c2, bc);
        }
        return b;
    }
}

