/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data.BlockStruct;

import Reika.DragonAPI.Instantiable.Data.Collections.ThreadSafeSet;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public final class ThreadSafeTileCache
extends ThreadSafeSet<WorldLocation> {
    public Class tileClass = TileEntity.class;

    public ThreadSafeTileCache setTileClass(Class<? extends TileEntity> c) {
        this.tileClass = c;
        return this;
    }

    public void filterInvalidTiles(World world, boolean skipOtherDimension) {
        if (world.field_72995_K || this.tileClass == null) {
            return;
        }
        this.filterElements(val -> {
            boolean other;
            boolean bl = other = val.dimensionID != world.field_73011_w.field_76574_g;
            if (skipOtherDimension && other) {
                return false;
            }
            TileEntity te = other ? val.getTileEntity() : val.getTileEntity((IBlockAccess)world);
            return te == null || !this.tileClass.isAssignableFrom(te.getClass());
        });
    }

    public boolean lookForMatch(World world, boolean skipOtherDimension, TileEntityMatchCheck check) {
        return this.lookForMatch(world, skipOtherDimension, check, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean lookForMatch(World world, boolean skipOtherDimension, TileEntityMatchCheck check, ValidityFailHandler errorHandle) {
        Set set = this.data;
        synchronized (set) {
            Iterator it = this.data.iterator();
            while (it.hasNext()) {
                TileEntity te;
                boolean other;
                WorldLocation val = (WorldLocation)it.next();
                boolean bl = other = val.dimensionID != world.field_73011_w.field_76574_g;
                if (skipOtherDimension && other) continue;
                TileEntity tileEntity = te = other ? val.getTileEntity() : val.getTileEntity((IBlockAccess)world);
                if (te == null && world.field_72995_K) continue;
                if (this.tileClass != null && !this.tileClass.isAssignableFrom(te.getClass())) {
                    it.remove();
                    if (errorHandle == null) continue;
                    errorHandle.handle(val, te);
                    continue;
                }
                if (!check.handle(val, te)) continue;
                return true;
            }
        }
        return false;
    }

    public void applyToMatches(World world, boolean skipOtherDimension, TileEntityMatchEffect check) {
        this.applyToMatches(world, skipOtherDimension, check, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyToMatches(World world, boolean skipOtherDimension, TileEntityMatchEffect check, ValidityFailHandler errorHandle) {
        Set set = this.data;
        synchronized (set) {
            Iterator it = this.data.iterator();
            while (it.hasNext()) {
                TileEntity te;
                boolean other;
                WorldLocation val = (WorldLocation)it.next();
                boolean bl = other = val.dimensionID != world.field_73011_w.field_76574_g;
                if (skipOtherDimension && other) continue;
                TileEntity tileEntity = te = other ? val.getTileEntity() : val.getTileEntity((IBlockAccess)world);
                if (te == null && world.field_72995_K) continue;
                if (this.tileClass != null && !this.tileClass.isAssignableFrom(te.getClass())) {
                    it.remove();
                    if (errorHandle == null) continue;
                    errorHandle.handle(val, te);
                    continue;
                }
                check.handle(val, te);
            }
        }
    }

    public TileEntity returnMatch(World world, boolean skipOtherDimension, TileEntityMatchCheck check) {
        return this.returnMatch(world, skipOtherDimension, check, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TileEntity returnMatch(World world, boolean skipOtherDimension, TileEntityMatchCheck check, ValidityFailHandler errorHandle) {
        Set set = this.data;
        synchronized (set) {
            Iterator it = this.data.iterator();
            while (it.hasNext()) {
                TileEntity te;
                boolean other;
                WorldLocation val = (WorldLocation)it.next();
                boolean bl = other = val.dimensionID != world.field_73011_w.field_76574_g;
                if (skipOtherDimension && other) continue;
                TileEntity tileEntity = te = other ? val.getTileEntity() : val.getTileEntity((IBlockAccess)world);
                if (te == null && world.field_72995_K) continue;
                if (this.tileClass != null && !this.tileClass.isAssignableFrom(te.getClass())) {
                    it.remove();
                    if (errorHandle == null) continue;
                    errorHandle.handle(val, te);
                    continue;
                }
                if (!check.handle(val, te)) continue;
                return te;
            }
        }
        return null;
    }

    @FunctionalInterface
    public static interface ValidityFailHandler {
        public void handle(WorldLocation var1, TileEntity var2);
    }

    @FunctionalInterface
    public static interface TileEntityMatchEffect {
        public void handle(WorldLocation var1, TileEntity var2);
    }

    @FunctionalInterface
    public static interface TileEntityMatchCheck {
        public boolean handle(WorldLocation var1, TileEntity var2);
    }
}

