/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data.Collections;

import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class ItemCollection {
    private final ArrayList<ItemStack> data = new ArrayList();

    public ItemCollection() {
    }

    public ItemCollection(Collection<ItemStack> c) {
        this.add(c);
    }

    public void add(ItemStack is) {
        this.data.add(is);
    }

    public void add(Collection<ItemStack> c) {
        this.data.addAll(c);
    }

    public int count() {
        int ret = 0;
        for (ItemStack is : this.data) {
            ret += is.field_77994_a;
        }
        return ret;
    }

    public void drop(World world, int x, int y, int z) {
        for (ItemStack is : this.data) {
            while (is.field_77994_a > 0) {
                int num = Math.min(is.field_77994_a, is.func_77976_d());
                ItemStack is2 = ReikaItemHelper.getSizedItemStack(is, num);
                is.field_77994_a -= num;
                ReikaItemHelper.dropItem(world, (double)x + world.field_73012_v.nextDouble(), (double)y + world.field_73012_v.nextDouble(), (double)z + world.field_73012_v.nextDouble(), is2);
            }
        }
    }

    public String toString() {
        return this.data.toString();
    }

    public void clear() {
        this.data.clear();
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public void writeToNBT(NBTTagCompound NBT) {
        ReikaNBTHelper.writeCollectionToNBT(this.data, NBT, "items");
    }

    public void readFromNBT(NBTTagCompound NBT) {
        ReikaNBTHelper.readCollectionFromNBT(this.data, NBT, "items");
    }

    public int removeItems(int amt) {
        int ret = 0;
        Iterator<ItemStack> it = this.data.iterator();
        while (it.hasNext()) {
            ItemStack is = it.next();
            int rem = Math.min(is.field_77994_a, amt);
            is.field_77994_a -= rem;
            ret += rem;
            amt -= rem;
            if (is.field_77994_a <= 0) {
                it.remove();
            }
            if (amt > 0) continue;
            break;
        }
        return ret;
    }

    public Collection<ItemStack> getItems() {
        return Collections.unmodifiableCollection(this.data);
    }

    public void removeItem(ItemStack is) {
        this.data.remove(is);
    }

    public void clearEmpties() {
        Iterator<ItemStack> it = this.data.iterator();
        while (it.hasNext()) {
            ItemStack is = it.next();
            if (is.field_77994_a > 0) continue;
            it.remove();
        }
    }
}

