/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data.Collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public class ThreadSafeSet<E>
implements Set<E> {
    protected final Set<E> data = Collections.synchronizedSet(new HashSet());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <R> R iterate(Function<Iterator<E>, R> func) {
        Set<E> set = this.data;
        synchronized (set) {
            return func.apply(this.data.iterator());
        }
    }

    public final void simpleIterate(Consumer<E> func) {
        this.data.forEach(func);
    }

    public final E iterateAsSearch(Function<E, Boolean> check) {
        return this.iterateAsSearch(check, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final E iterateAsSearch(Function<E, Boolean> check, Function<E, Boolean> validity) {
        Set<E> set = this.data;
        synchronized (set) {
            Iterator<E> it = this.data.iterator();
            while (it.hasNext()) {
                boolean valid;
                E val = it.next();
                if (validity != null && !(valid = validity.apply(val).booleanValue())) {
                    it.remove();
                    continue;
                }
                if (!check.apply(val).booleanValue()) continue;
                return val;
            }
        }
        return null;
    }

    public final void filterElements(Predicate<E> check) {
        this.data.removeIf(check);
    }

    @Override
    public final boolean removeIf(Predicate<? super E> filter) {
        return this.data.removeIf(filter);
    }

    @Override
    public final void forEach(Consumer<? super E> filter) {
        this.data.forEach(filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void copyTo(ArrayList<E> li) {
        Set<E> set = this.data;
        synchronized (set) {
            li.clear();
            for (E val : this.data) {
                li.add(val);
            }
        }
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.data.contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        throw new UnsupportedOperationException("This set does not support natural iteration! Use .iterate()!");
    }

    @Override
    public Object[] toArray() {
        return this.data.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.data.toArray(a);
    }

    @Override
    public boolean add(E e) {
        return this.data.add(e);
    }

    @Override
    public boolean remove(Object o) {
        return this.data.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.data.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.data.addAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.data.retainAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.data.removeAll(c);
    }

    @Override
    public void clear() {
        this.data.clear();
    }
}

