/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data;

import java.util.HashSet;

public class GappedRange {
    private final HashSet<Integer> flips = new HashSet();
    private int minValue = Integer.MAX_VALUE;
    private int maxValue = Integer.MIN_VALUE;
    private boolean startsSolid;

    public void addEndpoint(int val, boolean solid) {
        if (val < this.minValue) {
            this.minValue = val;
            this.startsSolid = solid;
        }
        if (val > this.maxValue) {
            this.maxValue = val;
        }
    }

    public void addSolidRange(int from, int to) {
        this.addTransition(from);
        this.addTransition(to);
        if (this.setMinimum(from)) {
            this.startsSolid = true;
        }
        this.maxValue = Math.max(this.maxValue, to);
    }

    public void addGap(int from, int to) {
        this.addTransition(from);
        this.addTransition(to);
        if (this.setMinimum(from)) {
            this.startsSolid = false;
        }
        this.maxValue = Math.max(this.maxValue, to);
    }

    private boolean setMinimum(int min) {
        if (min < this.minValue) {
            this.minValue = min;
            return true;
        }
        return false;
    }

    public void addTransition(int at) {
        if (at != this.minValue && at != this.maxValue) {
            this.flips.add(at);
        }
        if (at == this.minValue) {
            this.startsSolid = !this.startsSolid;
        }
    }

    public boolean isInGap(int at) {
        boolean solid = this.startsSolid;
        for (int flip : this.flips) {
            if (flip > at) continue;
            solid = !solid;
        }
        return !solid;
    }

    public boolean isInRelativeGap(int at) {
        return this.isInGap(at - this.minValue);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean solid = this.startsSolid;
        for (int i = this.minValue; i <= this.maxValue; ++i) {
            if (this.flips.contains(i)) {
                solid = !solid;
            }
            sb.append(solid ? "#" : "O");
        }
        return sb.toString();
    }
}

