/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data.Immutable;

import Reika.DragonAPI.Instantiable.Data.Immutable.DecimalPosition;
import Reika.DragonAPI.Libraries.MathSci.ReikaPhysicsHelper;
import net.minecraft.util.Vec3;

public class Ray {
    public final DecimalPosition origin;
    public final Vec3 directionStep;

    public Ray(DecimalPosition c, double dx, double dy, double dz) {
        this(c, Vec3.func_72443_a((double)dx, (double)dy, (double)dz));
    }

    public static Ray fromPolar(DecimalPosition c, double theta, double phi) {
        double[] xyz = ReikaPhysicsHelper.polarToCartesian(1.0, theta, phi);
        return new Ray(c, xyz[0], xyz[1], xyz[2]);
    }

    public Ray(DecimalPosition c, Vec3 vec) {
        this.origin = c;
        this.directionStep = vec;
    }

    public DecimalPosition getScaledPosition(double d) {
        return this.origin.offset(this.directionStep.field_72450_a * d, this.directionStep.field_72448_b * d, this.directionStep.field_72449_c * d);
    }

    public String toString() {
        return this.origin + " > " + this.directionStep.toString();
    }
}

