/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data.Immutable;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.DimensionManager;

public final class WorldChunk {
    public final int dimensionID;
    public final ChunkCoordIntPair chunk;

    public WorldChunk(World world, Chunk ch) {
        this(world, ch.func_76632_l());
    }

    public WorldChunk(World world, ChunkCoordIntPair ch) {
        this(world.field_73011_w.field_76574_g, ch);
    }

    public WorldChunk(World world, int x, int z) {
        this(world.field_73011_w.field_76574_g, new ChunkCoordIntPair(x, z));
    }

    public WorldChunk(int dim, int x, int z) {
        this(dim, new ChunkCoordIntPair(x, z));
    }

    public WorldChunk(int dim, ChunkCoordIntPair ch) {
        this.dimensionID = dim;
        this.chunk = ch;
    }

    public boolean equals(Object o) {
        if (o instanceof WorldChunk) {
            WorldChunk c = (WorldChunk)o;
            return c.dimensionID == this.dimensionID && c.chunk.equals((Object)this.chunk);
        }
        return false;
    }

    public Chunk load() {
        return DimensionManager.getWorld((int)this.dimensionID).func_72964_e(this.chunk.field_77276_a, this.chunk.field_77275_b);
    }

    public int hashCode() {
        return this.chunk.hashCode() ^ this.dimensionID;
    }

    public String toString() {
        return "Chunk " + this.chunk.toString() + " in DIM" + this.dimensionID;
    }

    public static WorldChunk fromSerialString(String sg) {
        String[] parts = sg.split(",");
        return new WorldChunk(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]), Integer.parseInt(parts[2]));
    }

    public String toSerialString() {
        return this.dimensionID + "," + this.chunk.field_77276_a + "," + this.chunk.field_77275_b;
    }

    public NBTTagCompound writeToTag() {
        NBTTagCompound ret = new NBTTagCompound();
        ret.func_74768_a("dimension", this.dimensionID);
        ret.func_74768_a("xCoord", this.chunk.field_77276_a);
        ret.func_74768_a("zCoord", this.chunk.field_77275_b);
        return ret;
    }

    public static WorldChunk readFromTag(NBTTagCompound tag) {
        return new WorldChunk(tag.func_74762_e("dimension"), tag.func_74762_e("xCoord"), tag.func_74762_e("zCoord"));
    }
}

