/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data.Maps;

import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.world.IBlockAccess;

public final class BlockMap<V> {
    private final HashMap<BlockKey, V> data = new HashMap();

    public V get(BlockKey bk) {
        return this.data.get(bk);
    }

    public V get(Block b, int meta) {
        return this.get(new BlockKey(b, meta));
    }

    public V get(Block b) {
        return this.get(new BlockKey(b, -1));
    }

    public V get(IBlockAccess world, int x, int y, int z) {
        return this.get(BlockKey.getAt(world, x, y, z));
    }

    public V put(BlockKey bk, V obj) {
        return this.data.put(bk, obj);
    }

    public V put(Block b, V obj) {
        return this.put(new BlockKey(b, -1), obj);
    }

    public V put(Block b, int meta, V obj) {
        return this.put(new BlockKey(b, meta), obj);
    }

    public V put(IBlockAccess world, int x, int y, int z, V obj) {
        return this.put(BlockKey.getAt(world, x, y, z), obj);
    }

    public boolean containsKey(BlockKey bk) {
        return this.data.containsKey(bk);
    }

    public boolean containsKey(Block b, int meta) {
        return this.containsKey(new BlockKey(b, meta));
    }

    public boolean containsKey(Block b) {
        return this.containsKey(new BlockKey(b));
    }

    public boolean containsKey(IBlockAccess world, int x, int y, int z) {
        return this.containsKey(BlockKey.getAt(world, x, y, z));
    }

    public void clear() {
        this.data.clear();
    }

    public String toString() {
        return this.data.toString();
    }

    public boolean equals(Object o) {
        return o instanceof BlockMap ? this.data.equals(((BlockMap)o).data) : false;
    }

    public int hashCode() {
        return this.data.hashCode();
    }

    public ArrayList<V> getForBlock(Block b) {
        ArrayList<V> li = new ArrayList<V>();
        for (BlockKey bk : this.data.keySet()) {
            if (bk.blockID != b) continue;
            li.add(this.get(bk));
        }
        return li;
    }

    public ArrayList<V> getForMeta(int meta) {
        ArrayList<V> li = new ArrayList<V>();
        for (BlockKey bk : this.data.keySet()) {
            if (bk.metadata != meta) continue;
            li.add(this.get(bk));
        }
        return li;
    }

    public int size() {
        return this.data.size();
    }

    public Set<BlockKey> keySet() {
        return Collections.unmodifiableSet(this.data.keySet());
    }

    public Collection<V> values() {
        return Collections.unmodifiableCollection(this.data.values());
    }
}

