/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data.Maps;

import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class NestedMap<K, M, V> {
    private final HashMap<K, HashMap<M, V>> data = new HashMap();
    private final MultiMap<M, K> innerSet = new MultiMap(MultiMap.CollectionType.HASHSET);
    private final HashMap<V, Integer> valueSet = new HashMap();

    public V put(K key, M inner, V value) {
        HashMap<Object, V> map = this.data.get(key);
        if (map == null) {
            map = new HashMap();
            this.data.put(key, map);
        }
        this.innerSet.addValue(inner, key);
        this.addValue(value);
        return map.put(inner, value);
    }

    private void addValue(V value) {
        Integer get = this.valueSet.get(value);
        if (get == null) {
            this.valueSet.put((Integer)value, 1);
        } else {
            this.valueSet.put((Integer)value, get + 1);
        }
    }

    private void removeValue(V value) {
        Integer get = this.valueSet.get(value);
        if (get == null) {
            return;
        }
        if (get <= 1) {
            this.valueSet.remove(value);
        } else {
            this.valueSet.put((Integer)value, get - 1);
        }
    }

    public V get(K key, M inner) {
        HashMap<M, V> map = this.data.get(key);
        return map != null ? (V)map.get(inner) : null;
    }

    public void remove(K key) {
        HashMap<M, V> map = this.data.remove(key);
        if (map != null) {
            for (M inner : map.keySet()) {
                this.innerSet.remove(inner, key);
            }
            for (Object value : map.values()) {
                this.removeValue(value);
            }
        }
    }

    public V remove(K key, M inner) {
        HashMap<M, V> map = this.data.get(key);
        if (map != null) {
            if (map.containsKey(inner)) {
                this.innerSet.remove(inner, key);
                this.removeValue(map.get(inner));
            }
            return map.remove(inner);
        }
        return null;
    }

    public void removeAll(M inner) {
        Collection<K> keys = this.innerSet.get(inner);
        for (K key : keys) {
            this.remove(key, inner);
        }
    }

    public int size() {
        return this.valueSet.size();
    }

    public void putAll(NestedMap map) {
        this.data.putAll(map.data);
        this.innerSet.putAll(map.innerSet);
        this.valueSet.putAll(map.valueSet);
    }

    public void clear() {
        this.data.clear();
        this.innerSet.clear();
        this.valueSet.clear();
    }

    public Set<K> keySet() {
        return this.data.keySet();
    }

    public Collection<M> innerSet() {
        return this.innerSet.keySet();
    }

    public Collection<V> values() {
        return Collections.unmodifiableCollection(this.valueSet.keySet());
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public String toString() {
        return this.data.toString();
    }

    public boolean containsValue(V value) {
        return this.valueSet.containsKey(value);
    }

    public boolean containsKey(K key) {
        return this.data.containsKey(key);
    }

    public boolean containsInnerKey(M inner) {
        return this.innerSet.containsKey(inner);
    }

    public Collection<M> getAllKeysIn(K key) {
        HashMap<M, V> map = this.data.get(key);
        return map != null ? map.keySet() : null;
    }

    public Collection<V> getAllValuesIn(K key) {
        HashMap<M, V> map = this.data.get(key);
        return map != null ? map.values() : null;
    }

    public Map<M, V> getMap(K key) {
        HashMap<M, V> map = this.data.get(key);
        return map != null ? Collections.unmodifiableMap(map) : null;
    }

    public K getRandomOuterKey(Random rand) {
        return ReikaJavaLibrary.getRandomCollectionEntry(rand, this.data.keySet());
    }

    public M getRandomInnerKey(Random rand) {
        return ReikaJavaLibrary.getRandomCollectionEntry(rand, this.innerSet.keySet());
    }
}

