/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data.Maps;

import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import java.util.HashMap;
import java.util.HashSet;

public class ProximityMap {
    private final HashMap<Coordinate, Section> data = new HashMap();
    private final int maxPerSection;
    private final int sectionSize;
    public boolean checkYCoord = false;

    public ProximityMap(int step, int max) {
        this.sectionSize = step;
        this.maxPerSection = max;
    }

    public boolean add(Coordinate c) {
        Section s = this.getSection(c, true);
        return s.data.size() < this.maxPerSection && s.data.add(c);
    }

    public boolean remove(Coordinate c) {
        Section s = this.getSection(c, false);
        if (s == null) {
            return false;
        }
        if (s.data.remove(c)) {
            if (s.data.isEmpty()) {
                this.data.remove(s.key);
            }
            return true;
        }
        return false;
    }

    public boolean contains(Coordinate c) {
        Section s = this.getSection(c, false);
        return s != null && s.data.contains(c);
    }

    public HashSet<Coordinate> getLocations() {
        HashSet<Coordinate> set = new HashSet<Coordinate>();
        for (Section s : this.data.values()) {
            set.addAll(s.data);
        }
        return set;
    }

    public int getCountInSection(Coordinate c) {
        Section s = this.getSection(c, false);
        return s != null ? s.data.size() : 0;
    }

    private Section getSection(Coordinate c, boolean create) {
        int x = ReikaMathLibrary.roundDownToX(this.sectionSize, c.xCoord);
        int z = ReikaMathLibrary.roundDownToX(this.sectionSize, c.zCoord);
        int y = this.checkYCoord ? ReikaMathLibrary.roundDownToX(this.sectionSize, c.yCoord) : 0;
        Coordinate p = new Coordinate(x, y, z);
        Section s = this.data.get(p);
        if (create && s == null) {
            s = new Section(p);
            this.data.put(p, s);
        }
        return s;
    }

    public void clear() {
        this.data.clear();
    }

    private static class Section {
        private final Coordinate key;
        private final HashSet<Coordinate> data = new HashSet();

        private Section(Coordinate p) {
            this.key = p;
        }
    }
}

