/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data;

import Reika.DragonAPI.Instantiable.Data.CircularDivisionRenderer;
import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import org.lwjgl.opengl.GL11;

public class Proportionality<F>
extends CircularDivisionRenderer<F> {
    private final Map<F, Double> data;
    private double totalValue = 0.0;
    public boolean drawSeparationLines = false;

    public Proportionality() {
        this(null);
    }

    public Proportionality(MultiMap.MapDeterminator<F, Double> md) {
        this.data = md != null ? md.getMapType() : new HashMap<F, Double>();
    }

    public void addValue(F o, double amt) {
        Double get = this.data.get(o);
        double val = get != null ? get : 0.0;
        this.data.put(o, val + amt);
        this.totalValue += amt;
        if (o instanceof CircularDivisionRenderer.ColorCallback) {
            this.addColorRenderer(o, (CircularDivisionRenderer.ColorCallback)o);
        }
        this.resetColors();
    }

    public double removeValue(F o) {
        Double get = this.data.remove(o);
        if (get != null) {
            this.totalValue -= get.doubleValue();
        }
        this.resetColors();
        return get != null ? get : 0.0;
    }

    public void removeValue(F o, double amt) {
        Double get = this.data.get(o);
        double val = get != null ? get : 0.0;
        double res = val - amt;
        this.totalValue -= Math.min(amt, val);
        if (res > 0.0) {
            this.data.put(o, res);
        } else {
            this.data.remove(o);
        }
        this.resetColors();
    }

    public double getValue(F o) {
        Double get = this.data.get(o);
        return get != null ? get : 0.0;
    }

    public double getFraction(F o) {
        return this.isEmpty() ? 0.0 : this.getValue(o) / this.totalValue;
    }

    public boolean isEmpty() {
        return this.totalValue == 0.0 || this.data.isEmpty();
    }

    @Override
    public Collection<F> getElements() {
        return Collections.unmodifiableCollection(this.data.keySet());
    }

    public boolean hasMajority(F o) {
        return this.getFraction(o) >= 0.5;
    }

    public F getLargestCategory() {
        double max = -1.0;
        F big = null;
        for (F o : this.data.keySet()) {
            double has = this.getValue(o);
            if (!(has > max)) continue;
            has = max;
            big = o;
        }
        return big;
    }

    @Override
    public void clear() {
        this.data.clear();
        this.totalValue = 0.0;
        this.resetColors();
    }

    @Override
    public F getClickedSection(int x, int y) {
        double d = ReikaMathLibrary.py3d((double)x - this.centerX, (double)y - this.centerY, 0.0);
        if (d > this.renderRadius) {
            return null;
        }
        double relAng = (Math.toDegrees(Math.atan2((double)y - this.centerY, (double)x - this.centerX)) + 360.0) % 360.0 - this.renderOrigin;
        relAng = (relAng % 360.0 + 360.0) % 360.0;
        double ang = 0.0;
        for (F o : this.data.keySet()) {
            double angw = 360.0 * this.getFraction(o);
            if (ang <= relAng && ang + angw >= relAng) {
                return o;
            }
            ang += angw;
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(Map<F, Integer> colorMap) {
        double angw;
        GL11.glPushAttrib((int)1048575);
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2884);
        double ang = this.renderOrigin;
        Tessellator v5 = Tessellator.field_78398_a;
        boolean i = false;
        for (F o : this.data.keySet()) {
            angw = 360.0 * this.getFraction(o);
            v5.func_78371_b(this.innerRadius == 0.0 ? 6 : 5);
            int c = this.getColorForElement(o, colorMap);
            v5.func_78378_d(c);
            this.renderSection(v5, ang, ang + angw);
            v5.func_78381_a();
            ang += angw;
        }
        if (this.drawSeparationLines && this.data.size() > 1) {
            v5.func_78371_b(1);
            v5.func_78378_d(0);
            for (F o : this.data.keySet()) {
                double d2;
                angw = 360.0 * this.getFraction(o);
                if (this.innerRadius == 0.0) {
                    v5.func_78377_a(this.centerX, this.centerY, 0.0);
                    d2 = Math.toRadians(ang);
                    double r2 = this.getOuterRadiusAt(d2);
                    double dx = this.centerX + r2 * Math.cos(d2);
                    double dy = this.centerY + r2 * Math.sin(d2);
                    v5.func_78377_a(dx, dy, 0.0);
                } else {
                    d2 = Math.toRadians(ang);
                    double r1 = this.getInnerRadiusAt(d2);
                    double r2 = this.getOuterRadiusAt(d2);
                    double dx1 = this.centerX + r1 * Math.cos(d2);
                    double dy1 = this.centerY + r1 * Math.sin(d2);
                    double dx2 = this.centerX + r2 * Math.cos(d2);
                    double dy2 = this.centerY + r2 * Math.sin(d2);
                    v5.func_78377_a(dx1, dy1, 0.0);
                    v5.func_78377_a(dx2, dy2, 0.0);
                }
                ang += angw;
            }
            v5.func_78381_a();
        }
        GL11.glPopAttrib();
    }

    public void writeToNBT(NBTTagCompound NBT, ReikaNBTHelper.NBTIO<F> converter) {
        NBT.func_74780_a("total", this.totalValue);
        NBT.func_74757_a("lines", this.drawSeparationLines);
        NBTTagList li = new NBTTagList();
        for (Map.Entry<F, Double> e : this.data.entrySet()) {
            NBTTagCompound tag = new NBTTagCompound();
            NBTBase key = converter.convertToNBT(e.getKey());
            tag.func_74780_a("value", e.getValue().doubleValue());
            tag.func_74782_a("key", key);
            li.func_74742_a((NBTBase)tag);
        }
        NBT.func_74782_a("data", (NBTBase)li);
    }

    public void readFromNBT(NBTTagCompound NBT, ReikaNBTHelper.NBTIO<F> converter) {
        this.totalValue = NBT.func_74769_h("total");
        this.drawSeparationLines = NBT.func_74767_n("lines");
        this.data.clear();
        NBTTagList li = NBT.func_150295_c("data", ReikaNBTHelper.NBTTypes.COMPOUND.ID);
        for (Object o : li.field_74747_a) {
            NBTTagCompound tag = (NBTTagCompound)o;
            F obj = converter.createFromNBT(tag.func_74781_a("key"));
            double val = tag.func_74769_h("value");
            this.data.put(obj, val);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (F f : this.data.keySet()) {
            sb.append(f.toString());
            sb.append(": ");
            sb.append(String.valueOf(this.getFraction(f) * 100.0));
            sb.append("%; ");
        }
        return sb.toString();
    }

    public String mapString() {
        return this.data.toString();
    }

    public Proportionality<F> copy() {
        Proportionality<F> ret = new Proportionality<F>();
        ret.data.putAll(this.data);
        ret.totalValue = this.totalValue;
        return ret;
    }
}

