/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Effects;

import Reika.DragonAPI.Instantiable.Data.Immutable.DecimalPosition;
import Reika.DragonAPI.Instantiable.Math.Spline;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import java.util.List;
import java.util.Random;
import java.util.function.Function;

public class LightningBolt {
    public final int nsteps;
    private final double[] varianceX;
    private final double[] varianceY;
    private final double[] varianceZ;
    private final double[] velocityX;
    private final double[] velocityY;
    private final double[] velocityZ;
    public final DecimalPosition start;
    public final DecimalPosition end;
    private final DecimalPosition[] middle;
    private final double[][] offsets;
    private final double[][] offsetTargets;
    private Random rand = new Random();

    public LightningBolt(double x1, double y1, double z1, double x2, double y2, double z2, int steps) {
        this(new DecimalPosition(x1, y1, z1), new DecimalPosition(x2, y2, z2), steps);
    }

    public LightningBolt(DecimalPosition p1, DecimalPosition p2, int steps) {
        this.nsteps = steps;
        this.start = p1;
        this.end = p2;
        this.varianceX = new double[this.nsteps + 1];
        this.varianceY = new double[this.nsteps + 1];
        this.varianceZ = new double[this.nsteps + 1];
        this.velocityX = new double[this.nsteps + 1];
        this.velocityY = new double[this.nsteps + 1];
        this.velocityZ = new double[this.nsteps + 1];
        this.offsets = new double[this.nsteps + 1][3];
        this.offsetTargets = new double[this.nsteps + 1][3];
        this.middle = new DecimalPosition[this.nsteps + 1];
        for (int i = 0; i < this.middle.length; ++i) {
            double dx = p1.xCoord + (p2.xCoord - p1.xCoord) * (double)i / (double)this.nsteps;
            double dy = p1.yCoord + (p2.yCoord - p1.yCoord) * (double)i / (double)this.nsteps;
            double dz = p1.zCoord + (p2.zCoord - p1.zCoord) * (double)i / (double)this.nsteps;
            this.middle[i] = new DecimalPosition(dx, dy, dz);
        }
    }

    public LightningBolt maximize() {
        for (int i = 1; i < this.nsteps; ++i) {
            double tx = ReikaRandomHelper.getRandomPlusMinus(0.0, this.varianceX[i], this.rand);
            double ty = ReikaRandomHelper.getRandomPlusMinus(0.0, this.varianceY[i], this.rand);
            double tz = ReikaRandomHelper.getRandomPlusMinus(0.0, this.varianceZ[i], this.rand);
            this.offsets[i][0] = tx;
            this.offsets[i][1] = ty;
            this.offsets[i][2] = tz;
        }
        return this;
    }

    public void update() {
        for (int i = 1; i < this.nsteps; ++i) {
            double dx = this.offsets[i][0];
            double dy = this.offsets[i][1];
            double dz = this.offsets[i][2];
            double tx = this.offsetTargets[i][0];
            double ty = this.offsetTargets[i][1];
            double tz = this.offsetTargets[i][2];
            if (ReikaMathLibrary.approxr(dx, tx, this.varianceX[i] / 8.0)) {
                tx = ReikaRandomHelper.getRandomPlusMinus(0.0, this.varianceX[i], this.rand);
            }
            if (ReikaMathLibrary.approxr(dy, ty, this.varianceY[i] / 8.0)) {
                ty = ReikaRandomHelper.getRandomPlusMinus(0.0, this.varianceY[i], this.rand);
            }
            if (ReikaMathLibrary.approxr(dz, tz, this.varianceZ[i] / 8.0)) {
                tz = ReikaRandomHelper.getRandomPlusMinus(0.0, this.varianceZ[i], this.rand);
            }
            if (tx > dx) {
                dx += this.velocityX[i];
            } else if (tx < dx) {
                dx -= this.velocityX[i];
            }
            if (ty > dy) {
                dy += this.velocityY[i];
            } else if (ty < dy) {
                dy -= this.velocityY[i];
            }
            if (tz > dz) {
                dz += this.velocityZ[i];
            } else if (tz < dz) {
                dz -= this.velocityZ[i];
            }
            this.offsets[i][0] = dx;
            this.offsets[i][1] = dy;
            this.offsets[i][2] = dz;
            this.offsetTargets[i][0] = tx;
            this.offsetTargets[i][1] = ty;
            this.offsetTargets[i][2] = tz;
        }
    }

    public DecimalPosition getPosition(int n) {
        return new DecimalPosition(this.middle[n].xCoord + this.offsets[n][0], this.middle[n].yCoord + this.offsets[n][1], this.middle[n].zCoord + this.offsets[n][2]);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Bolt [");
        for (int i = 0; i <= this.nsteps; ++i) {
            sb.append(this.getPosition(i));
            if (i >= this.nsteps) continue;
            sb.append(" > ");
        }
        sb.append("];");
        return sb.toString();
    }

    public List<DecimalPosition> spline(Spline.SplineType type, int points) {
        Spline path = new Spline(type);
        for (int i = 0; i <= this.nsteps; ++i) {
            path.addPoint(new Spline.BasicSplinePoint(this.getPosition(i)));
        }
        return path.get(points, false);
    }

    public LightningBolt setRandom(Random r) {
        this.rand = r;
        return this;
    }

    public LightningBolt setVariance(double v) {
        return this.setVariance(v, v, v);
    }

    public LightningBolt setVariance(double vx, double vy, double vz) {
        return this.setVariance(vx, vy, vz, null, null, null);
    }

    public LightningBolt setVariance(double vx, double vy, double vz, Function<Integer, Double> funcX, Function<Integer, Double> funcY, Function<Integer, Double> funcZ) {
        for (int i = 0; i < this.varianceX.length; ++i) {
            this.varianceX[i] = vx;
            this.varianceY[i] = vy;
            this.varianceZ[i] = vz;
            if (funcX != null) {
                int n = i;
                this.varianceX[n] = this.varianceX[n] * funcX.apply(i);
            }
            if (funcY != null) {
                int n = i;
                this.varianceY[n] = this.varianceY[n] * funcY.apply(i);
            }
            if (funcZ == null) continue;
            int n = i;
            this.varianceZ[n] = this.varianceZ[n] * funcZ.apply(i);
        }
        return this;
    }

    public LightningBolt setVariance(double[] vx, double[] vy, double[] vz) {
        for (int i = 0; i < this.varianceX.length; ++i) {
            this.varianceX[i] = vx[i];
            this.varianceY[i] = vy[i];
            this.varianceZ[i] = vz[i];
        }
        return this;
    }

    public LightningBolt setVelocity(double v) {
        return this.setVelocity(v, v, v);
    }

    public LightningBolt setVelocity(double vx, double vy, double vz) {
        return this.setVelocity(vx, vy, vz, null, null, null);
    }

    public LightningBolt setVelocity(double vx, double vy, double vz, Function<Integer, Double> funcX, Function<Integer, Double> funcY, Function<Integer, Double> funcZ) {
        for (int i = 0; i < this.varianceX.length; ++i) {
            this.velocityX[i] = vx;
            this.velocityY[i] = vy;
            this.velocityZ[i] = vz;
            if (funcX != null) {
                int n = i;
                this.velocityX[n] = this.velocityX[n] * funcX.apply(i);
            }
            if (funcY != null) {
                int n = i;
                this.velocityY[n] = this.velocityY[n] * funcY.apply(i);
            }
            if (funcZ == null) continue;
            int n = i;
            this.velocityZ[n] = this.velocityZ[n] * funcZ.apply(i);
        }
        return this;
    }

    public LightningBolt setVelocity(double[] vx, double[] vy, double[] vz) {
        for (int i = 0; i < this.velocityX.length; ++i) {
            this.velocityX[i] = vx[i];
            this.velocityY[i] = vy[i];
            this.velocityZ[i] = vz[i];
        }
        return this;
    }

    public LightningBolt scaleVariance(double v) {
        return this.scaleVariance(v, v, v);
    }

    public LightningBolt scaleVariance(double vx, double vy, double vz) {
        int i = 0;
        while (i < this.varianceX.length) {
            int n = i;
            this.varianceX[n] = this.varianceX[n] * vx;
            int n2 = i;
            this.varianceY[n2] = this.varianceY[n2] * vy;
            int n3 = i++;
            this.varianceZ[n3] = this.varianceZ[n3] * vz;
        }
        return this;
    }

    public LightningBolt scaleVelocity(double v) {
        return this.scaleVelocity(v, v, v);
    }

    public LightningBolt scaleVelocity(double vx, double vy, double vz) {
        int i = 0;
        while (i < this.varianceX.length) {
            int n = i;
            this.velocityX[n] = this.velocityX[n] * vx;
            int n2 = i;
            this.velocityY[n2] = this.velocityY[n2] * vy;
            int n3 = i++;
            this.velocityZ[n3] = this.velocityZ[n3] * vz;
        }
        return this;
    }

    public LightningBolt setVelocity(LightningBolt b) {
        return this.setVelocity(b.velocityX, b.velocityY, b.velocityZ);
    }

    public LightningBolt setVariance(LightningBolt b) {
        return this.setVariance(b.varianceX, b.varianceY, b.varianceZ);
    }
}

