/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Event;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Worldgen.LootController;
import cpw.mods.fml.common.eventhandler.Event;
import net.minecraft.inventory.IInventory;
import net.minecraftforge.common.MinecraftForge;

public class ChestLootEvent
extends Event {
    public final IInventory inventory;
    public final String chestID;

    public ChestLootEvent(IInventory ii, String loc) {
        this.chestID = loc;
        this.inventory = ii;
    }

    public static void fire(Object struct, IInventory ii) {
        String table = ChestLootEvent.calculateTable(struct);
        if (table != null) {
            MinecraftForge.EVENT_BUS.post((Event)new ChestLootEvent(ii, table));
        } else {
            DragonAPICore.logError("Tried to fire an event for chest loot from an unrecognized structure " + struct + "!");
        }
    }

    private static String calculateTable(Object struct) {
        LootController.ChestGenLootLocation find = LootController.getLocationForStructure(struct);
        return find != null ? find.getTag() : null;
    }
}

