/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Event.Client;

import Reika.DragonAPI.Instantiable.Event.Base.PositionEventBase;
import Reika.DragonAPI.Instantiable.Event.Base.WorldPositionEvent;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;

@SideOnly(value=Side.CLIENT)
public class LightVisualBrightnessEvent
extends WorldPositionEvent {
    public final int lightLevel;
    public final float originalValue;
    public float brightness;

    public LightVisualBrightnessEvent(World world, int x, int y, int z, int light) {
        super(world, x, y, z);
        this.brightness = this.originalValue = this.getBrightnessFor(light);
        this.lightLevel = light;
    }

    public float getBrightnessFor(int light) {
        return this.world.field_73011_w.field_76573_f[light];
    }

    public static float fire(World world, int x, int y, int z) {
        int light = world.func_72957_l(x, y, z);
        LightVisualBrightnessEvent evt = new LightVisualBrightnessEvent(world, x, y, z, light);
        MinecraftForge.EVENT_BUS.post((Event)evt);
        return evt.brightness;
    }

    public static int fireMixed(int orig, IBlockAccess world, int x, int y, int z, int sky, int block) {
        LightMixedBrightnessEvent evt = new LightMixedBrightnessEvent(world, x, y, z, block, sky, orig);
        MinecraftForge.EVENT_BUS.post((Event)evt);
        return evt.value;
    }

    public static class LightMixedBrightnessEvent
    extends PositionEventBase {
        public final int blockLight;
        public final int skyLight;
        public final int originalValue;
        public int value;

        public LightMixedBrightnessEvent(IBlockAccess world, int x, int y, int z, int bl, int skyl, int orig) {
            super(world, x, y, z);
            this.blockLight = bl;
            this.skyLight = skyl;
            this.originalValue = orig;
            this.value = orig;
        }

        public int getBrightnessFor(int block, int sky) {
            return sky << 20 | block << 4;
        }
    }
}

