/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Event.Client;

import Reika.DragonAPI.Interfaces.Callbacks.EventWatchers;
import Reika.DragonAPI.Libraries.Java.ReikaArrayHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.WorldRenderer;

public class RenderBlockAtPosEvent {
    private static BlockRenderWatcher[] listeners = null;
    private static AdvancedBlockRenderWatcher[] advancedListeners = null;
    public static boolean continueRendering = false;

    public static void addListener(BlockRenderWatcher l) {
        listeners = ReikaArrayHelper.addToFastArray(listeners, l, BlockRenderWatcher.class);
        Arrays.sort(listeners, EventWatchers.comparator);
        if (l instanceof AdvancedBlockRenderWatcher) {
            advancedListeners = ReikaArrayHelper.addToFastArray(advancedListeners, (AdvancedBlockRenderWatcher)l, AdvancedBlockRenderWatcher.class);
            Arrays.sort(advancedListeners, EventWatchers.comparator);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean fire(RenderBlocks rb, Block b, int x, int y, int z, WorldRenderer wr, int pass) {
        if (listeners != null) {
            continueRendering = false;
            for (BlockRenderWatcher l : listeners) {
                if (!l.onBlockTriedRender(b, x, y, z, wr, rb, pass)) continue;
                return false;
            }
        }
        return rb.func_147805_b(b, x, y, z) || continueRendering;
    }

    public static boolean checkCanRenderPass(Block b, int pass, int x, int y, int z) {
        if (advancedListeners != null) {
            for (AdvancedBlockRenderWatcher l : advancedListeners) {
                if (!l.tryRenderInPass(b, x, y, z, pass)) continue;
                return true;
            }
        }
        return b.canRenderInPass(pass);
    }

    public static int getMaxRenderPass(Block b, int x, int y, int z) {
        int ret = b.func_149701_w();
        if (advancedListeners != null) {
            for (AdvancedBlockRenderWatcher l : advancedListeners) {
                ret = Math.max(ret, l.getMaxRenderPass(b, x, y, z));
            }
        }
        return ret;
    }

    public static interface AdvancedBlockRenderWatcher
    extends BlockRenderWatcher {
        @SideOnly(value=Side.CLIENT)
        public int getMaxRenderPass(Block var1, int var2, int var3, int var4);

        @SideOnly(value=Side.CLIENT)
        public boolean tryRenderInPass(Block var1, int var2, int var3, int var4, int var5);
    }

    public static interface BlockRenderWatcher
    extends EventWatchers.EventWatcher {
        @SideOnly(value=Side.CLIENT)
        public boolean onBlockTriedRender(Block var1, int var2, int var3, int var4, WorldRenderer var5, RenderBlocks var6, int var7);
    }
}

