/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Event;

import Reika.DragonAPI.Instantiable.Event.Base.WorldPositionEvent;
import cpw.mods.fml.common.eventhandler.Event;
import net.minecraft.entity.Entity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityEvent;

public class EntityCollisionEvents {
    public static AxisAlignedBB getInterceptedCollisionBox(Entity e, World world, int x, int y, int z) {
        CollisionBoxEvent evt = new CollisionBoxEvent(e, world, x, y, z);
        MinecraftForge.EVENT_BUS.post((Event)evt);
        return evt.box;
    }

    public static MovingObjectPosition getInterceptedRaytrace(Entity e, Vec3 vec1, Vec3 vec2) {
        return EntityCollisionEvents.getInterceptedRaytrace(e, vec1, vec2, false, false, false);
    }

    public static MovingObjectPosition getInterceptedRaytrace(Entity e, Vec3 vec1, Vec3 vec2, boolean b1, boolean b2, boolean b3) {
        RaytraceEvent evt = new RaytraceEvent(e, vec1, vec2, b1, b2, b3);
        MinecraftForge.EVENT_BUS.post((Event)evt);
        return evt.result;
    }

    public static class RaytraceEvent
    extends EntityEvent {
        public MovingObjectPosition result;
        public final Vec3 pos1;
        public final Vec3 pos2;
        public final boolean flag1;
        public final boolean flag2;
        public final boolean flag3;

        public RaytraceEvent(Entity e, Vec3 vec1, Vec3 vec2, boolean b1, boolean b2, boolean b3) {
            super(e);
            this.pos1 = vec1;
            this.pos2 = vec2;
            this.flag1 = b1;
            this.flag2 = b2;
            this.flag3 = b3;
            this.result = this.getDefaultResult();
        }

        public MovingObjectPosition getDefaultResult() {
            return this.entity.field_70170_p.func_147447_a(this.pos1, this.pos2, this.flag1, this.flag2, this.flag3);
        }
    }

    public static class CollisionBoxEvent
    extends WorldPositionEvent {
        public final Entity entity;
        public AxisAlignedBB box;

        public CollisionBoxEvent(Entity e, World world, int x, int y, int z) {
            super(world, x, y, z);
            this.entity = e;
            this.box = this.getDefaultAABB();
        }

        public AxisAlignedBB getDefaultAABB() {
            return this.getBlock().func_149668_a(this.world, this.xCoord, this.yCoord, this.zCoord);
        }
    }
}

