/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Event;

import cpw.mods.fml.common.eventhandler.Cancelable;
import cpw.mods.fml.common.eventhandler.Event;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;

public class SlotEvent
extends Event {
    public final int slotID;
    public final IInventory inventory;

    public SlotEvent(int id, IInventory ii) {
        this.slotID = id;
        this.inventory = ii;
    }

    @Cancelable
    public static class InitialClickEvent
    extends SlotEvent {
        public final Container container;
        public final EntityPlayer player;
        public final int mouseButton;
        public final int modifiers;

        public InitialClickEvent(Container c, int id, int b, int m, EntityPlayer ep) {
            super(id, InitialClickEvent.getInvFromSlot(c, id));
            this.container = c;
            this.player = ep;
            this.mouseButton = b;
            this.modifiers = m;
        }

        private static IInventory getInvFromSlot(Container c, int id) {
            if (id < 0) {
                return null;
            }
            if (id >= c.field_75151_b.size()) {
                return null;
            }
            Slot s = c.func_75139_a(id);
            return s != null ? s.field_75224_c : null;
        }

        public static boolean fire(Container c, int idx, int button, int modifiers, EntityPlayer ep) {
            return MinecraftForge.EVENT_BUS.post((Event)new InitialClickEvent(c, idx, button, modifiers, ep));
        }
    }

    public static class RemoveFromSlotEvent
    extends SlotEvent {
        private final ItemStack removed;
        public final EntityPlayer player;

        public RemoveFromSlotEvent(int id, IInventory ii, ItemStack is, EntityPlayer ep) {
            super(id, ii);
            this.removed = is;
            this.player = ep;
        }

        public final ItemStack getItem() {
            return this.removed != null ? this.removed.func_77946_l() : this.removed;
        }
    }

    public static class AddToSlotEvent
    extends SlotEvent {
        private final ItemStack added;
        private final ItemStack previous;
        private static Slot currentSlotCall;

        public AddToSlotEvent(int id, IInventory ii, ItemStack is, ItemStack pre) {
            super(id, ii);
            this.added = is;
            this.previous = pre;
        }

        public final ItemStack getItem() {
            return this.added != null ? this.added.func_77946_l() : this.added;
        }

        public final ItemStack getPreviousItem() {
            return this.previous != null ? this.previous.func_77946_l() : this.previous;
        }

        public static void fire(Slot s, ItemStack is) {
            if (currentSlotCall == s) {
                return;
            }
            currentSlotCall = s;
            MinecraftForge.EVENT_BUS.post((Event)new AddToSlotEvent(s.getSlotIndex(), s.field_75224_c, is, s.func_75211_c()));
            currentSlotCall = null;
        }
    }

    @Cancelable
    public static class ClickItemInSlotEvent
    extends SlotEvent {
        public final int buttonID;
        public final ItemStack itemInSlot;
        public final Slot slot;
        public final EntityPlayer player;

        public ClickItemInSlotEvent(int id, IInventory ii, Slot s, EntityPlayer ep, int button) {
            super(id, ii);
            this.slot = s;
            this.itemInSlot = this.slot.func_75211_c();
            this.player = ep;
            this.buttonID = button;
        }

        public static boolean fire(Slot s, EntityPlayer ep, int button) {
            if (MinecraftForge.EVENT_BUS.post((Event)new ClickItemInSlotEvent(s.getSlotIndex(), s.field_75224_c, s, ep, button))) {
                return false;
            }
            return s.func_82869_a(ep);
        }
    }
}

