/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.GUI;

import Reika.DragonAPI.Interfaces.Registry.TileEnum;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.Rendering.ReikaGuiAPI;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.block.Block;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public interface GuiItemDisplay
extends Comparable<GuiItemDisplay> {
    @SideOnly(value=Side.CLIENT)
    public void draw(FontRenderer var1, int var2, int var3);

    public boolean isEmpty();

    public static interface IconProvider {
        public IIcon getIcon();
    }

    public static class GuiIconDisplay
    implements GuiItemDisplay {
        public final IconProvider iconFetch;

        public GuiIconDisplay(IIcon ico) {
            this(() -> ico);
        }

        public GuiIconDisplay(IconProvider ico) {
            this.iconFetch = ico;
        }

        private IIcon getIcon() {
            return this.iconFetch == null ? ReikaTextureHelper.getMissingIcon() : this.iconFetch.getIcon();
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void draw(FontRenderer fr, int x, int y) {
            ReikaTextureHelper.bindTerrainTexture();
            ReikaGuiAPI.instance.func_94065_a(x, y, this.getIcon(), 16, 16);
        }

        @Override
        public int compareTo(GuiItemDisplay o) {
            return o instanceof GuiIconDisplay ? this.getIcon().func_94215_i().compareToIgnoreCase(((GuiIconDisplay)o).getIcon().func_94215_i()) : -1;
        }

        @Override
        public boolean isEmpty() {
            return this.iconFetch == null;
        }
    }

    public static class GuiStackListDisplay
    extends GuiMultiStackDisplay {
        private final ArrayList<ItemStack> items = new ArrayList();
        public int cycleSpeed = 1000;

        public GuiStackListDisplay() {
        }

        public GuiStackListDisplay(ItemStack ... c) {
            this.addItems(c);
        }

        public GuiStackListDisplay(Collection<ItemStack> c) {
            this.addItems(c);
        }

        public GuiStackListDisplay addItems(Collection<ItemStack> li) {
            this.items.addAll(li);
            Collections.sort(this.items, ReikaItemHelper.comparator);
            return this;
        }

        public GuiStackListDisplay addItems(ItemStack ... li) {
            for (ItemStack is : li) {
                this.items.add(is);
            }
            Collections.sort(this.items, ReikaItemHelper.comparator);
            return this;
        }

        public GuiItemDisplay setCycleSpeed(int speed) {
            this.cycleSpeed = speed;
            return this;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        protected ItemStack chooseItem() {
            int idx = (int)(System.currentTimeMillis() / (long)(GuiScreen.func_146272_n() ? this.cycleSpeed / 4 : this.cycleSpeed) % (long)this.items.size());
            return this.items.get(idx);
        }

        @Override
        public boolean isEmpty() {
            return this.items.isEmpty();
        }

        @Override
        public int compareTo(GuiItemDisplay o) {
            return o instanceof GuiStackListDisplay ? ReikaItemHelper.itemListComparator.compare(this.items, ((GuiStackListDisplay)o).items) : 1;
        }
    }

    public static abstract class GuiMultiStackDisplay
    extends GuiStackDisplay {
        public GuiMultiStackDisplay() {
            super((ItemStack)null);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void draw(FontRenderer fr, int x, int y) {
            this.item = this.chooseItem();
            super.draw(fr, x, y);
        }

        protected abstract ItemStack chooseItem();

        @Override
        public abstract boolean isEmpty();

        @Override
        public abstract int compareTo(GuiItemDisplay var1);
    }

    public static class GuiStackDisplay
    implements GuiItemDisplay {
        protected ItemStack item;

        public GuiStackDisplay(String s) {
            this(ReikaItemHelper.lookupItem(s));
        }

        public GuiStackDisplay(TileEnum m) {
            this(m.getCraftedProduct());
        }

        public GuiStackDisplay(Item b) {
            this(new ItemStack(b));
        }

        public GuiStackDisplay(Block b) {
            this(new ItemStack(b));
        }

        public GuiStackDisplay(ItemStack is) {
            this.item = is == null ? null : is.func_77946_l();
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void draw(FontRenderer fr, int x, int y) {
            if (this.item != null) {
                ReikaGuiAPI.instance.drawItemStackWithTooltip(ReikaGuiAPI.itemRenderer, fr, this.item, x, y);
            }
        }

        @Override
        public boolean isEmpty() {
            return this.item == null || this.item.func_77973_b() == null;
        }

        @Override
        public int compareTo(GuiItemDisplay o) {
            return o instanceof GuiStackDisplay ? ReikaItemHelper.comparator.compare(this.item, ((GuiStackDisplay)o).item) : 1;
        }

        public ItemStack getItem() {
            return this.isEmpty() ? null : this.item.func_77946_l();
        }
    }
}

