/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.GUI;

import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaMusicHelper;
import Reika.DragonAPI.Libraries.Rendering.ReikaColorAPI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Tessellator;
import org.lwjgl.opengl.GL11;

public class PianoWheel {
    public final ReikaMusicHelper.MusicKey root;
    public final int octaveRange;
    public final int radius;
    public final int originX;
    public final int originY;
    private final int innerRadius;
    private final PianoGui guiInstance;
    private final TreeMap<Integer, Ring> rings = new TreeMap();
    private final ArrayList<Ring> ringList = new ArrayList();
    private final HashMap<ReikaMusicHelper.MusicKey, Integer> colorTag = new HashMap();
    private static final int WHITE_COLOR = 0xEFEFEF;
    private static final int BLACK_COLOR = 0x161616;

    public PianoWheel(PianoGui gui, ReikaMusicHelper.MusicKey start, int octaves, int r, int x, int y, boolean linearDivision) {
        int i;
        this.root = start;
        this.octaveRange = octaves;
        this.radius = r;
        this.guiInstance = gui;
        this.originX = x;
        this.originY = y;
        int tr = this.innerRadius = (int)((double)this.radius / ((double)this.octaveRange * 1.8));
        int[] split = new int[this.octaveRange];
        for (i = 0; i < this.octaveRange; ++i) {
            split[i] = (this.radius - this.innerRadius) / this.octaveRange;
        }
        if (!linearDivision) {
            int i2;
            int mid = this.octaveRange / 2;
            int d = 12 / this.octaveRange;
            if (this.octaveRange % 2 == 0) {
                for (i2 = 0; i2 < mid; ++i2) {
                    int n = mid - 1 - i2;
                    split[n] = split[n] + d * (i2 + 1);
                    int n2 = mid + i2;
                    split[n2] = split[n2] - d * (i2 + 1);
                }
            } else {
                for (i2 = 1; i2 < mid; ++i2) {
                    int n = mid - i2;
                    split[n] = split[n] + d * (i2 + 1);
                    int n3 = mid + i2;
                    split[n3] = split[n3] - d * (i2 + 1);
                }
            }
        }
        for (i = 0; i < this.octaveRange; ++i) {
            int dr = split[i];
            int rmin = tr;
            int rmax = tr + dr;
            tr += dr;
            Ring rng = new Ring(rmin, rmax);
            for (int k = 0; k < 12; ++k) {
                ReikaMusicHelper.MusicKey key = ReikaMusicHelper.MusicKey.getByIndex(this.root.ordinal() + 1 + k + i * 12);
                rng.sections.put(k * 30, key);
            }
            this.rings.put(rmin, rng);
            this.ringList.add(rng);
        }
    }

    public void mouseClicked(int b, int x, int y) {
        ReikaMusicHelper.MusicKey key;
        if (b == 0 && (key = this.getKey(x, y)) != null) {
            this.guiInstance.onKeyPressed(key);
            this.colorTag.put(key, 40);
        }
    }

    private ReikaMusicHelper.MusicKey getKey(int x, int y) {
        int dx = x - this.originX;
        int dy = y - this.originY;
        int r = (int)ReikaMathLibrary.py3d(dx, 0.0, dy);
        if (r > this.radius) {
            return null;
        }
        if (r <= this.innerRadius) {
            return this.root;
        }
        int ang = 90 + (int)Math.toDegrees(Math.atan2(dy, dx)) - 15;
        ang = (ang % 360 + 360) % 360;
        return this.getRing(r).getSection(ang);
    }

    private Ring getRing(int r) {
        return this.rings.get(this.rings.floorKey(r));
    }

    private int getColor(ReikaMusicHelper.MusicKey key) {
        int val;
        float f;
        int c;
        int n = c = key.getNote().isPure() ? 0xEFEFEF : 0x161616;
        if (this.colorTag.containsKey((Object)key) && (f = Math.min(1.0f, (float)(val = this.colorTag.get((Object)key).intValue()) / 32.0f)) > 0.0f) {
            int c1 = this.guiInstance.getColor(key);
            c = f < 1.0f ? ReikaColorAPI.mixColors(c1, c, f) : c1;
            if (val > 1) {
                this.colorTag.put(key, val - 1);
            } else {
                this.colorTag.remove((Object)key);
            }
        }
        return c;
    }

    public void draw(boolean label, boolean verbose, boolean renderLines) {
        int i;
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        Tessellator v5 = Tessellator.field_78398_a;
        GL11.glPushAttrib((int)1048575);
        GL11.glDisable((int)3553);
        v5.func_78371_b(6);
        v5.func_78378_d(this.getColor(this.root));
        v5.func_78377_a((double)this.originX, (double)this.originY, 0.0);
        for (i = 0; i <= 360; i += 2) {
            double dx = (double)this.innerRadius * Math.sin(Math.toRadians(i));
            double dy = (double)this.innerRadius * Math.cos(Math.toRadians(i));
            v5.func_78377_a((double)this.originX + dx, (double)this.originY + dy, 0.0);
        }
        v5.func_78381_a();
        if (label) {
            GL11.glEnable((int)3553);
            String s = this.root.displayName();
            fr.func_78276_b(s, this.originX - fr.func_78256_a(s) / 2, this.originY - fr.field_78288_b / 2, this.root.getNote().isPure() ? 0 : 0xFFFFFF);
            GL11.glDisable((int)3553);
        }
        for (i = 0; i < this.octaveRange; ++i) {
            int k;
            Ring r = this.ringList.get(i);
            for (k = 0; k < 12; ++k) {
                ReikaMusicHelper.MusicKey key = ReikaMusicHelper.MusicKey.getByIndex(this.root.ordinal() + 1 + k + i * 12);
                if (key == null) {
                    ReikaJavaLibrary.pConsole(1 + k + i * 12 + " above " + (Object)((Object)this.root) + " is null??  i=" + i + ",  k=" + k);
                    continue;
                }
                int a1 = k * 30;
                int a2 = (k + 1) * 30;
                v5.func_78371_b(5);
                v5.func_78378_d(this.getColor(key));
                for (int a = a1; a <= a2; a += 2) {
                    double dx1 = (double)r.innerRadius * Math.sin(Math.toRadians(180 - a - 15));
                    double dy1 = (double)r.innerRadius * Math.cos(Math.toRadians(180 - a - 15));
                    double dx2 = (double)r.outerRadius * Math.sin(Math.toRadians(180 - a - 15));
                    double dy2 = (double)r.outerRadius * Math.cos(Math.toRadians(180 - a - 15));
                    v5.func_78377_a((double)this.originX + dx2, (double)this.originY + dy2, 0.0);
                    v5.func_78377_a((double)this.originX + dx1, (double)this.originY + dy1, 0.0);
                }
                v5.func_78381_a();
                if (!label || !verbose && key.getNote() != this.root.getNote()) continue;
                GL11.glEnable((int)3553);
                int mida = k * 30 + 15;
                double midr = (double)r.innerRadius + (double)(r.outerRadius - r.innerRadius) / 2.0;
                String s = key.displayName();
                double px = (double)this.originX + midr * Math.sin(Math.toRadians(180 - mida - 15)) - (double)fr.func_78256_a(s) / 2.0;
                double py = (double)this.originY + midr * Math.cos(Math.toRadians(180 - mida - 15)) - (double)fr.field_78288_b / 2.0;
                fr.func_78276_b(s, (int)px, (int)py, key.getNote().isPure() ? 0 : 0xFFFFFF);
                GL11.glDisable((int)3553);
            }
            if (!renderLines) continue;
            v5.func_78371_b(3);
            v5.func_78378_d(0);
            for (k = 0; k <= 360; k += 2) {
                double dx = (double)r.innerRadius * Math.sin(Math.toRadians(k));
                double dy = (double)r.innerRadius * Math.cos(Math.toRadians(k));
                v5.func_78377_a((double)this.originX + dx, (double)this.originY + dy, 0.0);
            }
            v5.func_78381_a();
            v5.func_78371_b(3);
            v5.func_78378_d(0);
            for (k = 0; k <= 360; k += 2) {
                double dx = (double)r.outerRadius * Math.sin(Math.toRadians(k));
                double dy = (double)r.outerRadius * Math.cos(Math.toRadians(k));
                v5.func_78377_a((double)this.originX + dx, (double)this.originY + dy, 0.0);
            }
            v5.func_78381_a();
        }
        if (renderLines) {
            v5.func_78371_b(1);
            v5.func_78378_d(0);
            for (int k = 0; k < 12; ++k) {
                int a1 = k * 30;
                int a2 = (k + 1) * 30;
                double dx1 = (double)this.innerRadius * Math.sin(Math.toRadians(a1 - 15));
                double dy1 = (double)this.innerRadius * Math.cos(Math.toRadians(a1 - 15));
                double dx2 = (double)this.radius * Math.sin(Math.toRadians(a1 - 15));
                double dy2 = (double)this.radius * Math.cos(Math.toRadians(a1 - 15));
                v5.func_78377_a((double)this.originX + dx1, (double)this.originY + dy1, 0.0);
                v5.func_78377_a((double)this.originX + dx2, (double)this.originY + dy2, 0.0);
                dx1 = (double)this.innerRadius * Math.sin(Math.toRadians(a2 - 15));
                dy1 = (double)this.innerRadius * Math.cos(Math.toRadians(a2 - 15));
                dx2 = (double)this.radius * Math.sin(Math.toRadians(a2 - 15));
                dy2 = (double)this.radius * Math.cos(Math.toRadians(a2 - 15));
                v5.func_78377_a((double)this.originX + dx1, (double)this.originY + dy1, 0.0);
                v5.func_78377_a((double)this.originX + dx2, (double)this.originY + dy2, 0.0);
            }
            v5.func_78381_a();
        }
        GL11.glPopAttrib();
    }

    public static interface PianoGui {
        public void onKeyPressed(ReikaMusicHelper.MusicKey var1);

        public int getColor(ReikaMusicHelper.MusicKey var1);
    }

    private static class Ring {
        private final TreeMap<Integer, ReikaMusicHelper.MusicKey> sections = new TreeMap();
        private final int innerRadius;
        private final int outerRadius;

        private Ring(int r1, int r2) {
            this.innerRadius = r1;
            this.outerRadius = r2;
        }

        private ReikaMusicHelper.MusicKey getSection(int ang) {
            return this.sections.get(this.sections.floorKey(ang));
        }
    }
}

