/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.GUI;

import Reika.DragonAPI.Libraries.Rendering.ReikaGuiAPI;
import Reika.DragonAPI.Libraries.Rendering.ReikaLiquidRenderer;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.util.IIcon;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidTankInfo;

@SideOnly(value=Side.CLIENT)
public class TankDisplay {
    private FluidTankInfo tank;
    public final int posX;
    public final int posY;
    public final int xSize;
    public final int ySize;

    public TankDisplay(FluidTankInfo fl, int x, int y, int w, int h) {
        this.tank = fl;
        this.posX = x;
        this.posY = y;
        this.xSize = w;
        this.ySize = h;
    }

    public TankDisplay updateTank(FluidTankInfo fl) {
        this.tank = fl;
        return this;
    }

    private int getLevel() {
        return this.tank.fluid != null ? this.tank.fluid.amount : 0;
    }

    private int getRenderLevel() {
        float frac = (float)this.getLevel() / (float)this.tank.capacity;
        return (int)(frac * (float)this.ySize);
    }

    private Fluid getFluid() {
        return this.tank.fluid != null ? this.tank.fluid.getFluid() : null;
    }

    private IIcon getIcon() {
        return ReikaLiquidRenderer.getFluidIconSafe(this.getFluid());
    }

    public void render(boolean lines) {
        Fluid f = this.getFluid();
        if (f == null) {
            return;
        }
        IIcon ico = this.getIcon();
        ReikaLiquidRenderer.bindFluidTexture(f);
        int yh = this.posY + this.ySize - this.getRenderLevel();
        ReikaGuiAPI.instance.func_94065_a(this.posX, yh, ico, this.xSize, this.getRenderLevel());
        lines = false;
        if (lines) {
            int dist = this.ySize * 1000 / this.tank.capacity * 4;
            for (int i = 0; i < this.ySize; i += dist) {
                ReikaGuiAPI.instance.drawLine(this.posX + this.xSize - this.xSize / 4, this.posY + i, this.posX + this.xSize, this.posY + i, 0xFF0000);
            }
        }
    }
}

