/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable;

import java.util.Random;

public class GridDistortion {
    private final int gridSize;
    private final double[][] offsetsA;
    private final double[][] offsetsB;
    public double maxDeviation;
    public boolean snapToEdges = true;
    private OffsetGroup[][] offsets;

    public GridDistortion(int steps) {
        this.gridSize = steps;
        this.offsetsA = new double[steps + 1][steps + 1];
        this.offsetsB = new double[steps + 1][steps + 1];
        this.offsets = new OffsetGroup[steps][steps];
        this.maxDeviation = 0.5 / (double)steps;
    }

    public void randomize(Random rand) {
        int i;
        this.offsets = new OffsetGroup[this.gridSize][this.gridSize];
        for (i = 0; i < this.offsetsA.length; ++i) {
            for (int k = 0; k < this.offsetsA.length; ++k) {
                this.offsetsA[i][k] = -this.maxDeviation + this.maxDeviation * 2.0 * rand.nextDouble();
                this.offsetsB[i][k] = -this.maxDeviation + this.maxDeviation * 2.0 * rand.nextDouble();
            }
        }
        if (this.snapToEdges) {
            for (i = 0; i < this.offsetsA.length; ++i) {
                this.offsetsA[i][0] = 0.0;
                this.offsetsA[i][this.offsetsA.length - 1] = 0.0;
            }
            for (i = 0; i < this.offsetsB.length; ++i) {
                this.offsetsB[i][0] = 0.0;
                this.offsetsB[i][this.offsetsB.length - 1] = 0.0;
            }
        }
    }

    public OffsetGroup getOffset(int a, int b) {
        if (this.offsets[a][b] == null) {
            double amm = this.offsetsA[a][b];
            double apm = this.offsetsA[a + 1][b];
            double amp = this.offsetsA[a][b + 1];
            double app = this.offsetsA[a + 1][b + 1];
            double bmm = this.offsetsB[a][b];
            double bpm = this.offsetsB[a + 1][b];
            double bmp = this.offsetsB[a][b + 1];
            double bpp = this.offsetsB[a + 1][b + 1];
            this.offsets[a][b] = new OffsetGroup(amm, apm, amp, app, bmm, bpm, bmp, bpp);
        }
        return this.offsets[a][b];
    }

    public static class OffsetGroup {
        public final double offsetAMM;
        public final double offsetAPM;
        public final double offsetAMP;
        public final double offsetAPP;
        public final double offsetBMM;
        public final double offsetBPM;
        public final double offsetBMP;
        public final double offsetBPP;

        private OffsetGroup(double amm, double apm, double amp, double app, double bmm, double bpm, double bmp, double bpp) {
            this.offsetAMM = amm;
            this.offsetAMP = amp;
            this.offsetAPM = apm;
            this.offsetAPP = app;
            this.offsetBMM = bmm;
            this.offsetBMP = bmp;
            this.offsetBPM = bpm;
            this.offsetBPP = bpp;
        }
    }
}

