/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.IO;

import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.Exception.InvalidConfigException;
import Reika.DragonAPI.Exception.MisuseException;
import Reika.DragonAPI.Exception.RegistrationException;
import Reika.DragonAPI.Exception.StupidIDException;
import Reika.DragonAPI.IO.ReikaFileReader;
import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import Reika.DragonAPI.Instantiable.Data.Maps.ValueSortedMap;
import Reika.DragonAPI.Interfaces.Configuration.BooleanConfig;
import Reika.DragonAPI.Interfaces.Configuration.BoundedConfig;
import Reika.DragonAPI.Interfaces.Configuration.ConfigList;
import Reika.DragonAPI.Interfaces.Configuration.CustomCategoryConfig;
import Reika.DragonAPI.Interfaces.Configuration.DecimalConfig;
import Reika.DragonAPI.Interfaces.Configuration.IntArrayConfig;
import Reika.DragonAPI.Interfaces.Configuration.IntegerConfig;
import Reika.DragonAPI.Interfaces.Configuration.SegmentedConfigList;
import Reika.DragonAPI.Interfaces.Configuration.SelectiveConfig;
import Reika.DragonAPI.Interfaces.Configuration.StringArrayConfig;
import Reika.DragonAPI.Interfaces.Configuration.StringConfig;
import Reika.DragonAPI.Interfaces.Configuration.UserSpecificConfig;
import Reika.DragonAPI.Interfaces.Registry.IDRegistry;
import Reika.DragonAPI.Libraries.Java.ReikaStringParser;
import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Session;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class ControlledConfig {
    private static final HashMap<String, ControlledConfig> configs = new HashMap();
    private static final UserHash userHash = ControlledConfig.genUserHash();
    private final Comparator entryComparator = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            if (o1.getClass() != o2.getClass()) {
                return o1.getClass().getName().compareTo(o2.getClass().getName());
            }
            if (o1 instanceof Enum) {
                return ((Enum)o1).compareTo((Enum)o2);
            }
            if (o1 instanceof ConfigList) {
                return Integer.compare(((ConfigList)o1).ordinal(), ((ConfigList)o2).ordinal());
            }
            if (o1 instanceof Comparable) {
                return ((Comparable)o1).compareTo(o2);
            }
            return 0;
        }
    };
    private Configuration config;
    private int readID;
    protected File configFile;
    public final DragonAPIMod configMod;
    private ConfigList[] optionList;
    private IDRegistry[] IDList;
    protected Object[] controls;
    protected int[] otherIDs;
    private final HashMap<SegmentedConfigList, String> specialFiles = new HashMap();
    private final MultiMap<String, SegmentedConfigList> specialConfigs = new MultiMap();
    private final HashMap<String, HashMap<String, String>> extraFiles = new HashMap();
    private final HashMap<String, ValueSortedMap<String, Object>> optionMap = new HashMap();
    private final HashMap<String, LinkedHashMap<String, DataElement>> additionalOptions = new HashMap();
    private final HashSet<String> orphanExclusions = new HashSet();
    private final ArrayList<String> queuedExceptions = new ArrayList();

    public ControlledConfig(DragonAPIMod mod, ConfigList[] option, IDRegistry[] id) {
        String s2;
        String s1;
        ConfigList cfg;
        int i;
        if (mod == null) {
            throw new MisuseException("You cannot create a config with a null mod!");
        }
        this.configMod = mod;
        this.optionList = option;
        this.IDList = id;
        String n = ReikaStringParser.stripSpaces(mod.getDisplayName());
        if (configs.containsKey(n)) {
            throw new IllegalArgumentException("Only one config permitted per mod!");
        }
        configs.put(n, this);
        if (option != null) {
            this.controls = new Object[this.optionList.length];
        } else {
            this.controls = new Object[0];
            this.optionList = new ConfigList[0];
        }
        if (id != null) {
            this.otherIDs = new int[this.IDList.length];
        } else {
            this.otherIDs = new int[0];
            this.IDList = new IDRegistry[0];
        }
        for (i = 0; i < this.optionList.length; ++i) {
            cfg = this.optionList[i];
            s1 = this.getCategory(cfg);
            s2 = this.getLabel(cfg);
            this.registerOption(s1, s2, cfg);
        }
        for (i = 0; i < this.IDList.length; ++i) {
            cfg = this.IDList[i];
            s1 = this.getCategory(cfg);
            s2 = this.getLabel(cfg);
            this.registerOption(s1, s2, cfg);
        }
    }

    private static UserHash genUserHash() {
        return FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT ? ControlledConfig.getClientUserHash() : null;
    }

    @SideOnly(value=Side.CLIENT)
    private static UserHash getClientUserHash() {
        Session s = Minecraft.func_71410_x().func_110432_I();
        GameProfile p = s.func_148256_e();
        String id = p != null ? p.getId().toString() : s.func_111285_a();
        return new UserHash(id);
    }

    private String getLabel(ConfigList cfg) {
        String s = cfg.getLabel();
        if (cfg instanceof UserSpecificConfig && ((UserSpecificConfig)cfg).isUserSpecific()) {
            s = "[" + Character.toUpperCase(s.charAt(0)) + ControlledConfig.getUserHash(s) + "]U " + s;
        }
        return s;
    }

    public static String getUserHash(String s) {
        int hash = userHash == null ? 0 : userHash.hash;
        String ret = Strings.padStart((String)Integer.toHexString(hash - s.hashCode()).toUpperCase(Locale.ENGLISH), (int)8, (char)'0');
        if (userHash != null) {
            ret = ret + "_" + (userHash.userID.indexOf(45) == -1 ? userHash.userID : userHash.userID.substring(0, 6));
        }
        return ret;
    }

    private void registerOption(String s1, String s2, Object cfg) {
        String key = s1.toLowerCase(Locale.ENGLISH);
        ValueSortedMap map = this.optionMap.get(key);
        if (map == null) {
            map = new ValueSortedMap().setComparator(this.entryComparator);
            this.optionMap.put(s1.toLowerCase(Locale.ENGLISH), map);
        }
        map.put((String)s2, (Object)cfg);
    }

    protected final void registerProperty(String property, Object value) {
        if (this.optionList != null && this.optionList.length > 0) {
            try {
                Field f = this.optionList[0].getClass().getDeclaredField(property);
                f.setAccessible(true);
                f.set(null, value);
            }
            catch (Exception e) {
                this.queuedExceptions.add("Could not set config value property " + property + ": " + e.toString());
            }
        }
    }

    protected final void registerOrphanExclusion(String s) {
        this.orphanExclusions.add(s.toLowerCase(Locale.ENGLISH));
    }

    private final String getConfigPath() {
        return ReikaFileReader.getFileNameNoExtension(this.configFile, true, true);
    }

    public final File getConfigFolder() {
        return this.configFile.getParentFile();
    }

    public final Collection<String> getExtraFiles() {
        return Collections.unmodifiableCollection(this.extraFiles.keySet());
    }

    public final ArrayList<String> getSettingsAsLines() {
        ArrayList<String> li = new ArrayList<String>();
        for (int i = 0; i < this.optionList.length; ++i) {
            ConfigList c = this.optionList[i];
            Object val = this.controls[i];
            String s = c.getLabel() + " = " + val;
            li.add(s);
        }
        return li;
    }

    public final Object getControl(int i) {
        return this.controls[i];
    }

    public int getOtherID(int i) {
        return this.otherIDs[i];
    }

    public void loadCustomConfigFile(FMLPreInitializationEvent event, String file) {
        this.loadConfigFile(new File(file));
    }

    public void loadSubfolderedConfigFile(FMLPreInitializationEvent event) {
        String name = ReikaStringParser.stripSpaces(this.configMod.getDisplayName());
        String author = ReikaStringParser.stripSpaces(this.configMod.getModAuthorName());
        String file = event.getModConfigurationDirectory() + "/" + author + "/" + name + ".cfg";
        this.loadConfigFile(new File(file));
    }

    public void loadDefaultConfigFile(FMLPreInitializationEvent event) {
        this.loadConfigFile(event.getSuggestedConfigurationFile());
    }

    private void loadConfigFile(File f) {
        this.configFile = f;
        if (this.optionList != null) {
            for (int i = 0; i < this.optionList.length; ++i) {
                SegmentedConfigList sg;
                String s;
                ConfigList c = this.optionList[i];
                if (!(c instanceof SegmentedConfigList) || (s = (sg = (SegmentedConfigList)c).getCustomConfigFile()) == null) continue;
                s = this.parseFileString(s);
                this.specialFiles.put(sg, s);
                this.extraFiles.put(s, new HashMap());
                this.specialConfigs.addValue(s, sg);
            }
        }
    }

    private String parseFileString(String s) {
        String ext;
        int post;
        if (s.charAt(0) == '*') {
            String suffix = s.replaceAll("\\*", "");
            s = ReikaFileReader.getRealPath(this.configFile) + "*" + suffix;
        }
        if ((post = (ext = s.substring(s.lastIndexOf(46))).indexOf(42)) >= 0) {
            ext = ext.substring(0, post);
            s = s.replaceAll("\\*", "");
            s = s.replaceAll(ext, "");
            s = s + ext;
        }
        return s;
    }

    public final void initProps(FMLPreInitializationEvent event) {
        if (this.configFile == null) {
            throw new MisuseException("Error loading " + this.configMod.getDisplayName() + ": You must load a config file before reading it!");
        }
        this.config = new Configuration(this.configFile);
        this.load();
    }

    public final void load() {
        if (this.configFile == null) {
            throw new MisuseException("Error loading " + this.configMod.getDisplayName() + ": You cannot load a config that is not yet configured!");
        }
        this.loadConfig();
    }

    public final void save() {
        this.setOrder();
        this.config.save();
    }

    protected final Property getProperty(String cat, String name, boolean def) {
        return this.config.get(cat, name, def);
    }

    protected final Property getProperty(String cat, String name, String def) {
        return this.config.get(cat, name, def);
    }

    protected final Property getProperty(String cat, String name, int def) {
        return this.config.get(cat, name, def);
    }

    protected void onInit() {
    }

    protected void afterInit() {
    }

    private void loadConfig() {
        int i;
        this.config.load();
        this.stripOrhpanedEntries();
        if (!this.specialFiles.isEmpty()) {
            this.loadExtraFiles();
        }
        for (i = 0; i < this.optionList.length; ++i) {
            ConfigList cfg = this.optionList[i];
            String label = this.getLabel(cfg);
            this.controls[i] = cfg.shouldLoad() ? this.loadValue(this.optionList[i]) : this.getDefault(this.optionList[i]);
        }
        for (i = 0; i < this.IDList.length; ++i) {
            this.otherIDs[i] = this.getValueFromConfig(this.IDList[i], this.config);
        }
        this.loadAdditionalData();
        if (!this.queuedExceptions.isEmpty()) {
            throw new RegistrationException(this.configMod, "Errors found loading config data!\n" + Arrays.toString(this.queuedExceptions.toArray(new String[this.queuedExceptions.size()])));
        }
        this.setOrder();
        this.config.save();
        if (!this.specialFiles.isEmpty()) {
            this.saveExtraFiles();
        }
    }

    private void stripOrhpanedEntries() {
        HashSet<ConfigCategory> catNames = new HashSet<ConfigCategory>();
        for (String s1 : this.config.getCategoryNames()) {
            ConfigCategory cat = this.config.getCategory(s1);
            ValueSortedMap<String, Object> map = this.optionMap.get(s1.toLowerCase(Locale.ENGLISH));
            if (map == null) {
                if (this.orphanExclusions.contains(s1)) continue;
                boolean flag = true;
                for (String s : this.orphanExclusions) {
                    if (!s.startsWith(s1) && !s1.startsWith(s)) continue;
                    flag = false;
                }
                if (!flag) continue;
                catNames.add(cat);
                continue;
            }
            HashSet<String> entryNames = new HashSet<String>();
            for (String s2 : cat.getValues().keySet()) {
                if (s2.charAt(0) == '[' || s2.contains("]U") || map.containsKey(s2)) continue;
                entryNames.add(s2);
            }
            for (String s : entryNames) {
                cat.remove((Object)s);
            }
        }
        for (ConfigCategory c : catNames) {
            this.config.removeCategory(c);
        }
    }

    private Object loadValue(ConfigList cfg) {
        if (cfg instanceof BooleanConfig && ((BooleanConfig)cfg).isBoolean()) {
            return this.setState((BooleanConfig)cfg);
        }
        if (cfg instanceof IntegerConfig && ((IntegerConfig)cfg).isNumeric()) {
            return this.setValue((IntegerConfig)cfg);
        }
        if (cfg instanceof DecimalConfig && ((DecimalConfig)cfg).isDecimal()) {
            return Float.valueOf(this.setFloat((DecimalConfig)cfg));
        }
        if (cfg instanceof StringConfig && ((StringConfig)cfg).isString()) {
            return this.setString((StringConfig)cfg);
        }
        if (cfg instanceof IntArrayConfig && ((IntArrayConfig)cfg).isIntArray()) {
            return this.setIntArray((IntArrayConfig)cfg);
        }
        if (cfg instanceof StringArrayConfig && ((StringArrayConfig)cfg).isStringArray()) {
            return this.setStringArray((StringArrayConfig)cfg);
        }
        return null;
    }

    private Object getDefault(ConfigList cfg) {
        if (cfg instanceof BooleanConfig && ((BooleanConfig)cfg).isBoolean()) {
            return ((BooleanConfig)cfg).getDefaultState();
        }
        if (cfg instanceof IntegerConfig && ((IntegerConfig)cfg).isNumeric()) {
            return ((IntegerConfig)cfg).getDefaultValue();
        }
        if (cfg instanceof DecimalConfig && ((DecimalConfig)cfg).isDecimal()) {
            return Float.valueOf(((DecimalConfig)cfg).getDefaultFloat());
        }
        if (cfg instanceof StringConfig && ((StringConfig)cfg).isString()) {
            return ((StringConfig)cfg).getDefaultString();
        }
        if (cfg instanceof IntArrayConfig && ((IntArrayConfig)cfg).isIntArray()) {
            return ((IntArrayConfig)cfg).getDefaultIntArray();
        }
        if (cfg instanceof StringArrayConfig && ((StringArrayConfig)cfg).isStringArray()) {
            return ((StringArrayConfig)cfg).getDefaultStringArray();
        }
        return null;
    }

    private void loadExtraFiles() {
        for (String string : this.extraFiles.keySet()) {
            File f = new File(string);
            if (!f.exists()) continue;
            this.readData(this.extraFiles.get(string), f);
        }
        for (ConfigList configList : this.specialFiles.keySet()) {
            String file = this.specialFiles.get(configList);
            HashMap<String, String> data = this.extraFiles.get(file);
            String s = data.get(this.getLabel(configList));
            if (s == null) {
                this.controls[configList.ordinal()] = this.getDefault(configList);
                continue;
            }
            Object o = this.getDefault(configList);
            try {
                o = this.parseData(configList, s);
                if (o == null) {
                    o = this.getDefault(configList);
                    this.queuedExceptions.add("Config entry '" + this.getLabel(configList) + "' returned a null value. This is invalid.");
                }
            }
            catch (Exception e) {
                this.configMod.getModLogger().logError("Could not parse config value for " + this.getLabel(configList));
            }
            this.controls[configList.ordinal()] = o;
        }
    }

    private Object parseData(ConfigList cfg, String o) {
        if (cfg instanceof StringConfig && ((StringConfig)cfg).isString()) {
            return o;
        }
        if (cfg instanceof IntegerConfig && ((IntegerConfig)cfg).isNumeric()) {
            return Integer.parseInt(o);
        }
        if (cfg instanceof DecimalConfig && ((DecimalConfig)cfg).isDecimal()) {
            return Float.valueOf(Float.parseFloat(o));
        }
        if (cfg instanceof IntArrayConfig && ((IntArrayConfig)cfg).isIntArray()) {
            o = o.replaceAll("[", "").replaceAll("]", "");
            String[] parts = o.split(",");
            int[] dat = new int[parts.length];
            for (int i = 0; i < dat.length; ++i) {
                dat[i] = Integer.parseInt(parts[i]);
            }
            return dat;
        }
        if (cfg instanceof StringArrayConfig && ((StringArrayConfig)cfg).isStringArray()) {
            o = o.replaceAll("[", "").replaceAll("]", "");
            String[] parts = o.split(",");
            return parts;
        }
        return o;
    }

    private void saveExtraFiles() {
        for (String s : this.extraFiles.keySet()) {
            try {
                File f = new File(s);
                ArrayList<String> li = this.getDataToWriteToFile(s);
                if (li.isEmpty()) continue;
                File parent = new File(f.getParent());
                if (!parent.exists()) {
                    parent.mkdirs();
                }
                if (f.exists()) {
                    f.delete();
                }
                f.createNewFile();
                if (!f.exists()) continue;
                ReikaFileReader.writeLinesToFile(f, li, true, Charsets.UTF_8);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private ArrayList<String> getDataToWriteToFile(String s) {
        ArrayList<String> li = new ArrayList<String>();
        for (SegmentedConfigList cfg : this.specialConfigs.get(s)) {
            Object dat = this.controls[cfg.ordinal()];
            if (!cfg.saveIfUnspecified() && dat.equals(this.getDefault(cfg))) continue;
            String val = this.encodeData(cfg, dat);
            String sg = "[\"" + this.getLabel(cfg) + "\"=\"" + val + "\"";
            li.add(sg);
        }
        return li;
    }

    private String encodeData(ConfigList cfg, Object o) {
        if (cfg instanceof StringConfig && ((StringConfig)cfg).isString()) {
            return (String)o;
        }
        if (cfg instanceof BooleanConfig && ((BooleanConfig)cfg).isBoolean()) {
            return String.valueOf(o);
        }
        if (cfg instanceof IntegerConfig && ((IntegerConfig)cfg).isNumeric()) {
            return String.valueOf(o);
        }
        if (cfg instanceof DecimalConfig && ((DecimalConfig)cfg).isDecimal()) {
            return String.valueOf(o);
        }
        if (cfg instanceof IntArrayConfig && ((IntArrayConfig)cfg).isIntArray()) {
            return Arrays.toString((int[])o);
        }
        if (cfg instanceof StringArrayConfig && ((StringArrayConfig)cfg).isStringArray()) {
            return Arrays.toString((String[])o);
        }
        return "";
    }

    private void readData(HashMap<String, String> map, File f) {
        List<String> li = ReikaFileReader.getFileAsLines(f, true, Charsets.UTF_8);
        for (String s : li) {
            int max;
            int min;
            String key;
            String[] dat;
            if (!s.startsWith("[") || (dat = (key = s.substring(min = s.indexOf(34), max = s.lastIndexOf(34)).replaceAll("\"", "")).split("=")).length != 2) continue;
            map.put(dat[0], dat[1]);
        }
    }

    private boolean setState(BooleanConfig cfg) {
        SelectiveConfig sfg;
        Property prop = this.config.get(this.getCategory(cfg), this.getLabel(cfg), cfg.getDefaultState());
        if (cfg.isEnforcingDefaults()) {
            prop.set(cfg.getDefaultState());
        }
        if (cfg instanceof SelectiveConfig && !(sfg = (SelectiveConfig)((Object)cfg)).saveIfUnspecified() && prop.getBoolean(cfg.getDefaultState()) == cfg.getDefaultState()) {
            this.removeConfigEntry(cfg);
            return cfg.getDefaultState();
        }
        if (cfg instanceof BoundedConfig && !((BoundedConfig)((Object)cfg)).isValueValid(prop)) {
            throw new InvalidConfigException(this.configMod, (BoundedConfig)((Object)cfg), prop);
        }
        if (!prop.isBooleanValue()) {
            throw new StupidIDException(this.configMod, prop, Property.Type.BOOLEAN);
        }
        return prop.getBoolean(cfg.getDefaultState());
    }

    private int setValue(IntegerConfig cfg) {
        SelectiveConfig sfg;
        Property prop = this.config.get(this.getCategory(cfg), this.getLabel(cfg), cfg.getDefaultValue());
        if (cfg.isEnforcingDefaults()) {
            prop.set(cfg.getDefaultValue());
        }
        if (cfg instanceof SelectiveConfig && !(sfg = (SelectiveConfig)((Object)cfg)).saveIfUnspecified() && prop.getInt(cfg.getDefaultValue()) == cfg.getDefaultValue()) {
            this.removeConfigEntry(cfg);
            return cfg.getDefaultValue();
        }
        if (cfg instanceof BoundedConfig && !((BoundedConfig)((Object)cfg)).isValueValid(prop)) {
            throw new InvalidConfigException(this.configMod, (BoundedConfig)((Object)cfg), prop);
        }
        if (!prop.isIntValue()) {
            throw new StupidIDException(this.configMod, prop, Property.Type.INTEGER);
        }
        return prop.getInt();
    }

    private float setFloat(DecimalConfig cfg) {
        SelectiveConfig sfg;
        Property prop = this.config.get(this.getCategory(cfg), this.getLabel(cfg), (double)cfg.getDefaultFloat());
        if (cfg.isEnforcingDefaults()) {
            prop.set((double)cfg.getDefaultFloat());
        }
        if (cfg instanceof SelectiveConfig && !(sfg = (SelectiveConfig)((Object)cfg)).saveIfUnspecified() && (float)prop.getDouble((double)cfg.getDefaultFloat()) == cfg.getDefaultFloat()) {
            this.removeConfigEntry(cfg);
            return cfg.getDefaultFloat();
        }
        if (cfg instanceof BoundedConfig && !((BoundedConfig)((Object)cfg)).isValueValid(prop)) {
            throw new InvalidConfigException(this.configMod, (BoundedConfig)((Object)cfg), prop);
        }
        if (!prop.isDoubleValue()) {
            throw new StupidIDException(this.configMod, prop, Property.Type.DOUBLE);
        }
        return (float)prop.getDouble((double)cfg.getDefaultFloat());
    }

    private String setString(StringConfig cfg) {
        SelectiveConfig sfg;
        Property prop = this.config.get(this.getCategory(cfg), this.getLabel(cfg), cfg.getDefaultString());
        if (cfg.isEnforcingDefaults()) {
            prop.set(cfg.getDefaultString());
        }
        if (cfg instanceof SelectiveConfig && !(sfg = (SelectiveConfig)((Object)cfg)).saveIfUnspecified() && prop.getString().equals(cfg.getDefaultString())) {
            this.removeConfigEntry(cfg);
            return cfg.getDefaultString();
        }
        if (cfg instanceof BoundedConfig && !((BoundedConfig)((Object)cfg)).isValueValid(prop)) {
            throw new InvalidConfigException(this.configMod, (BoundedConfig)((Object)cfg), prop);
        }
        return prop.getString();
    }

    private int[] setIntArray(IntArrayConfig cfg) {
        SelectiveConfig sfg;
        Property prop = this.config.get(this.getCategory(cfg), this.getLabel(cfg), cfg.getDefaultIntArray());
        if (cfg.isEnforcingDefaults()) {
            prop.set(cfg.getDefaultIntArray());
        }
        if (cfg instanceof SelectiveConfig && !(sfg = (SelectiveConfig)((Object)cfg)).saveIfUnspecified() && Arrays.equals(prop.getIntList(), cfg.getDefaultIntArray())) {
            this.removeConfigEntry(cfg);
            return cfg.getDefaultIntArray();
        }
        if (cfg instanceof BoundedConfig && !((BoundedConfig)((Object)cfg)).isValueValid(prop)) {
            throw new InvalidConfigException(this.configMod, (BoundedConfig)((Object)cfg), prop);
        }
        return prop.getIntList();
    }

    private String[] setStringArray(StringArrayConfig cfg) {
        SelectiveConfig sfg;
        Property prop = this.config.get(this.getCategory(cfg), this.getLabel(cfg), cfg.getDefaultStringArray());
        if (cfg.isEnforcingDefaults()) {
            prop.set(cfg.getDefaultStringArray());
        }
        if (cfg instanceof SelectiveConfig && !(sfg = (SelectiveConfig)((Object)cfg)).saveIfUnspecified() && Arrays.deepEquals(prop.getStringList(), cfg.getDefaultStringArray())) {
            this.removeConfigEntry(cfg);
            return cfg.getDefaultStringArray();
        }
        if (cfg instanceof BoundedConfig && !((BoundedConfig)((Object)cfg)).isValueValid(prop)) {
            throw new InvalidConfigException(this.configMod, (BoundedConfig)((Object)cfg), prop);
        }
        return prop.getStringList();
    }

    private String getCategory(ConfigList cfg) {
        String s;
        String ret = "Control Setup";
        if (cfg instanceof CustomCategoryConfig && !Strings.isNullOrEmpty((String)(s = ((CustomCategoryConfig)cfg).getCategory()))) {
            ret = s;
        }
        if (cfg instanceof UserSpecificConfig && ((UserSpecificConfig)cfg).isUserSpecific()) {
            ret = "Client Specific";
        }
        if (cfg instanceof IDRegistry) {
            ret = ((IDRegistry)cfg).getCategory();
        }
        return ret;
    }

    private void removeConfigEntry(ConfigList cfg) {
        ConfigCategory cat = this.config.getCategory(this.getCategory(cfg));
        cat.remove((Object)this.getLabel(cfg));
    }

    private int getValueFromConfig(IDRegistry id, Configuration config) {
        Property prop = config.get(this.getCategory(id), this.getLabel(id), String.valueOf(id.getDefaultID()));
        if (!prop.isIntValue()) {
            throw new StupidIDException(this.configMod, prop, Property.Type.INTEGER);
        }
        return prop.getInt(id.getDefaultID());
    }

    private void setOrder() {
        for (String s : this.config.getCategoryNames()) {
            ConfigCategory c = this.config.getCategory(s);
            ArrayList li = new ArrayList(c.keySet());
            Collections.sort(li, new PropertyComparator(s.toLowerCase(Locale.ENGLISH)));
            c.setPropertyOrder(li);
        }
    }

    private final void loadAdditionalData() {
        for (String c : this.additionalOptions.keySet()) {
            HashMap map = this.additionalOptions.get(c);
            for (String n : map.keySet()) {
                DataElement e = (DataElement)map.get(n);
                e.data = e.load(this.config);
            }
        }
    }

    protected final <C> DataElement<C> registerAdditionalOption(String c, String n, C default_) {
        LinkedHashMap<String, DataElement<Object>> map = this.additionalOptions.get(c = c.toLowerCase(Locale.ENGLISH));
        if (map == null) {
            map = new LinkedHashMap();
            this.additionalOptions.put(c, map);
        }
        DataElement e = new DataElement(this, c, n, default_, map.size());
        map.put(n, e);
        this.registerOption(c, n, e);
        return e;
    }

    public final void reload() {
        if (this.config == null) {
            throw new MisuseException("You cannot reload a config before it is initialized!");
        }
        this.load();
    }

    public static ControlledConfig getForMod(String mod) {
        return configs.get(mod);
    }

    public static Collection<ControlledConfig> getConfigs() {
        return Collections.unmodifiableCollection(configs.values());
    }

    public static void reloadAll() {
        for (ControlledConfig c : configs.values()) {
            c.reload();
        }
    }

    private static class UserHash {
        private final String userID;
        private final int hash;

        private UserHash(String id) {
            this.userID = id;
            this.hash = id.hashCode();
        }
    }

    protected static final class DataElement<C>
    implements Comparable<DataElement> {
        private C data;
        public final String category;
        public final String name;
        private final ControlledConfig parent;
        private final int index;

        private DataElement(ControlledConfig p, String c, String n, C default_, int idx) {
            this.parent = p;
            this.category = c;
            this.name = n;
            this.data = default_;
            this.index = idx;
        }

        private Object load(Configuration config) {
            if (this.data instanceof Boolean) {
                return config.get(this.category, this.name, ((Boolean)this.data).booleanValue()).getBoolean();
            }
            if (this.data instanceof Integer) {
                return config.get(this.category, this.name, ((Integer)this.data).intValue()).getInt();
            }
            if (this.data instanceof Float || this.data instanceof Double) {
                return Float.valueOf((float)config.get(this.category, this.name, (double)((Float)this.data).floatValue()).getDouble());
            }
            if (this.data instanceof String) {
                return config.get(this.category, this.name, (String)this.data).getString();
            }
            if (this.data instanceof int[]) {
                return config.get(this.category, this.name, (int[])this.data).getIntList();
            }
            if (this.data instanceof boolean[]) {
                return config.get(this.category, this.name, (boolean[])this.data).getIntList();
            }
            if (this.data instanceof String[]) {
                return config.get(this.category, this.name, (String[])this.data).getStringList();
            }
            throw new RegistrationException(this.parent.configMod, "Invalid data element type: " + this.data + "!");
        }

        public C getData() {
            return this.data;
        }

        public void setData(C val) {
            this.data = val;
        }

        public String toString() {
            return this.category + ":" + this.name + " > " + this.data.toString();
        }

        @Override
        public int compareTo(DataElement o) {
            return Integer.compare(this.index, o.index);
        }
    }

    private final class PropertyComparator
    implements Comparator<String> {
        private final String category;

        private PropertyComparator(String s) {
            this.category = s;
        }

        @Override
        public int compare(String s1, String s2) {
            ValueSortedMap data = (ValueSortedMap)ControlledConfig.this.optionMap.get(this.category);
            if (data == null || data.isEmpty()) {
                return s1.compareToIgnoreCase(s2);
            }
            Object o1 = data.get(s1);
            Object o2 = data.get(s2);
            if (o1 == null || o2 == null) {
                return s1.compareToIgnoreCase(s2);
            }
            int comp = ControlledConfig.this.entryComparator.compare(o1, o2);
            return comp == 0 ? s1.compareToIgnoreCase(s2) : comp;
        }
    }
}

