/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.IO;

import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.DragonOptions;
import Reika.DragonAPI.Libraries.IO.ReikaChatHelper;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import com.google.common.base.Charsets;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.logging.log4j.Level;

public class ModLogger {
    private boolean logLoading;
    private boolean printDebug;
    private final boolean shouldWarn;
    private final DragonAPIMod mod;
    private static boolean logAll = false;
    private static boolean logNone = false;
    private LoggerOut IOThread;
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final ArrayList<ModLogger> loggers = new ArrayList();

    public ModLogger(DragonAPIMod mod, boolean warn) {
        this.mod = mod;
        this.logLoading = DragonOptions.LOGLOADING.getState();
        this.printDebug = DragonOptions.DEBUGMODE.getState();
        this.shouldWarn = warn;
        if (mod == null) {
            throw new IllegalArgumentException("Cannot create a logger for a null mod!");
        }
        if (this.shouldLog()) {
            ReikaJavaLibrary.pConsole(mod.getTechnicalName() + ": Creating logger. Log Loading: " + this.logLoading + "; Debug mode: " + this.printDebug + "; Warnings: " + warn);
        }
        loggers.add(this);
    }

    private File parseFileString(String file) {
        if (file.charAt(0) == '*') {
            File log = new File(DragonAPICore.getMinecraftDirectory(), "logs");
            boolean preName = (file = file.substring(1)).charAt(0) == '*';
            String pre = "";
            if (preName) {
                pre = this.mod.getDisplayName();
                file = file.substring(1);
            }
            return new File(log, pre + file);
        }
        return new File(file);
    }

    private void reloadConfigs() {
        this.logLoading = DragonOptions.LOGLOADING.getState();
        this.printDebug = DragonOptions.DEBUGMODE.getState();
    }

    public ModLogger setOutput(String file) {
        File par;
        File f = this.parseFileString(file);
        if (f.exists()) {
            f.delete();
        }
        if (!(par = new File(f.getParent())).exists()) {
            par.mkdirs();
        }
        this.logChange(f);
        this.IOThread = new LoggerOut(this.mod.getDisplayName() + " - Custom I/O Logger", f);
        this.IOThread.start();
        return this;
    }

    private void logChange(File f) {
        this.log("===============================================================================================================================");
        this.log("Logging is being redirected to " + f.getAbsolutePath() + ". Check there for any and all logging information including debugging and errors!");
        this.log("===============================================================================================================================");
    }

    public void debug(Object o) {
        if (this.shouldDebug()) {
            this.write(Level.INFO, this.mod.getTechnicalName() + " DEBUG: " + o);
            ReikaChatHelper.write("DEBUG: " + o);
        }
    }

    public void log(Object o) {
        if (this.shouldLog()) {
            this.write(Level.INFO, this.mod.getTechnicalName() + ": " + o);
        }
    }

    public void logError(Object o) {
        this.write(Level.ERROR, this.mod.getTechnicalName() + " ERROR: " + o);
    }

    private void write(Level l, String s) {
        if (this.IOThread != null) {
            this.IOThread.addMessage(s, l);
        } else {
            ReikaJavaLibrary.pConsole(l, s);
        }
    }

    public boolean shouldLog() {
        if (logNone) {
            return false;
        }
        if (logAll) {
            return true;
        }
        return this.logLoading;
    }

    public boolean shouldDebug() {
        if (logNone) {
            return false;
        }
        if (logAll) {
            return true;
        }
        return this.printDebug;
    }

    public boolean shouldWarn() {
        return this.shouldWarn;
    }

    public void warn(Object o) {
        if (this.shouldWarn()) {
            this.write(Level.WARN, o.toString());
            ReikaChatHelper.write(o);
        }
    }

    public static void setAllLoggingTrue() {
        logAll = true;
        logNone = false;
    }

    public static void setAllLoggingFalse() {
        logAll = false;
        logNone = true;
    }

    public static void setAllLoggingDefault() {
        logNone = false;
        logAll = false;
    }

    public static int getActiveLoggers() {
        return loggers.size();
    }

    public static void reloadLoggers() {
        for (ModLogger m : loggers) {
            m.reloadConfigs();
        }
    }

    public static class LoggerOut
    extends Thread {
        private final File outputFile;
        private ConcurrentLinkedQueue<LogLine> messages = new ConcurrentLinkedQueue();

        public LoggerOut(String n, File f) {
            this.outputFile = f;
            this.setName(n);
            this.setDaemon(true);
        }

        public void addMessage(String s, Level l) {
            this.messages.add(new LogLine(s, l));
        }

        @Override
        public void run() {
            while (!this.messages.isEmpty()) {
                try {
                    Files.write(this.outputFile.toPath(), this.messages, Charsets.UTF_8, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.APPEND);
                    this.messages.clear();
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    ReikaJavaLibrary.pConsole("ERROR: Could not output logger contents line to its IO destination '" + this.outputFile + "'!");
                    ReikaJavaLibrary.pConsole(this.messages);
                    this.messages.add(new LogLine("ERROR WRITING: " + e.toString(), Level.ERROR));
                    e.printStackTrace();
                }
            }
        }

        @Override
        public String toString() {
            return this.messages.size() + " Messages from " + this.getName() + ": {" + this.messages + "}";
        }
    }

    private static class LogLine
    implements CharSequence {
        private final String message;
        private final Level level;
        private final Thread sender;
        private final long time;
        private final String stringValue;

        private LogLine(String s, Level l) {
            this.message = s;
            this.sender = Thread.currentThread();
            this.level = l;
            this.time = System.currentTimeMillis();
            this.stringValue = this.parseTime() + " " + this.parseThread() + ": " + this.message + NEWLINE;
        }

        @Override
        public String toString() {
            return this.stringValue;
        }

        private String parseTime() {
            return "[" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date(this.time)) + "]";
        }

        private String parseThread() {
            return "[" + this.sender + " (" + (Object)((Object)this.sender.getState()) + ")/" + this.level + "]";
        }

        public boolean equals(Object o) {
            if (o instanceof LogLine) {
                LogLine l = (LogLine)o;
                return l.message.equals(this.message) && l.time == this.time && l.level == this.level && l.sender == this.sender;
            }
            return false;
        }

        public int hashCode() {
            return (int)this.time;
        }

        @Override
        public int length() {
            return this.stringValue.length();
        }

        @Override
        public char charAt(int index) {
            return this.stringValue.charAt(index);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return this.stringValue.subSequence(start, end);
        }
    }
}

