/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.IO;

import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Instantiable.IO.PacketPipeline;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.DragonAPI.Libraries.ReikaEntityHelper;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public abstract class PacketTarget {
    public static final PacketTarget server = new ServerTarget();
    public static final PacketTarget allPlayers = new AllPlayersTarget();

    public abstract void dispatch(PacketPipeline var1, ReikaPacketHelper.PacketObj var2);

    private static final class ServerTarget
    extends PacketTarget {
        private ServerTarget() {
        }

        @Override
        public void dispatch(PacketPipeline p, ReikaPacketHelper.PacketObj pk) {
            p.sendToServer(pk);
        }
    }

    private static final class AllPlayersTarget
    extends PacketTarget {
        private AllPlayersTarget() {
        }

        @Override
        public void dispatch(PacketPipeline p, ReikaPacketHelper.PacketObj pk) {
            p.sendToAllOnServer(pk);
        }
    }

    public static final class DimensionTarget
    extends PacketTarget {
        private final int dimension;

        public DimensionTarget(int dim) {
            this.dimension = dim;
        }

        public DimensionTarget(World world) {
            this(world.field_73011_w.field_76574_g);
        }

        @Override
        public void dispatch(PacketPipeline p, ReikaPacketHelper.PacketObj pk) {
            p.sendToDimension(pk, this.dimension);
        }
    }

    public static final class RadiusTarget
    extends PacketTarget {
        private final int dim;
        private final double x;
        private final double y;
        private final double z;
        private final double radius;

        public RadiusTarget(WorldLocation loc, double r) {
            this(loc.dimensionID, (double)loc.xCoord, (double)loc.yCoord, (double)loc.zCoord, r);
        }

        public RadiusTarget(Entity e, double r) {
            this(e.field_70170_p, e.field_70165_t, e.field_70163_u, e.field_70161_v, r);
        }

        public RadiusTarget(TileEntity te, double r) {
            this(te.field_145850_b, (double)te.field_145851_c + 0.5, (double)te.field_145848_d + 0.5, (double)te.field_145849_e + 0.5, r);
        }

        public RadiusTarget(World world, double x, double y, double z, double r) {
            this(world.field_73011_w.field_76574_g, x, y, z, r);
        }

        private RadiusTarget(int world, double x, double y, double z, double r) {
            this.dim = world;
            this.x = x;
            this.y = y;
            this.z = z;
            this.radius = r;
        }

        public RadiusTarget(World world, Coordinate c, int r) {
            this(new WorldLocation(world, c), (double)r);
        }

        @Override
        public void dispatch(PacketPipeline p, ReikaPacketHelper.PacketObj pk) {
            p.sendToAllAround(pk, this.dim, this.x, this.y, this.z, this.radius);
        }
    }

    public static class CompoundPlayerTarget
    extends PacketTarget {
        private final Collection<EntityPlayerMP> player;

        public CompoundPlayerTarget(EntityPlayerMP ... ep) {
            this.player = ReikaJavaLibrary.makeListFromArray(ep);
        }

        public CompoundPlayerTarget(Collection<EntityPlayerMP> ep) {
            this.player = new ArrayList<EntityPlayerMP>(ep);
        }

        @Override
        public void dispatch(PacketPipeline p, ReikaPacketHelper.PacketObj pk) {
            for (EntityPlayerMP ep : this.player) {
                p.sendToPlayer(pk, ep);
            }
        }
    }

    public static final class OtherPlayersTarget
    extends CompoundPlayerTarget {
        public OtherPlayersTarget(EntityPlayer ep, double r) {
            super(ep.field_70170_p.func_94576_a((Entity)ep, ReikaAABBHelper.getEntityCenteredAABB((Entity)ep, r), (IEntitySelector)new ReikaEntityHelper.ClassEntitySelector(EntityPlayerMP.class, true)));
        }
    }

    public static final class PlayerTarget
    extends PacketTarget {
        private final EntityPlayerMP player;

        public PlayerTarget(EntityPlayerMP ep) {
            this.player = ep;
        }

        @Override
        public void dispatch(PacketPipeline p, ReikaPacketHelper.PacketObj pk) {
            p.sendToPlayer(pk, this.player);
        }
    }
}

