/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable;

import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.World.ReikaBlockHelper;
import Reika.DragonAPI.ModInteract.DeepInteract.MESystemReader;
import java.util.HashMap;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public abstract class ItemFilter {
    protected ItemFilter() {
    }

    public abstract void writeToNBT(NBTTagCompound var1);

    public abstract void readFromNBT(NBTTagCompound var1);

    public abstract boolean matches(ItemStack var1);

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public abstract ItemStack getItem();

    public static final class ItemRule
    extends ItemFilter {
        private ItemStack item;
        private MESystemReader.MatchMode mode;

        public ItemRule(ItemStack is) {
            this(is, MESystemReader.MatchMode.EXACTNONBT);
        }

        public ItemRule(ItemStack is, MESystemReader.MatchMode m) {
            this.item = ReikaItemHelper.getSizedItemStack(is, is.func_77976_d());
            this.mode = m;
        }

        @Override
        public boolean matches(ItemStack is) {
            return this.mode.compare(is, this.item);
        }

        @Override
        public int hashCode() {
            return this.item.func_77973_b().hashCode() ^ this.mode.ordinal();
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof ItemRule) {
                ItemRule ir = (ItemRule)o;
                return ItemStack.func_77989_b((ItemStack)this.item, (ItemStack)ir.item) && this.mode == ir.mode;
            }
            return false;
        }

        public String toString() {
            return this.item + " * " + (Object)((Object)this.mode);
        }

        @Override
        public ItemStack getItem() {
            return this.item.func_77946_l();
        }

        @Override
        public void readFromNBT(NBTTagCompound tag) {
            ItemStack is;
            this.item = is = ItemStack.func_77949_a((NBTTagCompound)tag);
            this.mode = MESystemReader.MatchMode.list[tag.func_74762_e("mode")];
        }

        @Override
        public void writeToNBT(NBTTagCompound tag) {
            tag.func_74768_a("mode", this.mode.ordinal());
            this.item.func_77955_b(tag);
        }
    }

    public static final class ItemCategoryMatch
    extends ItemFilter {
        private static final HashMap<String, ItemCategory> categories = new HashMap();
        private ItemCategory category;

        public ItemCategoryMatch(ItemCategory cat) {
            this.category = cat;
        }

        public static void addCategory(ItemCategory cat) {
            categories.put(cat.getID(), cat);
        }

        public static ItemCategory getCategory(String cat) {
            return categories.get(cat);
        }

        @Override
        public void writeToNBT(NBTTagCompound tag) {
            tag.func_74778_a("id", this.category.getID());
        }

        @Override
        public void readFromNBT(NBTTagCompound tag) {
            this.category = ItemCategoryMatch.getCategory(tag.func_74779_i("id"));
        }

        @Override
        public boolean matches(ItemStack is) {
            return this.category.isItemInCategory(is);
        }

        @Override
        public int hashCode() {
            return this.category.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof ItemCategoryMatch && this.category.equals(((ItemCategoryMatch)o).category);
        }

        @Override
        public ItemStack getItem() {
            return null;
        }

        public static interface ItemCategory {
            public boolean isItemInCategory(ItemStack var1);

            public String getID();
        }

        public static enum BasicCategories implements ItemCategory
        {
            ORE,
            MOBDROP;


            private BasicCategories() {
                ItemCategoryMatch.addCategory(this);
            }

            @Override
            public boolean isItemInCategory(ItemStack is) {
                switch (this) {
                    case ORE: {
                        return ReikaBlockHelper.isOre(is);
                    }
                }
                return false;
            }

            @Override
            public String getID() {
                return this.name();
            }
        }
    }
}

