/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable;

import Reika.DragonAPI.Instantiable.GUI.GuiItemDisplay;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public abstract class ItemSpecificEffectDescription {
    public abstract String getDescription(GuiItemDisplay var1);

    public abstract List<GuiItemDisplay> getRelevantItems();

    public static class ItemListEffectDescription
    extends ItemSpecificEffectDescription
    implements Comparable<ItemListEffectDescription> {
        public final String description;
        private final ArrayList<GuiItemDisplay> items = new ArrayList();
        private int ordering;

        public ItemListEffectDescription(String s) {
            this.description = s;
        }

        public final ItemListEffectDescription setOrderIndex(int index) {
            this.ordering = index;
            return this;
        }

        public final ItemListEffectDescription addIcons(IIcon ... set) {
            for (IIcon is : set) {
                this.items.add(new GuiItemDisplay.GuiIconDisplay(is));
            }
            Collections.sort(this.items);
            return this;
        }

        public final ItemListEffectDescription addItems(Collection<ItemStack> c) {
            for (ItemStack is : c) {
                if (is.func_77973_b() == null) {
                    throw new IllegalArgumentException("Null item!");
                }
                this.items.add(new GuiItemDisplay.GuiStackDisplay(is));
            }
            Collections.sort(this.items);
            return this;
        }

        public final ItemListEffectDescription addItems(ItemStack ... set) {
            for (ItemStack is : set) {
                if (is.func_77973_b() == null) {
                    throw new IllegalArgumentException("Null item!");
                }
                this.items.add(new GuiItemDisplay.GuiStackDisplay(is));
            }
            Collections.sort(this.items);
            return this;
        }

        public final ItemListEffectDescription addDisplays(Collection<GuiItemDisplay> set) {
            for (GuiItemDisplay is : set) {
                if (is.isEmpty() || this.items.contains(is)) continue;
                this.items.add(is);
            }
            Collections.sort(this.items);
            return this;
        }

        public final ItemListEffectDescription addDisplays(GuiItemDisplay ... set) {
            for (GuiItemDisplay is : set) {
                if (is.isEmpty() || this.items.contains(is)) continue;
                this.items.add(is);
            }
            Collections.sort(this.items);
            return this;
        }

        @Override
        public final List<GuiItemDisplay> getRelevantItems() {
            return Collections.unmodifiableList(this.items);
        }

        public String toString() {
            return this.description + ": " + this.items;
        }

        @Override
        public final int compareTo(ItemListEffectDescription o) {
            if (o.ordering != this.ordering) {
                return Integer.compare(this.ordering, o.ordering);
            }
            if (Strings.isNullOrEmpty((String)this.description) && Strings.isNullOrEmpty((String)o.description)) {
                return 0;
            }
            if (Strings.isNullOrEmpty((String)this.description)) {
                return -1;
            }
            if (Strings.isNullOrEmpty((String)o.description)) {
                return 1;
            }
            return this.description.compareToIgnoreCase(o.description);
        }

        @Override
        public String getDescription(GuiItemDisplay i) {
            return this.description;
        }
    }
}

