/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable;

import Reika.DragonAPI.Instantiable.Data.BlockStruct.BlockArray;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import java.util.HashMap;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class LightingCache {
    private BlockArray blocks = new BlockArray();
    private final HashMap<Coordinate, CachedBrightness> brightness = new HashMap();
    private final int maxUpdateRate;

    public LightingCache() {
        this(1);
    }

    public LightingCache(int maxr) {
        this.maxUpdateRate = maxr;
    }

    public void update(World world) {
        this.brightness.clear();
        for (Coordinate c : this.blocks.keySet()) {
            this.calcBrightness(world, c);
        }
    }

    public void update(World world, int x, int y, int z) {
        Coordinate c = new Coordinate(x, y, z);
        this.calcBrightness(world, c);
    }

    private void calcBrightness(World world, Coordinate c) {
        long time;
        CachedBrightness cb = this.brightness.get(c);
        if (cb == null) {
            cb = new CachedBrightness();
            this.brightness.put(c, cb);
        }
        if ((time = world.func_82737_E()) >= cb.lastCalculation + (long)this.maxUpdateRate) {
            cb.brightness = c.getBlock((IBlockAccess)world).func_149677_c((IBlockAccess)world, c.xCoord, c.yCoord, c.zCoord);
            cb.lastCalculation = time;
        }
    }

    public void setArray(BlockArray b) {
        this.blocks = b;
    }

    public int getCachedBrightness(World world, Coordinate c) {
        CachedBrightness get = this.brightness.get(c);
        if (get == null) {
            this.calcBrightness(world, c);
            get = this.brightness.get(c);
        }
        return get.brightness;
    }

    private static class CachedBrightness {
        private int brightness;
        private long lastCalculation;

        private CachedBrightness() {
        }
    }
}

