/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Math;

import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaVectorHelper;
import Reika.DragonAPI.Libraries.Rendering.ReikaColorAPI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.Vec3;
import org.lwjgl.opengl.GL11;

public class HexGrid {
    private static final List<Hex> directions = Collections.unmodifiableList(ReikaJavaLibrary.makeListFrom(new Hex(1.0, 1, -1, 0), new Hex(1.0, 0, -1, 1), new Hex(1.0, -1, 0, 1), new Hex(1.0, -1, 1, 0), new Hex(1.0, 0, 1, -1), new Hex(1.0, 1, 0, -1)));
    private static final List<Hex> diagonals = Collections.unmodifiableList(ReikaJavaLibrary.makeListFrom(new Hex(1.0, 2, -1, -1), new Hex(1.0, 1, -2, 1), new Hex(1.0, -1, -1, 2), new Hex(1.0, -2, 1, 1), new Hex(1.0, -1, 2, -1), new Hex(1.0, 1, 1, -2)));
    private static final Orientation angled = new Orientation(Math.sqrt(3.0), Math.sqrt(3.0) / 2.0, 0.0, 1.5, Math.sqrt(3.0) / 3.0, -0.3333333333333333, 0.0, 0.6666666666666666, 0.5);
    private static final Orientation flat = new Orientation(1.5, 0.0, Math.sqrt(3.0) / 2.0, Math.sqrt(3.0), 0.6666666666666666, 0.0, -0.3333333333333333, Math.sqrt(3.0) / 3.0, 0.0);
    private final HashMap<Coordinate, Hex> hexes = new HashMap();
    public final int size;
    public final double hexSize;
    private final Orientation style;
    private final MapShape shape;
    private GridProperties properties;

    public HexGrid(int s, double s2, boolean flatTop, MapShape shape) {
        this.style = flatTop ? flat : angled;
        this.size = s;
        this.shape = shape;
        this.hexSize = s2;
    }

    public GridProperties getGridProperties() {
        if (this.properties == null) {
            this.properties = new GridProperties(this);
        }
        return this.properties;
    }

    public HexGrid addHex(Hex h) {
        return this.addHex(h.q, h.r, h.s);
    }

    public HexGrid addHex(int q, int r, int s) {
        if (q + r + s != 0) {
            throw new IllegalArgumentException("Q, R, and S must sum to zero!");
        }
        if (!this.shape.isInGrid(q, r, s, this.size)) {
            throw new IllegalArgumentException("Position outside grid!");
        }
        if (!this.hexes.containsKey(new Coordinate(q, r, s))) {
            this.hexes.put(new Coordinate(q, r, s), new Hex(this.hexSize, q, r, s));
        }
        this.properties = null;
        return this;
    }

    public HexGrid flower() {
        this.addHex(0, 0, 0);
        for (int i = 1; i < this.size; i += 2) {
            HashSet<Hex> cp = new HashSet<Hex>(this.getAllHexes());
            for (Hex h : cp) {
                Collection<Hex> c = h.getNeighbors();
                for (Hex h2 : c) {
                    if (!this.shape.isInGrid(h2, this.size)) continue;
                    this.addHex(h2);
                }
            }
        }
        return this;
    }

    public int cellCount() {
        return this.hexes.size();
    }

    public Collection<Hex> getAllHexes() {
        return Collections.unmodifiableCollection(this.hexes.values());
    }

    public Hex getHex(int q, int r, int s) {
        return this.hexes.get(new Coordinate(q, r, s));
    }

    public Hex getRandomEdgeCell(Random rand) {
        int d = rand.nextInt(6);
        Hex h = new Hex(this.hexSize, 0, 0, 0);
        while (this.containsHex(h.getNeighbor(d))) {
            h = h.getNeighbor(d);
        }
        return h;
    }

    public boolean isHexAtEdge(Hex h) {
        return Math.abs(h.q) + Math.abs(h.r) + Math.abs(h.s) == this.size - 1;
    }

    public Point getHexLocation(Hex h) {
        double x = (this.style.f0 * (double)h.q + this.style.f1 * (double)h.r) * this.hexSize / 2.0;
        double y = (this.style.f2 * (double)h.q + this.style.f3 * (double)h.r) * this.hexSize / 2.0;
        return new Point(x, y);
    }

    public Hex getHexAtLocation(int x, int y) {
        FractionalHex f = this.getFHexAtLocation(x, y);
        Hex h = f.hexRound();
        return this.containsHex(h) ? h : null;
    }

    public boolean containsHex(Hex h) {
        return this.hexes.containsKey(new Coordinate(h.q, h.r, h.s));
    }

    public boolean containsHex(int q, int r, int s) {
        return this.hexes.containsKey(new Coordinate(q, r, s));
    }

    private FractionalHex getFHexAtLocation(int x, int y) {
        double dx = (double)x * 2.0 / this.hexSize;
        double dy = (double)y * 2.0 / this.hexSize;
        double q = this.style.b0 * dx + this.style.b1 * dy;
        double r = this.style.b2 * dx + this.style.b3 * dy;
        return new FractionalHex(this.hexSize, q, r, -q - r);
    }

    public int getNeighborDirection(double angle) {
        double a = angle = (angle + 360.0) % 360.0;
        int val = (int)Math.floor(a / 60.0);
        return val;
    }

    public void drawHexEdges(Tessellator v5, Hex h, int color) {
        float f = GL11.glGetFloat((int)2849);
        GL11.glLineWidth((float)3.0f);
        GL11.glDisable((int)3553);
        v5.func_78371_b(2);
        v5.func_78384_a(color & 0xFFFFFF, ReikaColorAPI.getAlpha(color));
        double r = this.hexSize / 2.0;
        for (double a = Math.toDegrees(this.style.start_angle); a < 360.0; a += 60.0) {
            double dx = r + 0.1 + r * Math.cos(Math.toRadians(a));
            double dy = r - 1.0 + r * Math.sin(Math.toRadians(a));
            v5.func_78377_a(dx, dy, 0.0);
        }
        v5.func_78381_a();
        GL11.glLineWidth((float)f);
        GL11.glEnable((int)3553);
    }

    public void drawFilledHex(Tessellator v5, Hex h, int color) {
        GL11.glPushAttrib((int)1048575);
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2884);
        v5.func_78371_b(6);
        v5.func_78384_a(color & 0xFFFFFF, ReikaColorAPI.getAlpha(color));
        double r = this.hexSize / 2.0;
        v5.func_78377_a(r + 0.1, r - 1.0, 0.0);
        for (double a = Math.toDegrees(this.style.start_angle); a <= 360.0 + this.style.start_angle; a += 60.0) {
            double dx = r + 0.1 + r * Math.cos(Math.toRadians(a));
            double dy = r - 1.0 + r * Math.sin(Math.toRadians(a));
            v5.func_78377_a(dx, dy, 0.0);
        }
        v5.func_78381_a();
        GL11.glPopAttrib();
    }

    public void drawTexturedGrid(Tessellator v5) {
        GL11.glPushAttrib((int)1048575);
        GL11.glDisable((int)2884);
        double minX = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        for (Hex h : this.hexes.values()) {
            Point p = this.getHexLocation(h);
            minX = Math.min(minX, p.x);
            minY = Math.min(minY, p.y);
            maxX = Math.max(maxX, p.x);
            maxY = Math.max(maxY, p.y);
        }
        double sizeX = (maxX += this.hexSize / 2.0) - (minX -= this.hexSize / 2.0);
        double sizeY = (maxY += this.hexSize / 2.0) - (minY -= this.hexSize / 2.0);
        for (Hex h : this.hexes.values()) {
            Point p = this.getHexLocation(h);
            double fx = (p.x - this.hexSize / 2.0) / sizeX;
            double fy = (p.y - this.hexSize / 2.0) / sizeY;
            GL11.glPushMatrix();
            GL11.glTranslated((double)p.x, (double)p.y, (double)0.0);
            v5.func_78371_b(6);
            v5.func_78384_a(0xFFFFFF, 255);
            double cu = 0.5 + fx;
            double cv = 0.5 + fy;
            double r = this.hexSize / 2.0;
            double x = r + 0.1;
            double y = r - 1.0;
            double u = cu + x / sizeX;
            double v = cv + y / sizeY;
            v5.func_78374_a(x, y, 0.0, u, v);
            for (double a = Math.toDegrees(this.style.start_angle); a <= 360.0 + this.style.start_angle; a += 60.0) {
                double ang = Math.toRadians(a);
                double dx = r + 0.1 + r * Math.cos(ang);
                double dy = r - 1.0 + r * Math.sin(ang);
                u = cu + dx / sizeX;
                v = cv + dy / sizeY;
                v5.func_78374_a(dx, dy, 0.0, u, v);
            }
            v5.func_78381_a();
            GL11.glPopMatrix();
        }
        GL11.glPopAttrib();
    }

    public void drawTexturedHex(Tessellator v5, Hex h, double cu, double cv, double tr) {
        GL11.glPushAttrib((int)1048575);
        GL11.glDisable((int)2884);
        v5.func_78371_b(6);
        v5.func_78384_a(0xFFFFFF, 255);
        double r = this.hexSize / 2.0;
        v5.func_78374_a(r + 0.1, r - 1.0, 0.0, cu, cv);
        for (double a = Math.toDegrees(this.style.start_angle); a <= 360.0 + this.style.start_angle; a += 60.0) {
            double ang = Math.toRadians(a);
            double dx = r + 0.1 + r * Math.cos(ang);
            double dy = r - 1.0 + r * Math.sin(ang);
            double u = cu + tr * Math.cos(ang);
            double v = cv + tr * Math.sin(ang);
            v5.func_78374_a(dx, dy, 0.0, u, v);
        }
        v5.func_78381_a();
        GL11.glPopAttrib();
    }

    public ArrayList<Integer> getValidMovementDirections(Hex location) {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        for (int i = 0; i < 6; ++i) {
            Hex h = location.getNeighbor(i);
            if (!this.containsHex(h)) continue;
            ret.add(i);
        }
        return ret;
    }

    public int getOppositeDirection(int dir) {
        return (dir + 3) % 6;
    }

    public Collection<Hex> getRegion(Hex start, Collection<Hex> exclusions) {
        return this.getRegion(start, new HashSet<Hex>(exclusions));
    }

    private Collection<Hex> getRegion(Hex start, HashSet<Hex> exclusions) {
        exclusions.add(start);
        HashSet<Hex> ret = new HashSet<Hex>();
        ret.add(start);
        for (Hex h : start.getNeighbors()) {
            if (!this.containsHex(h) || exclusions.contains(h)) continue;
            ret.addAll(this.getRegion(h, exclusions));
        }
        return ret;
    }

    public boolean dividesGrid(Hex start, Collection<Hex> exclusions) {
        return this.dividesGrid(start, new HashSet<Hex>(exclusions));
    }

    private boolean dividesGrid(Hex start, HashSet<Hex> exclusions) {
        Collection<Hex> region = null;
        for (Hex h : start.getNeighbors()) {
            if (!this.containsHex(h) || exclusions.contains(h)) continue;
            Collection<Hex> region2 = this.getRegion(start, exclusions);
            if (region == null) {
                region = region2;
            }
            if (region.equals(region2)) continue;
            return true;
        }
        return false;
    }

    public static final class GridProperties {
        public final double minX;
        public final double maxX;
        public final double minY;
        public final double maxY;
        public final double sizeX;
        public final double sizeY;

        private GridProperties(HexGrid g) {
            double nx = Double.POSITIVE_INFINITY;
            double px = Double.NEGATIVE_INFINITY;
            double ny = Double.POSITIVE_INFINITY;
            double py = Double.NEGATIVE_INFINITY;
            for (Hex h : g.hexes.values()) {
                Point p = g.getHexLocation(h);
                nx = Math.min(nx, p.x);
                ny = Math.min(ny, p.y);
                px = Math.max(px, p.x);
                py = Math.max(py, p.y);
            }
            this.minX = nx -= g.hexSize / 2.0;
            this.maxX = px += g.hexSize / 2.0;
            this.minY = ny -= g.hexSize / 2.0;
            this.maxY = py += g.hexSize / 2.0;
            this.sizeX = this.maxX - this.minX;
            this.sizeY = this.maxY - this.minY;
        }
    }

    public static final class Point {
        public final double x;
        public final double y;

        public Point(double x, double y) {
            this.x = x;
            this.y = y;
        }

        public Point translate(double dx, double dy) {
            return new Point(this.x + dx, this.y + dy);
        }

        public Point scale(double d) {
            return this.scale(d, d);
        }

        public Point scale(double sx, double sy) {
            return new Point(this.x * sx, this.y * sy);
        }

        public Point rotate(double r, int ox, int oz) {
            Vec3 ret = ReikaVectorHelper.rotateVector(Vec3.func_72443_a((double)(this.x - (double)ox), (double)0.0, (double)(this.y - (double)oz)), 0.0, r, 0.0);
            double x2 = (double)ox + ret.field_72450_a;
            double y2 = (double)oz + ret.field_72449_c;
            return new Point(x2, y2);
        }
    }

    private static final class Orientation {
        public final double f0;
        public final double f1;
        public final double f2;
        public final double f3;
        public final double b0;
        public final double b1;
        public final double b2;
        public final double b3;
        public final double start_angle;

        public Orientation(double f0, double f1, double f2, double f3, double b0, double b1, double b2, double b3, double start_angle) {
            this.f0 = f0;
            this.f1 = f1;
            this.f2 = f2;
            this.f3 = f3;
            this.b0 = b0;
            this.b1 = b1;
            this.b2 = b2;
            this.b3 = b3;
            this.start_angle = start_angle;
        }
    }

    private static final class OffsetCoord {
        public final int col;
        public final int row;
        public static final int EVEN = 1;
        public static final int ODD = -1;

        public OffsetCoord(int col, int row) {
            this.col = col;
            this.row = row;
        }

        public Hex roffsetToCube(double size, int offset) {
            int q = this.col - (this.row + offset * (this.row & 1)) / 2;
            int r = this.row;
            int s = -q - r;
            return new Hex(size, q, r, s);
        }

        public Hex qoffsetToCube(double size, int offset) {
            int q = this.col;
            int r = this.row - (this.col + offset * (this.col & 1)) / 2;
            int s = -q - r;
            return new Hex(size, q, r, s);
        }

        public static OffsetCoord roffsetFromCube(int offset, Hex h) {
            int col = h.q + (h.r + offset * (h.r & 1)) / 2;
            int row = h.r;
            return new OffsetCoord(col, row);
        }

        public static OffsetCoord qoffsetFromCube(int offset, Hex h) {
            int col = h.q;
            int row = h.r + (h.q + offset * (h.q & 1)) / 2;
            return new OffsetCoord(col, row);
        }
    }

    private static final class FractionalHex {
        public final double size;
        public final double q;
        public final double r;
        public final double s;

        public FractionalHex(double sz, double q, double r, double s) {
            this.size = sz;
            this.q = q;
            this.r = r;
            this.s = s;
        }

        public Hex hexRound() {
            int q = (int)Math.round(this.q);
            int r = (int)Math.round(this.r);
            int s = (int)Math.round(this.s);
            double q_diff = Math.abs((double)q - this.q);
            double r_diff = Math.abs((double)r - this.r);
            double s_diff = Math.abs((double)s - this.s);
            if (q_diff > r_diff && q_diff > s_diff) {
                q = -r - s;
            } else if (r_diff > s_diff) {
                r = -q - s;
            } else {
                s = -q - r;
            }
            return new Hex(this.size, q, r, s);
        }

        public String toString() {
            return this.q + ", " + this.r + ", " + this.s;
        }

        public static FractionalHex hexLerp(double size, FractionalHex a, FractionalHex b, double t) {
            return new FractionalHex(size, a.q * (1.0 - t) + b.q * t, a.r * (1.0 - t) + b.r * t, a.s * (1.0 - t) + b.s * t);
        }

        public static ArrayList<Hex> hexLinedraw(double size, Hex a, Hex b) {
            int N = Hex.distance(size, a, b);
            FractionalHex a_nudge = new FractionalHex(a.size, (double)a.q + 1.0E-6, (double)a.r + 1.0E-6, (double)a.s - 2.0E-6);
            FractionalHex b_nudge = new FractionalHex(a.size, (double)b.q + 1.0E-6, (double)b.r + 1.0E-6, (double)b.s - 2.0E-6);
            ArrayList<Hex> results = new ArrayList<Hex>();
            double step = 1.0 / (double)Math.max(N, 1);
            for (int i = 0; i <= N; ++i) {
                results.add(FractionalHex.hexLerp(size, a_nudge, b_nudge, step * (double)i).hexRound());
            }
            return results;
        }
    }

    public static final class Hex {
        public final double size;
        public final int q;
        public final int r;
        public final int s;

        public Hex(double sz, int q, int r, int s) {
            this.size = sz;
            this.q = q;
            this.r = r;
            this.s = s;
            if (q + r + s != 0) {
                throw new IllegalArgumentException("Q, R, and S must sum to zero!");
            }
        }

        public Hex scale(int k) {
            return new Hex(this.size, this.q * k, this.r * k, this.s * k);
        }

        public Hex getNeighbor(int direction) {
            return Hex.add(this.size, this, (Hex)directions.get(direction));
        }

        public Hex diagonalNeighbor(int direction) {
            return Hex.add(this.size, this, (Hex)diagonals.get(direction));
        }

        public int length() {
            return (Math.abs(this.q) + Math.abs(this.r) + Math.abs(this.s)) / 2;
        }

        public Collection<Hex> getNeighbors() {
            HashSet<Hex> c = new HashSet<Hex>();
            for (Hex h : directions) {
                c.add(Hex.add(this.size, this, h));
            }
            return c;
        }

        public static int distance(double size, Hex a, Hex b) {
            return Hex.subtract(size, a, b).length();
        }

        public Hex offset(Hex h) {
            return Hex.add(this.size, this, h);
        }

        public Hex offset(int q, int r, int s) {
            return Hex.add(this.size, this, new Hex(this.size, q, r, s));
        }

        public Hex subtract(Hex h) {
            return Hex.subtract(this.size, this, h);
        }

        public static Hex add(double size, Hex a, Hex b) {
            return new Hex(size, a.q + b.q, a.r + b.r, a.s + b.s);
        }

        public static Hex subtract(double size, Hex a, Hex b) {
            return new Hex(size, a.q - b.q, a.r - b.r, a.s - b.s);
        }

        public int hashCode() {
            return (-this.q * 17 ^ this.r * 77) * this.s * 37;
        }

        public boolean equals(Object o) {
            if (o instanceof Hex) {
                Hex h = (Hex)o;
                return h.q == this.q && h.r == this.r && h.s == this.s;
            }
            return false;
        }

        public String toString() {
            return this.q + "," + this.r + "," + this.s;
        }
    }

    public static enum MapShape {
        RECTANGLE,
        TRIANGLE,
        HEXAGON,
        RHOMBUS;


        public boolean isInGrid(Hex h, int diameter) {
            return this.isInGrid(h.q, h.r, h.s, diameter);
        }

        public boolean isInGrid(int q, int r, int s, int diameter) {
            switch (this) {
                case HEXAGON: {
                    return Math.abs(q) + Math.abs(r) + Math.abs(s) <= diameter - 1;
                }
                case RECTANGLE: {
                    break;
                }
                case RHOMBUS: {
                    break;
                }
            }
            return false;
        }
    }
}

