/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Libraries.Java.ReikaArrayHelper;
import net.minecraft.entity.Entity;

public class MotionTracker {
    private double posX;
    private double posY;
    private double posZ;
    private int lastMoved = 0;
    private double totalDistance3DSq;
    private final double[] totalDistanceHistory;
    private final int sampleRate;
    private int tick = 0;

    public MotionTracker(int length) {
        this(length, 1);
    }

    public MotionTracker(int length, int rate) {
        this.totalDistanceHistory = new double[length];
        this.sampleRate = rate;
    }

    public void update(Entity e) {
        this.update(e.field_70165_t, e.field_70163_u, e.field_70161_v);
    }

    public void update(double x, double y, double z) {
        ++this.tick;
        double dx = x - this.posX;
        double dy = y - this.posY;
        double dz = z - this.posZ;
        if (dx != 0.0 || dy != 0.0 || dz != 0.0) {
            this.lastMoved = 0;
        }
        double dd = dx * dx + dy * dy + dz * dz;
        this.totalDistance3DSq += dd;
        if (this.tick % this.sampleRate == 0) {
            ReikaArrayHelper.cycleArray(this.totalDistanceHistory, dd);
        }
        this.posX = x;
        this.posY = y;
        this.posZ = z;
    }

    public int getLastMoved() {
        return this.lastMoved;
    }

    public double getTotalTravelDistanceSq() {
        return this.totalDistance3DSq;
    }

    public double getTotalTravelDistanceSince(int steps) {
        if (steps > this.totalDistanceHistory.length) {
            DragonAPICore.logError("You cannot get the travel history for more steps than the history is long!");
            return 0.0;
        }
        double ret = 0.0;
        for (int i = 0; i < steps; ++i) {
            ret += this.totalDistanceHistory[i];
        }
        return ret;
    }
}

