/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable;

import Reika.DragonAPI.Instantiable.ProgressBar;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import java.util.ArrayList;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class MultiStageProgressBar {
    private final ArrayList<ProgressBar> bars = new ArrayList();

    public MultiStageProgressBar addBar(int dur) {
        return this.addBar(new ProgressBar(dur));
    }

    public MultiStageProgressBar addBar(ProgressBar.DurationCallback b) {
        return this.addBar(new ProgressBar(b));
    }

    public MultiStageProgressBar addBar(ProgressBar b) {
        this.bars.add(b);
        return this;
    }

    public boolean tick() {
        return this.tick(1);
    }

    public boolean tick(int amt) {
        for (int i = 0; i < this.bars.size(); ++i) {
            ProgressBar b = this.bars.get(i);
            int ticked = b.tickNoRollover(amt);
            amt -= ticked;
            if (i == this.bars.size() - 1 && b.isComplete()) {
                return true;
            }
            if (amt > 0) continue;
            return false;
        }
        return false;
    }

    public int getScaledBar(int slot, int len) {
        return this.bars.get(slot).getScaled(len);
    }

    public int getTick(int slot) {
        return this.bars.get(slot).getTick();
    }

    public void writeToNBT(NBTTagCompound nbt) {
        NBTTagList li = new NBTTagList();
        for (ProgressBar b : this.bars) {
            NBTTagCompound tag = new NBTTagCompound();
            b.writeToNBT(tag);
            li.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("bars", (NBTBase)li);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.bars.clear();
        NBTTagList li = nbt.func_150295_c("bars", ReikaNBTHelper.NBTTypes.COMPOUND.ID);
        for (Object o : li.field_74747_a) {
            NBTTagCompound tag = (NBTTagCompound)o;
            ProgressBar b = new ProgressBar(0);
            b.readFromNBT(tag);
            this.addBar(b);
        }
    }
}

