/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.ParticleController;

import Reika.DragonAPI.Instantiable.Data.Immutable.DecimalPosition;
import Reika.DragonAPI.Instantiable.Orbit;
import Reika.DragonAPI.Interfaces.PositionController;
import net.minecraft.entity.Entity;

public class OrbitMotionController
implements PositionController {
    private double originX;
    private double originY;
    private double originZ;
    public final Orbit orbit;
    private double theta;
    public double thetaSpeed = 1.0;
    private DecimalPosition position;
    private Entity trackedEntity;

    public OrbitMotionController(Orbit o, double x, double y, double z) {
        this.orbit = o;
        this.originX = x;
        this.originY = y;
        this.originZ = z;
        this.position = new DecimalPosition(x, y, z);
        this.position = this.orbit.getPosition(this.originX, this.originY, this.originZ, this.theta);
    }

    public OrbitMotionController trackEntity(Entity e) {
        this.trackedEntity = e;
        this.originX = e.field_70165_t;
        this.originY = e.field_70163_u;
        this.originZ = e.field_70161_v;
        this.position = this.orbit.getPosition(this.originX, this.originY, this.originZ, this.theta);
        return this;
    }

    @Override
    public void update(Entity e) {
        if (this.trackedEntity != null) {
            this.originX = this.trackedEntity.field_70165_t;
            this.originY = this.trackedEntity.field_70163_u;
            this.originZ = this.trackedEntity.field_70161_v;
        }
        this.position = this.orbit.getPosition(this.originX, this.originY, this.originZ, this.theta);
        this.theta += this.thetaSpeed;
    }

    @Override
    public double getPositionX(Entity e) {
        return this.position.xCoord;
    }

    @Override
    public double getPositionY(Entity e) {
        return this.position.yCoord;
    }

    @Override
    public double getPositionZ(Entity e) {
        return this.position.zCoord;
    }
}

