/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable;

import Reika.DragonAPI.Instantiable.Data.BlockStruct.BreadthFirstSearch;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.OpenPathFinder;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockVector;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Immutable.DecimalPosition;
import Reika.DragonAPI.Instantiable.Data.Maps.PluralMap;
import Reika.DragonAPI.Instantiable.Math.Spline;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ParticlePath {
    private static final PluralMap<ParticlePath> pathCache = new PluralMap(2);
    public final Coordinate source;
    public final Coordinate target;
    private final List<DecimalPosition> path;
    public final Spline spline;
    private final HashSet<Coordinate> coords;

    private ParticlePath(Coordinate c1, Coordinate c2, Spline s, HashSet<Coordinate> set) {
        this.source = c1;
        this.target = c2;
        this.spline = s;
        this.path = Collections.unmodifiableList(s.get(12, false));
        this.coords = set;
        for (DecimalPosition p : this.path) {
            this.coords.add(new Coordinate(p.xCoord, p.yCoord, p.zCoord));
        }
    }

    public boolean isValid(World world) {
        for (Coordinate c : this.coords) {
            if (c.equals(this.source) || c.equals(this.target) || c.getBlock((IBlockAccess)world).isAir((IBlockAccess)world, c.xCoord, c.yCoord, c.zCoord)) continue;
            return false;
        }
        return true;
    }

    public List<DecimalPosition> getPath() {
        return Collections.unmodifiableList(this.path);
    }

    public static ParticlePath getPath(World world, BlockVector from, BlockVector to, double offset, double forceDirection) {
        ParticlePath p = pathCache.get(from, to);
        if (p == null || !p.isValid(world)) {
            p = ParticlePath.calculateParticlePath(world, from, to, offset, forceDirection);
            pathCache.put(p, from, to);
        }
        return p;
    }

    private static ParticlePath calculateParticlePath(World world, BlockVector from, BlockVector to, double endOffset, double forceDirection) {
        LinkedList<Coordinate> li = BreadthFirstSearch.getOpenPathBetween(world, from.getCoord(), to.getCoord(), 24, EnumSet.of(OpenPathFinder.PassRules.SOFT, OpenPathFinder.PassRules.SMALLNONSOLID)).getPath();
        if (li != null) {
            HashSet<Coordinate> set = new HashSet<Coordinate>();
            double sx = (double)from.xCoord + 0.5;
            double sy = (double)from.yCoord + 0.5;
            double sz = (double)from.zCoord + 0.5;
            double tx = (double)to.xCoord + 0.5;
            double ty = (double)to.yCoord + 0.5;
            double tz = (double)to.zCoord + 0.5;
            sx -= (double)from.direction.offsetX * endOffset;
            sy -= (double)from.direction.offsetY * endOffset;
            sz -= (double)from.direction.offsetZ * endOffset;
            tx -= (double)to.direction.offsetX * endOffset;
            ty -= (double)to.direction.offsetY * endOffset;
            tz -= (double)to.direction.offsetZ * endOffset;
            double sx2 = sx + (double)from.direction.offsetX * forceDirection;
            double sy2 = sy + (double)from.direction.offsetY * forceDirection;
            double sz2 = sz + (double)from.direction.offsetZ * forceDirection;
            double tx2 = tx + (double)to.direction.offsetX * forceDirection;
            double ty2 = ty + (double)to.direction.offsetY * forceDirection;
            double tz2 = tz + (double)to.direction.offsetZ * forceDirection;
            Spline s1 = new Spline(Spline.SplineType.CENTRIPETAL);
            s1.addPoint(new Spline.BasicSplinePoint(new DecimalPosition(sx, sy, sz)));
            s1.addPoint(new Spline.BasicSplinePoint(new DecimalPosition(sx2, sy2, sz2)));
            int i = -1;
            for (Coordinate c : li) {
                if (i % 4 == 0 && c != li.getLast()) {
                    if (!c.equals(to) && !c.equals(from)) {
                        set.add(c);
                    }
                    s1.addPoint(new Spline.BasicSplinePoint(new DecimalPosition(c)));
                }
                ++i;
            }
            s1.addPoint(new Spline.BasicSplinePoint(new DecimalPosition(tx2, ty2, tz2)));
            s1.addPoint(new Spline.BasicSplinePoint(new DecimalPosition(tx, ty, tz)));
            ParticlePath p = new ParticlePath(from.getCoord(), to.getCoord(), s1, set);
            return p;
        }
        return null;
    }
}

