/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Recipe;

import Reika.DragonAPI.Instantiable.Data.KeyedItemStack;
import Reika.DragonAPI.Instantiable.IO.CustomRecipeList;
import Reika.DragonAPI.Instantiable.IO.LuaBlock;
import Reika.DragonAPI.Instantiable.Recipe.ItemMatch;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public final class FlexibleIngredient {
    public static final FlexibleIngredient EMPTY = new FlexibleIngredient();
    private final ItemMatch filter;
    public final float chanceToUse;
    public final int numberToUse;

    private FlexibleIngredient() {
        this((ItemMatch)null, 0.0f, 1);
    }

    public FlexibleIngredient(Block in, float chance, int toDecr) {
        this(new ItemMatch(in), chance, toDecr);
    }

    public FlexibleIngredient(Item in, float chance, int toDecr) {
        this(new ItemMatch(in), chance, toDecr);
    }

    public FlexibleIngredient(ItemStack in, float chance, int toDecr) {
        this(in != null ? new ItemMatch(in) : null, chance, toDecr);
    }

    public FlexibleIngredient(String ore, float chance, int toDecr) {
        this(OreDictionary.getOres((String)ore), chance, toDecr);
    }

    public FlexibleIngredient(Collection<ItemStack> in, float chance, int toDecr) {
        this(in != null ? new ItemMatch(in) : null, chance, toDecr);
    }

    public FlexibleIngredient(ItemMatch in, float chance, int toDecr) {
        this.filter = in;
        this.chanceToUse = chance / 100.0f;
        this.numberToUse = toDecr;
    }

    public void addItem(ItemStack is) {
        if (this.filter != null) {
            this.filter.addItem(new KeyedItemStack(is).setIgnoreMetadata(false).setIgnoreNBT(true).setSized(false).setSimpleHash(true));
        }
    }

    public FlexibleIngredient lock() {
        if (this.filter != null) {
            for (KeyedItemStack ks : this.filter.getItemList()) {
                ks.lock();
            }
        }
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public ItemStack getItemForDisplay(boolean size) {
        if (!this.exists()) {
            return null;
        }
        return ReikaItemHelper.getSizedItemStack(this.filter.getCycledItem(), size ? this.numberToUse : 1);
    }

    public String toString() {
        return this.filter.getItemList() + " x" + this.numberToUse + "@" + this.chanceToUse + "%";
    }

    public String fullID(IngredientIDHandler id) {
        return this.exists() ? id.fullIDForItems(this.filter.getItemList()) + " x" + this.numberToUse + "@" + this.chanceToUse + "%" : "Empty";
    }

    public boolean match(ItemStack in) {
        return this.exists() ? this.filter.match(in) : in == null;
    }

    private boolean checkSize(ItemStack is) {
        return this.exists() ? is.field_77994_a >= this.numberToUse : true;
    }

    public boolean matchWithSize(ItemStack in) {
        return this.match(in) && this.checkSize(in);
    }

    public boolean exists() {
        return this.filter != null && !this.filter.isEmpty();
    }

    public Collection<ItemStack> getItems() {
        ArrayList<ItemStack> c = new ArrayList<ItemStack>();
        for (KeyedItemStack ks : this.filter.getItemList()) {
            c.add(ks.getItemStack());
        }
        return c;
    }

    public static FlexibleIngredient parseLua(CustomRecipeList crl, LuaBlock b, boolean allowEmptyItemList) {
        Collection<ItemStack> li;
        if (b == null) {
            return EMPTY;
        }
        Collection<ItemStack> collection = b.hasChild("items") ? CustomRecipeList.parseItemCollection(b.getChild("items").getDataValues(), true) : (li = null);
        if (li == null || li.isEmpty()) {
            if (allowEmptyItemList) {
                return EMPTY;
            }
            throw new RuntimeException("Lua block " + b.name + " found no items!");
        }
        int num = b.getInt("number_to_use");
        if (num <= 0) {
            throw new IllegalArgumentException("No number to use specified!");
        }
        if (!b.containsKeyInherit("consumption_chance")) {
            throw new IllegalArgumentException("No consumption chance specified!");
        }
        return new FlexibleIngredient(li, (float)b.getDouble("consumption_chance"), num);
    }

    public static interface IngredientIDHandler {
        public String fullIDForItems(Collection<KeyedItemStack> var1);
    }
}

