/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Rendering;

import Reika.DragonAPI.Auxiliary.ReikaBlockRenderer;
import Reika.DragonAPI.Base.ISBRH;
import Reika.DragonAPI.Interfaces.Block.SidedTextureIndex;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.world.IBlockAccess;

@SideOnly(value=Side.CLIENT)
public final class BlockSheetTexRenderer
extends ISBRH {
    private String textureSheet;
    private boolean is3D = true;
    private final Class modClass;

    public BlockSheetTexRenderer(int id, Class root, String file) {
        super(id);
        String filename;
        this.modClass = root;
        if (root == null) {
            return;
        }
        if (root.getResource(".") == null) {
            filename = "";
        } else {
            String base = root.getResource(".").getPath();
            String path = base.substring(1, base.length() - 1);
            filename = path + file;
        }
        this.textureSheet = filename;
    }

    @Override
    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
        SidedTextureIndex s = (SidedTextureIndex)block;
        int[] indices = new int[6];
        for (int i = 0; i < 6; ++i) {
            indices[i] = s.getBlockTextureFromSideAndMetadata(i, metadata);
        }
        ReikaTextureHelper.bindTexture(this.modClass, this.textureSheet);
        ReikaBlockRenderer.instance.renderBlockInInventory(block, 0, 0.0f, indices);
        ReikaTextureHelper.bindTerrainTexture();
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderblocks) {
        int metadata = world.func_72805_g(x, y, z);
        ReikaTextureHelper.bindTerrainTexture();
        return true;
    }

    public boolean shouldRender3DInInventory(int model) {
        return this.is3D;
    }
}

