/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Worldgen;

import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Worldgen.ChunkSplicedGenerator;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;

public class ChunkSplicedGenerationCache
extends ChunkSplicedGenerator {
    private final HashSet<ChunkCoordIntPair> generated = new HashSet();
    private boolean isWrapping = false;
    private int wrapDistanceX;
    private int wrapDistanceZ;

    public ChunkSplicedGenerationCache() {
        super(false);
    }

    public ChunkSplicedGenerationCache setWrapping(int distX, int distZ) {
        this.isWrapping = true;
        this.wrapDistanceX = distX >> 4;
        this.wrapDistanceZ = distZ >> 4;
        return this;
    }

    @Override
    public void place(int x, int y, int z, ChunkSplicedGenerator.BlockPlace sb) {
        ChunkCoordIntPair key = ChunkSplicedGenerationCache.getKey(x, z);
        if (this.isWrapping) {
            key = this.wrap(key);
        }
        x = ChunkSplicedGenerationCache.modAndAlign(x);
        z = ChunkSplicedGenerationCache.modAndAlign(z);
        Coordinate c = new Coordinate(x, y, z);
        this.put(key, c, sb);
    }

    private ChunkCoordIntPair wrap(ChunkCoordIntPair key) {
        return new ChunkCoordIntPair((key.field_77276_a + this.wrapDistanceX) % this.wrapDistanceX, (key.field_77275_b + this.wrapDistanceZ) % this.wrapDistanceZ);
    }

    public static int modAndAlign(int c) {
        if ((c %= 16) < 0 && (c += 16) % 16 == 0) {
            c += 16;
        }
        return c;
    }

    public BlockKey getBlock(int x, int y, int z) {
        ChunkCoordIntPair key = ChunkSplicedGenerationCache.getKey(x, z);
        Map map = (Map)this.data.get(key);
        if (map == null) {
            return null;
        }
        x = ChunkSplicedGenerationCache.modAndAlign(x);
        ChunkSplicedGenerator.BlockPlace p = (ChunkSplicedGenerator.BlockPlace)map.get(new Coordinate(x, y, z = ChunkSplicedGenerationCache.modAndAlign(z)));
        return p != null ? p.asBlockKey() : null;
    }

    public boolean hasBlock(int x, int y, int z) {
        ChunkCoordIntPair key = ChunkSplicedGenerationCache.getKey(x, z);
        Map map = (Map)this.data.get(key);
        if (map == null) {
            return false;
        }
        x = ChunkSplicedGenerationCache.modAndAlign(x);
        z = ChunkSplicedGenerationCache.modAndAlign(z);
        return map.containsKey(new Coordinate(x, y, z));
    }

    public HashSet<Coordinate> getLocationsOf(BlockKey key) {
        HashSet<Coordinate> set = new HashSet<Coordinate>();
        for (ChunkCoordIntPair p : this.data.keySet()) {
            Map map = (Map)this.data.get(p);
            for (Coordinate c : map.keySet()) {
                ChunkSplicedGenerator.BlockPlace bp = (ChunkSplicedGenerator.BlockPlace)map.get(c);
                if (!bp.asBlockKey().equals(key)) continue;
                set.add(c.offset(p.field_77276_a * 16, 0, p.field_77275_b * 16));
            }
        }
        return set;
    }

    public boolean isChunkGenerated(int x, int z) {
        return this.generated.contains(new ChunkCoordIntPair(x >> 4, z >> 4));
    }

    public void addDataFromColumnData(int chunkX, int chunkZ, Block[] data) {
        for (int dx = 0; dx < 16; ++dx) {
            for (int dz = 0; dz < 16; ++dz) {
                int x = chunkX * 16 + dx;
                int z = chunkZ * 16 + dz;
                int d = dx * 16 + dz;
                int posIndex = d * data.length / 256;
                for (int y = 0; y < 256; ++y) {
                    Block b = data[y + posIndex];
                    this.setBlock(x, y, z, b);
                }
            }
        }
    }

    public static final class RelayCache
    extends ChunkSplicedGenerationCache {
        private final World world;

        public RelayCache(World world) {
            this.world = world;
        }

        @Override
        public void place(int x, int y, int z, ChunkSplicedGenerator.BlockPlace sb) {
            sb.place(this.world, x, y, z);
        }
    }
}

