/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Worldgen;

import Reika.DragonAPI.Auxiliary.Trackers.ReflectiveFailureTracker;
import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.BasicModEntry;
import Reika.DragonAPI.Interfaces.Registry.ModEntry;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Java.ReikaStringParser;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.World.ReikaGenHelper;
import Reika.DragonAPI.ModList;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.gen.feature.WorldGenDungeons;
import net.minecraft.world.gen.structure.ComponentScatteredFeaturePieces;
import net.minecraft.world.gen.structure.StructureMineshaftPieces;
import net.minecraft.world.gen.structure.StructureNetherBridgePieces;
import net.minecraft.world.gen.structure.StructureStrongholdPieces;
import net.minecraft.world.gen.structure.StructureVillagePieces;
import net.minecraftforge.common.ChestGenHooks;

public class LootController {
    private static final HashMap<String, ChestGenLootLocation> locationsByID = new HashMap();
    private static final HashMap<String, ChestGenLootLocation> locationsByObject = new HashMap();
    private static Field chestTable;
    private static Field chestContents;
    public static ChestGenLootLocation netherFortress;
    private List<LootStack> items = new ArrayList<LootStack>();

    public void registerToWorldGen(DragonAPIMod mod, int tier) {
        if (tier <= 0) {
            mod.getModLogger().log("Skipping dungeon loot generation, as it has been disabled.");
            return;
        }
        for (LootStack ls : this.items) {
            String itemName = ls.toString();
            if (ls.lootTier <= tier) {
                ReikaGenHelper.addChestLoot(ls.chestLocation.tag, ls.item, ls.minSize, ls.maxSize, ls.weight);
                mod.getModLogger().log("Adding " + itemName + " to " + ls.chestLocation);
                continue;
            }
            mod.getModLogger().log("Not adding " + itemName + " to " + ls.chestLocation + ", as its generation tier (" + ls.lootTier + ") is greater than the configured tier of " + tier + ".");
        }
    }

    public void addItem(int tier, Location loc, ItemStack is, int min, int max, int chance) {
        LootStack ls = new LootStack(tier, loc, is, min, max, chance);
        if (!this.items.contains(ls)) {
            this.items.add(ls);
        }
    }

    public void addItem(int tier, Location loc, ItemStack is, int chance) {
        this.addItem(tier, loc, is, 1, 1, chance);
    }

    public void addItems(int tier, Location loc, List<ItemStack> li, int chance) {
        for (int i = 0; i < li.size(); ++i) {
            this.addItem(tier, loc, li.get(i), chance);
        }
    }

    public String toString() {
        return this.items.toString();
    }

    public static ChestGenLootLocation getLocationForStructure(Object struct) {
        if (struct instanceof StructureNetherBridgePieces || struct instanceof StructureNetherBridgePieces.Piece) {
            return LootController.getLocationForID("netherFortress");
        }
        return struct == null ? null : locationsByObject.get(struct.getClass().getName());
    }

    public static ChestGenLootLocation getLocationForID(String id) {
        return locationsByID.get(id);
    }

    public static ArrayList<WeightedRandomChestContent> getCGHItems(String tag) throws Exception {
        return LootController.getCGHItems(ChestGenHooks.getInfo((String)tag));
    }

    public static ArrayList<WeightedRandomChestContent> getCGHItems(ChestGenHooks entry) throws Exception {
        return (ArrayList)chestContents.get(entry);
    }

    public static void setCGHItems(String tag, WeightedRandomChestContent[] items) throws Exception {
        LootController.setCGHItems(ChestGenHooks.getInfo((String)tag), items);
    }

    public static void setCGHItems(ChestGenHooks entry, WeightedRandomChestContent[] items) throws Exception {
        chestContents.set(entry, ReikaJavaLibrary.makeListFromArray(items));
    }

    public static ChestGenHooks getChestEntry(String tag) throws Exception {
        return (ChestGenHooks)((Map)chestTable.get(null)).get(tag);
    }

    public static Set<String> getAllIDs() {
        return Collections.unmodifiableSet(locationsByID.keySet());
    }

    static {
        netherFortress = new ChestGenLootLocation(){

            @Override
            public String getTag() {
                return "netherFortress";
            }

            @Override
            public WeightedRandomChestContent[] getContents() throws Exception {
                return StructureNetherBridgePieces.Piece.field_111019_a;
            }

            @Override
            public void setContents(WeightedRandomChestContent[] items) throws Exception {
                StructureNetherBridgePieces.Piece.field_111019_a = items;
            }
        };
        try {
            chestTable = ChestGenHooks.class.getDeclaredField("chestInfo");
            chestTable.setAccessible(true);
            chestContents = ChestGenHooks.class.getDeclaredField("contents");
            chestContents.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        locationsByObject.put(WorldGenDungeons.class.getName(), Location.DUNGEON);
        locationsByObject.put(StructureNetherBridgePieces.Piece.class.getName(), netherFortress);
        locationsByObject.put(StructureMineshaftPieces.Corridor.class.getName(), Location.MINESHAFT);
        locationsByObject.put(StructureStrongholdPieces.Crossing.class.getName(), Location.STRONGHOLD_CROSSING);
        locationsByObject.put(StructureStrongholdPieces.RoomCrossing.class.getName(), Location.STRONGHOLD_CROSSING);
        locationsByObject.put(StructureStrongholdPieces.Library.class.getName(), Location.STRONGHOLD_LIBRARY);
        locationsByObject.put(StructureStrongholdPieces.ChestCorridor.class.getName(), Location.STRONGHOLD_HALLWAY);
        locationsByObject.put(ComponentScatteredFeaturePieces.JunglePyramid.class.getName(), Location.JUNGLE_PUZZLE);
        locationsByObject.put(ComponentScatteredFeaturePieces.DesertPyramid.class.getName(), Location.PYRAMID);
        locationsByObject.put(StructureVillagePieces.House2.class.getName(), Location.VILLAGE);
        locationsByID.put("netherFortress", netherFortress);
    }

    private static enum ReferenceType {
        FIELD,
        TABLE;


        private WeightedRandomChestContent[] getData(Class c, String name) throws Exception {
            switch (this) {
                case FIELD: {
                    Field f = c.getDeclaredField(name);
                    f.setAccessible(true);
                    return (WeightedRandomChestContent[])f.get(null);
                }
                case TABLE: {
                    return ChestGenHooks.getItems((String)name, (Random)DragonAPICore.rand);
                }
            }
            return null;
        }

        private void setData(Class c, String name, WeightedRandomChestContent[] items) throws Exception {
            switch (this) {
                case FIELD: {
                    Field f = c.getDeclaredField(name);
                    f.setAccessible(true);
                    f.set(null, items);
                    break;
                }
                case TABLE: {
                    LootController.setCGHItems(name, items);
                }
            }
        }
    }

    public static enum ModdedStructures implements ChestGenLootLocation
    {
        THAUMTOWER(ModList.THAUMCRAFT, "thaumcraft.common.lib.world.ComponentWizardTower", "towerChestContents", ReferenceType.FIELD),
        APIARIST(ModList.FORESTRY, "forestry.apiculture.worldgen.ComponentVillageBeeHouse", "naturalistChest", ReferenceType.TABLE),
        TINKERVILLAGE(ModList.TINKERER, "tconstruct.world.village.ComponentToolWorkshop", "TinkerHouse", ReferenceType.TABLE),
        APOTHECARY(ModList.WITCHERY, "com.emoniph.witchery.worldgen.ComponentVillageApothecary", "villageApothecaryChestContents", ReferenceType.FIELD),
        BOOKSHOP(ModList.WITCHERY, "com.emoniph.witchery.worldgen.ComponentVillageBookShop", "bookshopChestContents", ReferenceType.FIELD),
        WKEEP(ModList.WITCHERY, "com.emoniph.witchery.worldgen.ComponentVillageKeep", "villageTowerChestContents", ReferenceType.FIELD),
        PHOTOSHOP(new BasicModEntry("WitchingGadgets"), "witchinggadgets.common.world.VillageComponentPhotoshop", "WG:PHOTOWORKSHOP", ReferenceType.TABLE),
        LIBRARY(ModList.MYSTCRAFT, "com.xcompwiz.mystcraft.world.gen.structure.ComponentScatteredFeatureSmallLibrary", "mystcraftTreasure", ReferenceType.TABLE);

        private final ModEntry sourceMod;
        private final ReferenceType dataType;
        private final String className;
        private final String tableID;
        private final Class reference;

        private ModdedStructures(ModEntry mod, String partName, String lootTable, ReferenceType type) {
            this.sourceMod = mod;
            this.dataType = type;
            this.className = partName;
            this.tableID = lootTable;
            if (mod.isLoaded()) {
                locationsByID.put(this.getTag(), this);
                locationsByObject.put(partName, this);
                Class<?> c = null;
                try {
                    c = Class.forName(this.className);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    ReflectiveFailureTracker.instance.logModReflectiveFailure(mod, e);
                }
                this.reference = c;
            } else {
                this.reference = null;
            }
        }

        public boolean exists() {
            return this.sourceMod.isLoaded();
        }

        public boolean isInCGHTable() {
            return this.dataType == ReferenceType.TABLE;
        }

        @Override
        public String getTag() {
            switch (this.dataType) {
                case TABLE: {
                    return this.tableID;
                }
            }
            return ReikaStringParser.capFirstChar(this.name());
        }

        @Override
        public WeightedRandomChestContent[] getContents() throws Exception {
            if (!this.exists()) {
                throw new IllegalStateException("Mod '" + this.sourceMod.getDisplayName() + "' is not loaded!");
            }
            return this.dataType.getData(this.reference, this.tableID);
        }

        @Override
        public void setContents(WeightedRandomChestContent[] items) throws Exception {
            if (!this.exists()) {
                throw new IllegalStateException("Mod '" + this.sourceMod.getDisplayName() + "' is not loaded!");
            }
            this.dataType.setData(this.reference, this.tableID, items);
        }
    }

    public static enum Location implements ChestGenLootLocation
    {
        BONUS("bonusChest"),
        VILLAGE("villageBlacksmith"),
        DUNGEON("dungeonChest"),
        MINESHAFT("mineshaftCorridor"),
        STRONGHOLD_LIBRARY("strongholdLibrary"),
        STRONGHOLD_CROSSING("strongholdCrossing"),
        STRONGHOLD_HALLWAY("strongholdCorridor"),
        PYRAMID("pyramidDesertyChest"),
        JUNGLE_DISPENSER("pyramidJungleDispenser"),
        JUNGLE_PUZZLE("pyramidJungleChest");

        public final String tag;

        private Location(String sg) {
            this.tag = sg;
            locationsByID.put(this.tag, this);
        }

        @Override
        public String getTag() {
            return this.tag;
        }

        @Override
        public WeightedRandomChestContent[] getContents() throws Exception {
            return ChestGenHooks.getItems((String)this.tag, (Random)DragonAPICore.rand);
        }

        @Override
        public void setContents(WeightedRandomChestContent[] items) throws Exception {
            LootController.setCGHItems(this.tag, items);
        }
    }

    public static interface ChestGenLootLocation {
        public String getTag();

        public WeightedRandomChestContent[] getContents() throws Exception;

        public void setContents(WeightedRandomChestContent[] var1) throws Exception;
    }

    class LootStack {
        public final int lootTier;
        public final Location chestLocation;
        private final ItemStack item;
        public final int minSize;
        public final int maxSize;
        public final int weight;

        public LootStack(int tier, Location loc, ItemStack is, int min, int max, int chance) {
            this.lootTier = tier;
            this.chestLocation = loc;
            this.item = is;
            this.minSize = min;
            this.maxSize = max;
            this.weight = chance;
        }

        public ItemStack getItemStack() {
            return this.item.func_77946_l();
        }

        public boolean equals(Object o) {
            if (o instanceof LootStack) {
                LootStack ls = (LootStack)o;
                return ls.chestLocation == this.chestLocation && ReikaItemHelper.matchStacks(this.item, ls.item);
            }
            return false;
        }

        public String toString() {
            if (this.maxSize == this.minSize) {
                return this.item.func_82833_r() + " with size " + this.minSize;
            }
            return this.item.func_82833_r() + " with size " + this.minSize + "-" + this.maxSize;
        }
    }
}

