/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Worldgen;

import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Libraries.Registry.ReikaTreeHelper;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class ModifiableBigTree
extends WorldGenAbstractTree {
    private static final byte[] otherCoordPairs = new byte[]{2, 0, 0, 1, 2, 1};
    protected static final double BASE_ATTENUATION = 0.618;
    protected static final double BASE_SLOPE = 0.381;
    protected final Random rand = new Random();
    protected double heightAttenuation = 0.618;
    protected double branchSlope = 0.381;
    protected double branchDensity = 1.0;
    protected double scaleWidth = 1.0;
    protected double leafDensity = 1.0;
    private int heightLimit;
    private int height;
    private int[][] leafNodes;
    private int[] basePos = new int[]{0, 0, 0};
    protected int[] globalOffset = new int[]{0, 0, 0};
    protected int trunkSize = 1;
    protected int heightLimitLimit = 12;
    protected int leafDistanceLimit = 4;
    protected int minHeight = 5;
    protected int trunkBottom = 256;
    protected int trunkTop = -1;
    protected int topLeaf = -1;
    protected int bottomLeaf = 256;
    private final AxisAlignedBB boundingBox = AxisAlignedBB.func_72330_a((double)Double.POSITIVE_INFINITY, (double)Double.POSITIVE_INFINITY, (double)Double.POSITIVE_INFINITY, (double)Double.NEGATIVE_INFINITY, (double)Double.NEGATIVE_INFINITY, (double)Double.NEGATIVE_INFINITY);
    protected final boolean doUpdates;

    public ModifiableBigTree(boolean updates) {
        super(updates);
        this.doUpdates = updates;
    }

    private void generateLeafNodeList(World world) {
        int i;
        this.height = (int)((double)this.heightLimit * this.heightAttenuation);
        if (this.height >= this.heightLimit) {
            this.height = this.heightLimit - 1;
        }
        if ((i = (int)((1.382 + Math.pow(this.leafDensity * (double)this.heightLimit / 13.0, 2.0)) * this.branchDensity)) < 1) {
            i = 1;
        }
        int[][] aint = new int[i * this.heightLimit][4];
        int ry = this.basePos[1] + this.heightLimit - this.leafDistanceLimit;
        int k = 1;
        int l = this.basePos[1] + this.height;
        int yh = ry - this.basePos[1];
        aint[0][0] = this.basePos[0];
        aint[0][1] = ry--;
        aint[0][2] = this.basePos[2];
        aint[0][3] = l;
        while (yh >= 0) {
            float f = this.layerSize(yh);
            if (f < 0.0f) {
                --ry;
                --yh;
                continue;
            }
            double d0 = 0.5;
            for (int j1 = 0; j1 < i; ++j1) {
                int[] pos2;
                int rz;
                double d2;
                double d1 = this.scaleWidth * (double)f * ((double)this.rand.nextFloat() + 0.328);
                int rx = MathHelper.func_76128_c((double)(d1 * Math.sin(d2 = (double)this.rand.nextFloat() * 2.0 * Math.PI) + (double)this.basePos[0] + d0));
                int[] pos1 = new int[]{rx, ry, rz = MathHelper.func_76128_c((double)(d1 * Math.cos(d2) + (double)this.basePos[2] + d0))};
                if (this.checkBlockLine(world, pos1, pos2 = new int[]{rx, ry + this.leafDistanceLimit, rz}) != -1) continue;
                int[] aint3 = new int[]{this.basePos[0], this.basePos[1], this.basePos[2]};
                double d3 = Math.sqrt(Math.pow(Math.abs(this.basePos[0] - pos1[0]), 2.0) + Math.pow(Math.abs(this.basePos[2] - pos1[2]), 2.0));
                double d4 = d3 * this.branchSlope;
                aint3[1] = (double)pos1[1] - d4 > (double)l ? l : (int)((double)pos1[1] - d4);
                if (this.checkBlockLine(world, aint3, pos1) != -1) continue;
                aint[k][0] = rx;
                aint[k][1] = ry;
                aint[k][2] = rz;
                aint[k][3] = aint3[1];
                ++k;
            }
            --ry;
            --yh;
        }
        this.leafNodes = new int[k][4];
        System.arraycopy(aint, 0, this.leafNodes, 0, k);
    }

    private void placeLeafNode(World world, int x, int y, int z, float size, byte p_150529_5_) {
        int l = (int)((double)size + 0.618);
        byte b1 = otherCoordPairs[p_150529_5_];
        byte b2 = otherCoordPairs[p_150529_5_ + 3];
        int[] pos1 = new int[]{x, y, z};
        int[] pos2 = new int[]{0, 0, 0};
        int j1 = -l;
        pos2[p_150529_5_] = pos1[p_150529_5_];
        for (int i1 = -l; i1 <= l; ++i1) {
            pos2[b1] = pos1[b1] + i1;
            j1 = -l;
            while (j1 <= l) {
                double d0 = Math.pow((double)Math.abs(i1) + 0.5, 2.0) + Math.pow((double)Math.abs(j1) + 0.5, 2.0);
                if (d0 > (double)(size * size)) {
                    ++j1;
                    continue;
                }
                pos2[b2] = pos1[b2] + j1;
                Block block1 = world.func_147439_a(pos2[0], pos2[1], pos2[2]);
                if (!block1.isAir((IBlockAccess)world, pos2[0], pos2[1], pos2[2]) && !block1.isLeaves((IBlockAccess)world, pos2[0], pos2[1], pos2[2])) {
                    ++j1;
                    continue;
                }
                BlockKey leaf = this.getLeafBlock(pos2[0], pos2[1], pos2[2]);
                this.func_150516_a(world, pos2[0], pos2[1], pos2[2], leaf.blockID, leaf.metadata);
                this.addCoord(pos2);
                int dy = pos2[1] + this.globalOffset[1];
                this.topLeaf = Math.max(dy, this.topLeaf);
                this.bottomLeaf = Math.min(dy, this.bottomLeaf);
                ++j1;
            }
        }
    }

    private void addCoord(int[] pos) {
        int x = pos[0] + this.globalOffset[0];
        int y = pos[1] + this.globalOffset[1];
        int z = pos[2] + this.globalOffset[2];
        this.boundingBox.field_72340_a = Math.min(this.boundingBox.field_72340_a, (double)x);
        this.boundingBox.field_72336_d = Math.min(this.boundingBox.field_72336_d, (double)x);
        this.boundingBox.field_72338_b = Math.min(this.boundingBox.field_72338_b, (double)y);
        this.boundingBox.field_72337_e = Math.min(this.boundingBox.field_72337_e, (double)y);
        this.boundingBox.field_72339_c = Math.min(this.boundingBox.field_72338_b, (double)z);
        this.boundingBox.field_72334_f = Math.min(this.boundingBox.field_72337_e, (double)z);
    }

    protected final AxisAlignedBB getBoundingBox() {
        return ReikaAABBHelper.copyAABB(this.boundingBox);
    }

    protected final double getHeightFraction(int y) {
        return ((double)y - this.boundingBox.field_72338_b) / (this.boundingBox.field_72337_e - this.boundingBox.field_72338_b);
    }

    protected BlockKey getLogBlock(int x, int y, int z) {
        return new BlockKey(ReikaTreeHelper.OAK.getLogID(), ReikaTreeHelper.OAK.getBaseLogMeta());
    }

    protected BlockKey getLeafBlock(int x, int y, int z) {
        return new BlockKey(ReikaTreeHelper.OAK.getLeafID(), ReikaTreeHelper.OAK.getBaseLeafMeta());
    }

    protected float layerSize(int layer) {
        if ((double)layer < (double)this.heightLimit * 0.3) {
            return -1.618f;
        }
        float f = (float)this.heightLimit / 2.0f;
        float f1 = (float)this.heightLimit / 2.0f - (float)layer;
        float f2 = f1 == 0.0f ? f : (Math.abs(f1) >= f ? 0.0f : (float)Math.sqrt(Math.pow(Math.abs(f), 2.0) - Math.pow(Math.abs(f1), 2.0)));
        return f2 *= 0.5f;
    }

    protected float leafSize(int r) {
        return r >= 0 && r < this.leafDistanceLimit ? (r != 0 && r != this.leafDistanceLimit - 1 ? 3.0f : 2.0f) : -1.0f;
    }

    private void generateLeafNode(World world, int x, int y, int z) {
        int i1 = y + this.leafDistanceLimit;
        for (int l = y; l < i1; ++l) {
            float f = this.leafSize(l - y);
            this.placeLeafNode(world, x, l, z, f, (byte)1);
        }
    }

    private void generateTrunkColumn(World world, int[] root, int[] top) {
        int[] pos = new int[]{0, 0, 0};
        int mainAxis = 0;
        for (int axis = 0; axis < 3; axis = (int)((byte)(axis + 1))) {
            pos[axis] = top[axis] - root[axis];
            if (Math.abs(pos[axis]) <= Math.abs(pos[mainAxis])) continue;
            mainAxis = axis;
        }
        if (pos[mainAxis] != 0) {
            byte b2 = otherCoordPairs[mainAxis];
            byte b3 = otherCoordPairs[mainAxis + 3];
            int b4 = pos[mainAxis] > 0 ? 1 : -1;
            double d0 = (double)pos[b2] / (double)pos[mainAxis];
            double d1 = (double)pos[b3] / (double)pos[mainAxis];
            int[] pos3 = new int[]{0, 0, 0};
            int j = pos[mainAxis] + b4;
            for (int i = 0; i != j; i += b4) {
                int l;
                pos3[mainAxis] = MathHelper.func_76128_c((double)((double)(root[mainAxis] + i) + 0.5));
                pos3[b2] = MathHelper.func_76128_c((double)((double)root[b2] + (double)i * d0 + 0.5));
                pos3[b3] = MathHelper.func_76128_c((double)((double)root[b3] + (double)i * d1 + 0.5));
                BlockKey log = this.getLogBlock(pos3[0], pos3[1], pos3[2]);
                byte b5 = (byte)log.metadata;
                int k = Math.abs(pos3[0] - root[0]);
                int i1 = Math.max(k, l = Math.abs(pos3[2] - root[2]));
                if (i1 > 0) {
                    if (k == i1) {
                        b5 = (byte)(b5 + 4);
                    } else if (l == i1) {
                        b5 = (byte)(b5 + 8);
                    }
                }
                this.func_150516_a(world, pos3[0], pos3[1], pos3[2], log.blockID, b5);
                this.addCoord(pos3);
                int y = pos3[1] + this.globalOffset[1];
                this.trunkTop = Math.max(y, this.trunkTop);
                this.trunkBottom = Math.min(y, this.trunkBottom);
            }
        }
    }

    private void generateLeaves(World world) {
        int j = this.leafNodes.length;
        for (int i = 0; i < j; ++i) {
            int k = this.leafNodes[i][0];
            int l = this.leafNodes[i][1];
            int i1 = this.leafNodes[i][2];
            this.generateLeafNode(world, k, l, i1);
        }
    }

    private boolean leafNodeNeedsBase(int d) {
        return (double)d >= (double)this.heightLimit * 0.2;
    }

    private void generateTrunk(World world) {
        int x = this.basePos[0];
        int y0 = this.basePos[1];
        int y1 = this.basePos[1] + this.height;
        int z = this.basePos[2];
        int[] root = new int[]{x, y0, z};
        int[] top = new int[]{x, y1, z};
        this.generateTrunkColumn(world, root, top);
        switch (this.trunkSize) {
            case 2: {
                root[0] = root[0] + 1;
                top[0] = top[0] + 1;
                this.generateTrunkColumn(world, root, top);
                root[2] = root[2] + 1;
                top[2] = top[2] + 1;
                this.generateTrunkColumn(world, root, top);
                root[0] = root[0] + -1;
                top[0] = top[0] + -1;
                this.generateTrunkColumn(world, root, top);
                break;
            }
            case 3: {
                for (int i = -1; i <= 1; ++i) {
                    for (int k = -1; k <= 1; ++k) {
                        if (i == 0 && k == 0 || i != 0 && k != 0) continue;
                        root[0] = x + i;
                        root[2] = z + k;
                        top[0] = x + i;
                        top[2] = z + k;
                        this.generateTrunkColumn(world, root, top);
                    }
                }
                break;
            }
        }
    }

    private void generateLeafNodeBases(World world) {
        int j = this.leafNodes.length;
        int[] aint = new int[]{this.basePos[0], this.basePos[1], this.basePos[2]};
        for (int i = 0; i < j; ++i) {
            int[] aint1 = this.leafNodes[i];
            int[] aint2 = new int[]{aint1[0], aint1[1], aint1[2]};
            aint[1] = aint1[3];
            int k = aint[1] - this.basePos[1];
            if (!this.leafNodeNeedsBase(k)) continue;
            this.generateTrunkColumn(world, aint, aint2);
        }
    }

    private int checkBlockLine(World world, int[] c1, int[] c2) {
        int i;
        int[] aint2 = new int[]{0, 0, 0};
        int b1 = 0;
        for (int b0 = 0; b0 < 3; b0 = (int)((byte)(b0 + 1))) {
            aint2[b0] = c2[b0] - c1[b0];
            if (Math.abs(aint2[b0]) <= Math.abs(aint2[b1])) continue;
            b1 = b0;
        }
        if (aint2[b1] == 0) {
            return -1;
        }
        byte b2 = otherCoordPairs[b1];
        byte b3 = otherCoordPairs[b1 + 3];
        int b4 = aint2[b1] > 0 ? 1 : -1;
        double d0 = (double)aint2[b2] / (double)aint2[b1];
        double d1 = (double)aint2[b3] / (double)aint2[b1];
        int[] aint3 = new int[]{0, 0, 0};
        int j = aint2[b1] + b4;
        for (i = 0; i != j; i += b4) {
            aint3[b1] = c1[b1] + i;
            aint3[b2] = MathHelper.func_76128_c((double)((double)c1[b2] + (double)i * d0));
            aint3[b3] = MathHelper.func_76128_c((double)((double)c1[b3] + (double)i * d1));
            Block block = world.func_147439_a(aint3[0], aint3[1], aint3[2]);
            if (!this.isReplaceable(world, aint3[0], aint3[1], aint3[2])) break;
        }
        return i == j ? -1 : Math.abs(i);
    }

    private boolean validTreeLocation(World world) {
        return this.isValidLocation(world, this.basePos[0], this.basePos[1], this.basePos[2]);
    }

    protected boolean isValidLocation(World world, int x, int y, int z) {
        int[] aint = new int[]{x, y, z};
        int[] aint1 = new int[]{x, y + this.heightLimit - 1, z};
        boolean isSoil = this.isValidUnderBlock(world, x, y - 1, z);
        if (!isSoil) {
            return false;
        }
        int i = this.checkBlockLine(world, aint, aint1);
        if (i == -1) {
            return true;
        }
        if (i < 6) {
            return false;
        }
        this.heightLimit = i;
        return true;
    }

    protected boolean isValidUnderBlock(World world, int x, int y, int z) {
        return world.func_147439_a(x, y, z).canSustainPlant((IBlockAccess)world, x, y, z, ForgeDirection.UP, (IPlantable)((BlockSapling)Blocks.field_150345_g));
    }

    protected boolean func_150523_a(Block b) {
        Material m = b.func_149688_o();
        return m == Material.field_151579_a || m == Material.field_151584_j || b == Blocks.field_150349_c || b == Blocks.field_150346_d || this.isMatchingLog(b) || this.isMatchingSapling(b) || b == Blocks.field_150395_bd;
    }

    protected boolean isMatchingLog(Block b) {
        return b == Blocks.field_150364_r;
    }

    protected boolean isMatchingSapling(Block b) {
        return b == Blocks.field_150362_t;
    }

    public void func_76487_a(double h, double w, double d) {
        this.heightLimitLimit = (int)(h * 12.0);
        if (h > 0.5) {
            this.leafDistanceLimit = 5;
        }
        this.scaleWidth = w;
        this.leafDensity = d;
    }

    public boolean func_76484_a(World world, Random r, int x, int y, int z) {
        long l = r.nextLong();
        this.rand.setSeed(l);
        this.basePos[0] = x;
        this.basePos[1] = y;
        this.basePos[2] = z;
        if (this.heightLimit == 0) {
            this.heightLimit = this.minHeight + this.rand.nextInt(this.heightLimitLimit - this.minHeight + 5);
        }
        if (!this.validTreeLocation(world)) {
            return false;
        }
        this.generateLeafNodeList(world);
        this.generateLeaves(world);
        this.generateTrunk(world);
        this.generateLeafNodeBases(world);
        return true;
    }

    protected void func_150516_a(World world, int x, int y, int z, Block b, int meta) {
        world.func_147465_d(x + this.globalOffset[0], y + this.globalOffset[1], z + this.globalOffset[2], b, meta, this.doUpdates ? 3 : 2);
    }

    protected final void resetHeight() {
        this.heightLimit = 0;
    }
}

