/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Worldgen;

import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Event.ChunkGenerationEvent;
import Reika.DragonAPI.Instantiable.Worldgen.ChunkSplicedGenerator;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.ChunkEvent;

public class SpillingGenerationDelegationSystem
extends ChunkSplicedGenerator {
    private int currentChunkX;
    private int currentChunkZ;

    public SpillingGenerationDelegationSystem() {
        super(true);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onChunkGenerated(ChunkGenerationEvent evt) {
        this.placeChunk(evt.world, evt.getChunk().func_76632_l());
    }

    @SubscribeEvent
    public void onChunkLoaded(ChunkEvent.Load evt) {
        this.placeChunk(evt.world, evt.getChunk().func_76632_l());
    }

    public boolean setBlock(WorldServer world, int x, int y, int z, Block b) {
        return this.setBlock(world, x, y, z, b, 0);
    }

    public boolean setBlock(WorldServer world, int x, int y, int z, Block b, int meta) {
        return this.setBlock(world, x, y, z, b, meta, 3);
    }

    public boolean setBlock(WorldServer world, int x, int y, int z, Block b, int meta, int flags) {
        if (x >> 4 == this.currentChunkX && z >> 4 == this.currentChunkZ || ReikaWorldHelper.isChunkGenerated(world, x, z)) {
            world.func_147465_d(x, y, z, b, meta, flags);
            return true;
        }
        this.setBlock(x, y, z, b, meta);
        return false;
    }

    @Override
    protected void place(int x, int y, int z, ChunkSplicedGenerator.BlockPlace sb) {
        this.put(SpillingGenerationDelegationSystem.getKey(x, z), new Coordinate(x, y, z), sb);
    }

    public void placeChunk(World world, int cx, int cz) {
        this.placeChunk(world, new ChunkCoordIntPair(cx, cz));
    }

    public void placeChunkBlockCoords(World world, int x, int z) {
        this.placeChunk(world, x >> 4, z >> 4);
    }

    public final void placeChunk(World world, ChunkCoordIntPair cp) {
        this.generate(world, cp);
    }

    public void setCurrent(int cx, int cz) {
        this.currentChunkX = cx;
        this.currentChunkZ = cz;
    }

    public void setCurrentBlockCoords(int x, int z) {
        this.setCurrent(x >> 4, z >> 4);
    }

    public void readFromNBT(NBTTagCompound NBT) {
        this.data.clear();
        NBTTagList li = NBT.func_150295_c("blocks", ReikaNBTHelper.NBTTypes.COMPOUND.ID);
        for (Object o : li.field_74747_a) {
            NBTTagCompound tag = (NBTTagCompound)o;
            Coordinate c = Coordinate.readFromNBT("location", tag);
            ChunkCoordIntPair key = SpillingGenerationDelegationSystem.getKey(c.xCoord, c.zCoord);
            ChunkSplicedGenerator.BlockPlace bp = ChunkSplicedGenerator.BlockPlace.readFromTag(tag.func_74775_l("block"));
            this.put(key, c, bp);
        }
    }

    public void writeToNBT(NBTTagCompound NBT) {
        NBTTagList li = new NBTTagList();
        for (Map set : this.data.values()) {
            for (Map.Entry e : set.entrySet()) {
                NBTTagCompound tag = new NBTTagCompound();
                ((Coordinate)e.getKey()).writeToNBT("location", tag);
                tag.func_74782_a("block", (NBTBase)((ChunkSplicedGenerator.BlockPlace)e.getValue()).writeToNBT());
                li.func_74742_a((NBTBase)tag);
            }
        }
        NBT.func_74782_a("blocks", (NBTBase)li);
    }
}

