/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Libraries.Java;

import Reika.DragonAPI.ASM.Patchers.Patcher;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Exception.ASMException;
import Reika.DragonAPI.IO.ReikaFileReader;
import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import Reika.DragonAPI.Interfaces.LegacyPatcher;
import Reika.DragonAPI.Libraries.Java.ReikaArrayHelper;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import com.google.common.base.Charsets;
import cpw.mods.fml.relauncher.FMLInjectionData;
import cpw.mods.fml.relauncher.FMLLaunchHandler;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.classloading.FMLForgePlugin;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.IincInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeAnnotationNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.objectweb.asm.util.Printer;
import org.objectweb.asm.util.Textifier;
import org.objectweb.asm.util.TraceMethodVisitor;

public class ReikaASMHelper {
    private static Field opcodeField;
    private static final Logger logger;
    public static String activeMod;
    public static final int forgeVersion_Major;
    public static final int forgeVersion_Minor;
    public static final int forgeVersion_Revision;
    public static final int forgeVersion_Build;
    public static final String REIKA_SRGS = "C:/Users/Reika/.gradle/caches/minecraft/net/minecraftforge/forge/1.7.10-10.13.4.1614-1.7.10/reika/custom/srgs/";
    private static final HashMap<String, String> srgMap;
    private static final HashMap<String, Integer> opcodeNames;

    public static void log(Object o) {
        ReikaASMHelper.write(activeMod + ": " + o, false);
    }

    public static void logError(Object o) {
        ReikaASMHelper.write(activeMod + " ERROR: " + o, true);
    }

    private static void write(String s, boolean err) {
        if (activeMod == null) {
            logger.log(Level.ERROR, "Called output without active mod!");
        }
        logger.log(err ? Level.ERROR : Level.INFO, s);
    }

    public static void changeFieldType(ClassNode c, String obf, String deobf, String newType) throws ASMException.NoSuchASMFieldException {
        FieldNode f = ReikaASMHelper.getFieldByName(c, obf, deobf);
        f.desc = newType;
        for (MethodNode m : c.methods) {
            for (int i = 0; i < m.instructions.size(); ++i) {
                AbstractInsnNode ain = m.instructions.get(i);
                if (!(ain instanceof FieldInsnNode)) continue;
                FieldInsnNode fin = (FieldInsnNode)ain;
                if (!fin.name.equals(f.name)) continue;
                fin.desc = f.desc;
            }
        }
    }

    public static void changeMethodReturnType(ClassNode c, String obf, String deobf, String newType) throws ASMException.NoSuchASMMethodException {
    }

    public static FieldNode getFieldByName(ClassNode c, String name) throws ASMException.NoSuchASMFieldException {
        return ReikaASMHelper.getFieldByName(c, name, name);
    }

    public static FieldNode getFieldByName(ClassNode c, String obf, String deobf) throws ASMException.NoSuchASMFieldException {
        String s = FMLForgePlugin.RUNTIME_DEOBF ? obf : deobf;
        List fields = c.fields;
        for (int k = 0; k < fields.size(); ++k) {
            FieldNode f = (FieldNode)fields.get(k);
            if (!f.name.equals(s)) continue;
            return f;
        }
        throw new ASMException.NoSuchASMFieldException(c, s);
    }

    public static MethodNode getMethodByName(ClassNode c, String name, String sig) throws ASMException.NoSuchASMMethodException {
        return ReikaASMHelper.getMethodByName(c, name, name, sig);
    }

    public static MethodNode getMethodByName(ClassNode c, String obf, String deobf, String sig) throws ASMException.NoSuchASMMethodException {
        String s;
        String string = s = FMLForgePlugin.RUNTIME_DEOBF ? obf : deobf;
        if (sig.equals("*")) {
            List methods = c.methods;
            for (int k = 0; k < methods.size(); ++k) {
                MethodNode m = (MethodNode)methods.get(k);
                if (!m.name.equals(s)) continue;
                return m;
            }
            throw new ASMException.NoSuchASMMethodException(c, s, "[Any]");
        }
        MethodNode mn = ReikaASMHelper.getMethodByNameAndSig(c, s, sig);
        if (mn == null) {
            throw new ASMException.NoSuchASMMethodException(c, s, sig);
        }
        return mn;
    }

    public static boolean classContainsMethod(ClassNode cn, String name, String desc) {
        return ReikaASMHelper.getMethodByNameAndSig(cn, name, desc) != null;
    }

    public static boolean classContainsMethod(ClassNode cn, MethodNode mn) {
        return ReikaASMHelper.classContainsMethod(cn, mn.name, mn.desc);
    }

    public static boolean classContainsMethod(Class c, MethodNode mn) {
        ArrayList<String> li = ReikaASMHelper.parseMethodSignature(mn);
        ArrayList<Class> args = new ArrayList<Class>();
        for (String s : li) {
            args.add(ReikaASMHelper.parseClass(s));
        }
        Class ret = (Class)args.remove(args.size() - 1);
        Object[] params = args.toArray(new Class[args.size()]);
        Method[] calls = c.getDeclaredMethods();
        for (int i = 0; i < calls.length; ++i) {
            Method m = calls[i];
            if (m.getReturnType() != ret || !Arrays.equals(m.getParameterTypes(), params)) continue;
            return true;
        }
        return false;
    }

    public static Class parseClass(String s) {
        if (s.charAt(0) == '[') {
            Class c = ReikaASMHelper.parseClass(s.substring(1));
            return Array.newInstance(c, 0).getClass();
        }
        if (s.length() == 1) {
            return PrimitiveType.getFromSig((String)s).classType;
        }
        if (s.charAt(0) == 'L') {
            s = s.substring(1);
        }
        if (s.charAt(s.length() - 1) == ';') {
            s = s.substring(0, s.length() - 1);
        }
        s = s.replaceAll("/", ".");
        try {
            return Class.forName(s);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private static MethodNode getMethodByNameAndSig(ClassNode c, String name, String sig) {
        List methods = c.methods;
        for (int k = 0; k < methods.size(); ++k) {
            MethodNode m = (MethodNode)methods.get(k);
            if (!m.name.equals(name) || !m.desc.equals(sig)) continue;
            return m;
        }
        return null;
    }

    public static void removeCodeLine(MethodNode m, int line) {
        int i;
        ArrayList<AbstractInsnNode> toRemove = new ArrayList<AbstractInsnNode>();
        for (i = 0; i < m.instructions.size(); ++i) {
            AbstractInsnNode ain = m.instructions.get(i);
            if (!(ain instanceof LineNumberNode) || ((LineNumberNode)ain).line != line) continue;
            toRemove.add(ain.getPrevious());
            while (!(ain.getNext() instanceof LineNumberNode)) {
                toRemove.add(ain);
                ain = ain.getNext();
            }
        }
        for (i = 0; i < toRemove.size(); ++i) {
            AbstractInsnNode insn = (AbstractInsnNode)toRemove.get(i);
            m.instructions.remove(insn);
        }
    }

    public static boolean isMethodCall(AbstractInsnNode ain, String obf, String deobf) {
        if (ain instanceof MethodInsnNode) {
            MethodInsnNode min = (MethodInsnNode)ain;
            String s = FMLForgePlugin.RUNTIME_DEOBF ? obf : deobf;
            return min.name.equals(s);
        }
        return false;
    }

    public static boolean isReturn(AbstractInsnNode ain) {
        if (ain instanceof InsnNode) {
            int code = ain.getOpcode();
            return code == 177 || code == 172 || code == 173 || code == 174 || code == 175 || code == 176;
        }
        return false;
    }

    public static void insertNAfter(MethodNode m, AbstractInsnNode root, AbstractInsnNode arg, int n) {
        for (int i = 0; i < n; ++i) {
            root = root.getNext();
        }
        m.instructions.insert(root, arg);
    }

    public static void insertNAfter(MethodNode m, AbstractInsnNode root, InsnList arg, int n) {
        for (int i = 0; i < n; ++i) {
            root = root.getNext();
        }
        m.instructions.insert(root, arg);
    }

    public static ArrayList<String> parseMethodArguments(MethodNode mn) {
        ArrayList<String> li = ReikaASMHelper.parseMethodDesc(mn.desc);
        return li;
    }

    private static ArrayList<String> parseMethodDesc(String desc) {
        String s = desc.substring(desc.indexOf(40) + 1, desc.lastIndexOf(41));
        ArrayList<String> li = new ArrayList<String>();
        ReikaASMHelper.parseArguments(li, s);
        return li;
    }

    public static String convertLPrefixToPlain(String arg) {
        if (arg.startsWith("L")) {
            int semi = arg.indexOf(59);
            arg = arg.substring(1, semi);
        }
        return arg;
    }

    private static void parseArguments(ArrayList<String> args, String desc) {
        if (desc.startsWith("L")) {
            int semi = desc.indexOf(59);
            String arg = desc.substring(0, semi + 1);
            args.add(arg);
            ReikaASMHelper.parseArguments(args, desc.substring(arg.length()));
        } else if (!desc.isEmpty()) {
            String prim = desc.substring(0, 1);
            args.add(prim);
            ReikaASMHelper.parseArguments(args, desc.substring(1));
        }
    }

    public static boolean memberHasAnnotationOfType(ClassNode cn, String type) {
        return ReikaASMHelper.hasAnnotation(cn.visibleAnnotations, type);
    }

    public static boolean memberHasAnnotationOfType(MethodNode mn, String type) {
        return ReikaASMHelper.hasAnnotation(mn.visibleAnnotations, type);
    }

    public static boolean memberHasAnnotationOfType(FieldNode fn, String type) {
        return ReikaASMHelper.hasAnnotation(fn.visibleAnnotations, type);
    }

    private static boolean hasAnnotation(List<AnnotationNode> li, String type) {
        if (li == null || li.isEmpty()) {
            return false;
        }
        for (AnnotationNode ann : li) {
            if (!ann.desc.startsWith(type)) continue;
            return true;
        }
        return false;
    }

    public static void clearMethodBody(MethodNode m) {
        m.instructions.clear();
        ArrayList<String> li = ReikaASMHelper.parseMethodSignature(m);
        PrimitiveType type = PrimitiveType.getFromSig(li.get(li.size() - 1));
        InsnNode retcall = null;
        InsnNode retobj = null;
        switch (type) {
            case LONG: {
                retcall = new InsnNode(173);
                retobj = new InsnNode(9);
                break;
            }
            case DOUBLE: {
                retcall = new InsnNode(175);
                retobj = new InsnNode(14);
                break;
            }
            case FLOAT: {
                retcall = new InsnNode(174);
                retobj = new InsnNode(11);
                break;
            }
            case INT: 
            case BYTE: 
            case SHORT: 
            case BOOLEAN: {
                retcall = new InsnNode(172);
                retobj = new InsnNode(3);
                break;
            }
            case FLOATARRAY: 
            case INTARRAY: 
            case BOOLARRAY: 
            case SHORTARRAY: 
            case DOUBARRAY: 
            case BYTEARRAY: 
            case OBJECT: {
                retcall = new InsnNode(176);
                retobj = new InsnNode(1);
                break;
            }
            case VOID: {
                retcall = new InsnNode(177);
            }
        }
        if (retobj != null) {
            m.instructions.add(retobj);
        }
        if (retcall != null) {
            m.instructions.add((AbstractInsnNode)retcall);
        }
        if (m.attrs != null) {
            m.attrs.clear();
        }
    }

    public static String clearString(ClassNode cn) {
        StringBuilder sb = new StringBuilder();
        for (FieldNode f : cn.fields) {
            sb.append("==FIELD==\n");
            sb.append(f.name);
            sb.append(" ");
            sb.append(f.desc);
            sb.append("\n=======\n\n");
        }
        for (MethodNode m : cn.methods) {
            sb.append("==METHOD==\n");
            sb.append(m.name);
            sb.append(" ");
            sb.append(m.desc);
            sb.append("\n");
            sb.append(ReikaASMHelper.clearString(m.instructions));
            sb.append("\n=======\n\n");
        }
        return sb.toString();
    }

    public static String clearString(InsnList c) {
        return ReikaASMHelper.printInsnList(c.iterator());
    }

    public static String clearString(Collection<AbstractInsnNode> c) {
        return ReikaASMHelper.printInsnList(c.iterator());
    }

    private static String printInsnList(Iterator<AbstractInsnNode> it) {
        StringBuilder sb = new StringBuilder();
        sb.append("{\n");
        int i = 0;
        while (it.hasNext()) {
            AbstractInsnNode ain = it.next();
            sb.append(i);
            sb.append(": ");
            sb.append(ReikaASMHelper.clearString(ain));
            sb.append("");
            ++i;
        }
        sb.append("\n}");
        return sb.toString();
    }

    public static String clearString(AbstractInsnNode ain) {
        Textifier t = new Textifier();
        TraceMethodVisitor mv = new TraceMethodVisitor((Printer)t);
        ain.accept((MethodVisitor)mv);
        StringWriter sw = new StringWriter();
        t.print(new PrintWriter(sw));
        t.getText().clear();
        return sw.toString();
    }

    public static String clearString(MethodNode m) {
        return m.name + " " + m.desc + " [" + Integer.toBinaryString(m.access) + "]";
    }

    public static void changeOpcode(AbstractInsnNode ain, int opcode) {
        try {
            opcodeField.setInt(ain, opcode);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static AbstractInsnNode getFirstOpcode(InsnList li, int opcode) {
        int index = 0;
        AbstractInsnNode ain = li.get(0);
        while (ain.getOpcode() != opcode && index < li.size() - 1) {
            ain = li.get(++index);
        }
        return ain.getOpcode() == opcode ? ain : null;
    }

    public static AbstractInsnNode getNthOpcode(InsnList li, int opcode, int n) {
        int c = 0;
        for (int i = 0; i < li.size(); ++i) {
            AbstractInsnNode ain = li.get(i);
            if (ain.getOpcode() != opcode || ++c != n) continue;
            return ain;
        }
        return null;
    }

    public static AbstractInsnNode getNthOfOpcodes(InsnList li, int n, int ... opcodes) {
        int c = 0;
        for (int i = 0; i < li.size(); ++i) {
            AbstractInsnNode ain = li.get(i);
            if (!ReikaArrayHelper.contains(opcodes, ain.getOpcode()) || ++c != n) continue;
            return ain;
        }
        return null;
    }

    public static AbstractInsnNode getLastOpcode(InsnList li, int opcode) {
        AbstractInsnNode ret = null;
        for (int i = 0; i < li.size(); ++i) {
            AbstractInsnNode ain = li.get(i);
            if (ain.getOpcode() != opcode) continue;
            ret = ain;
        }
        return ret;
    }

    public static AbstractInsnNode getFirstInsnAfter(InsnList li, int index, int opcode, Object ... args) {
        AbstractInsnNode ain = li.get(index + 1);
        while (!ReikaASMHelper.match(ain, opcode, args) && index < li.size() - 1) {
            ain = li.get(++index);
        }
        return ReikaASMHelper.match(ain, opcode, args) ? ain : null;
    }

    public static AbstractInsnNode getNthInsn(int n, InsnList li, int opcode, Object ... args) {
        int count = 0;
        for (int i = 0; i < li.size(); ++i) {
            AbstractInsnNode ain = li.get(i);
            if (!ReikaASMHelper.match(ain, opcode, args) || ++count != n) continue;
            return ain;
        }
        return null;
    }

    public static AbstractInsnNode getNthInsn(int n, InsnList li, AbstractInsnNode compare) {
        int count = 0;
        for (int i = 0; i < li.size(); ++i) {
            AbstractInsnNode ain = li.get(i);
            if (!ReikaASMHelper.match(ain, compare) || ++count != n) continue;
            return ain;
        }
        return null;
    }

    public static AbstractInsnNode getLastInsn(InsnList li, int opcode, Object ... args) {
        return ReikaASMHelper.getLastInsnBefore(li, li.size() - 1, opcode, args);
    }

    public static AbstractInsnNode getLastInsnBefore(InsnList li, int index, int opcode, Object ... args) {
        AbstractInsnNode ain = li.get(index - 1);
        while (!ReikaASMHelper.match(ain, opcode, args) && index > 0) {
            ain = li.get(--index);
        }
        return ReikaASMHelper.match(ain, opcode, args) ? ain : null;
    }

    public static AbstractInsnNode getLastOpcodeBefore(InsnList li, int index, int opcode) {
        AbstractInsnNode ain = li.get(index - 1);
        while (ain.getOpcode() != opcode && index > 0) {
            ain = li.get(--index);
        }
        return ain.getOpcode() == opcode ? ain : null;
    }

    public static JumpInsnNode getFirstJumpFromLabel(InsnList li, int index, LabelNode jumpTo) {
        AbstractInsnNode ain = li.get(index);
        while (index < li.size()) {
            ain = li.get(index);
            if (ain instanceof JumpInsnNode && ((JumpInsnNode)ain).label == jumpTo) {
                return (JumpInsnNode)ain;
            }
            ++index;
        }
        return null;
    }

    public static AbstractInsnNode getLastJumpBefore(InsnList li, int index) {
        AbstractInsnNode ain = li.get(index - 1);
        while (!(ain instanceof JumpInsnNode) && index > 0) {
            ain = li.get(--index);
        }
        return ain instanceof JumpInsnNode ? ain : null;
    }

    public static FieldInsnNode getLastFieldRefBefore(InsnList li, int index, String name) {
        AbstractInsnNode ain = li.get(index - 1);
        while (!(ain instanceof FieldInsnNode && ((FieldInsnNode)ain).name.equals(name) || index <= 0)) {
            ain = li.get(--index);
        }
        return ain instanceof FieldInsnNode && ((FieldInsnNode)ain).name.equals(name) ? (FieldInsnNode)ain : null;
    }

    public static AbstractInsnNode getLastNonZeroALOADBefore(InsnList li, int index) {
        AbstractInsnNode ain = li.get(index - 1);
        while (!(ain instanceof VarInsnNode && ((VarInsnNode)ain).var != 0 || index <= 0)) {
            ain = li.get(--index);
        }
        return ain instanceof VarInsnNode && ((VarInsnNode)ain).var != 0 ? ain : null;
    }

    public static boolean match(AbstractInsnNode ain, AbstractInsnNode ain2) {
        if (ain.getOpcode() != ain2.getOpcode()) {
            return false;
        }
        if (ain instanceof InsnNode) {
            return true;
        }
        if (ain instanceof VarInsnNode) {
            return ((VarInsnNode)ain).var == ((VarInsnNode)ain2).var;
        }
        if (ain instanceof LdcInsnNode) {
            return ((LdcInsnNode)ain2).cst.equals(((LdcInsnNode)ain).cst);
        }
        if (ain instanceof IntInsnNode) {
            return ((IntInsnNode)ain).operand == ((IntInsnNode)ain2).operand;
        }
        if (ain instanceof TypeInsnNode) {
            return ((TypeInsnNode)ain).desc.equals(((TypeInsnNode)ain2).desc);
        }
        if (ain instanceof FieldInsnNode) {
            FieldInsnNode fin = (FieldInsnNode)ain;
            FieldInsnNode fin2 = (FieldInsnNode)ain2;
            return fin.owner.equals(fin2.owner) && fin.name.equals(fin2.name) && fin.desc.equals(fin2.desc);
        }
        if (ain instanceof MethodInsnNode) {
            MethodInsnNode min = (MethodInsnNode)ain;
            MethodInsnNode min2 = (MethodInsnNode)ain2;
            return min.owner.equals(min2.owner) && min.name.equals(min2.name) && min.desc.equals(min2.desc) && min.itf == min2.itf;
        }
        if (ain instanceof JumpInsnNode) {
            return ((JumpInsnNode)ain).label == ((JumpInsnNode)ain2).label;
        }
        if (ain instanceof IincInsnNode) {
            IincInsnNode iin = (IincInsnNode)ain;
            IincInsnNode iin2 = (IincInsnNode)ain2;
            return iin.var == iin2.var && iin.incr == iin2.incr;
        }
        return false;
    }

    public static boolean match(AbstractInsnNode ain, int opcode, Object ... args) {
        int code = ain.getOpcode();
        if (ain instanceof FrameNode) {
            code = ((FrameNode)ain).type;
        }
        if (ain.getOpcode() != opcode) {
            return false;
        }
        if (ain instanceof InsnNode || ain instanceof FrameNode) {
            return true;
        }
        if (ain instanceof VarInsnNode) {
            return args[0] instanceof Integer && ((VarInsnNode)ain).var == (Integer)args[0];
        }
        if (ain instanceof LdcInsnNode) {
            return args[0].equals(((LdcInsnNode)ain).cst);
        }
        if (ain instanceof IntInsnNode) {
            return args[0] instanceof Integer && ((IntInsnNode)ain).operand == (Integer)args[0];
        }
        if (ain instanceof TypeInsnNode) {
            return args[0] instanceof String && ((TypeInsnNode)ain).desc.equals(args[0]);
        }
        if (ain instanceof FieldInsnNode) {
            if (!(args.length == 3 && args[0] instanceof String && args[1] instanceof String && args[2] instanceof String)) {
                return false;
            }
            FieldInsnNode fin = (FieldInsnNode)ain;
            return fin.owner.equals(args[0]) && fin.name.equals(args[1]) && fin.desc.equals(args[2]);
        }
        if (ain instanceof MethodInsnNode) {
            if (!(args.length == 4 && args[0] instanceof String && args[1] instanceof String && args[2] instanceof String && args[3] instanceof Boolean)) {
                return false;
            }
            MethodInsnNode min = (MethodInsnNode)ain;
            return min.owner.equals(args[0]) && min.name.equals(args[1]) && min.desc.equals(args[2]) && min.itf == (Boolean)args[3];
        }
        if (ain instanceof JumpInsnNode) {
            return args[0] instanceof LabelNode && ((JumpInsnNode)ain).label == args[0];
        }
        if (ain instanceof IincInsnNode) {
            if (args.length != 2 || !(args[0] instanceof Integer) || !(args[1] instanceof Integer)) {
                return false;
            }
            IincInsnNode iin = (IincInsnNode)ain;
            return iin.var == (Integer)args[0] && iin.incr == (Integer)args[1];
        }
        return false;
    }

    public static MethodInsnNode getFirstMethodCall(ClassNode cn, MethodNode m, String owner, String name, String sig) {
        return ReikaASMHelper.getNthMethodCall(cn, m, owner, name, sig, 1);
    }

    public static MethodInsnNode getNthMethodCall(ClassNode cn, MethodNode m, String owner, String name, String sig, int n) {
        int counter = 0;
        for (int i = 0; i < m.instructions.size(); ++i) {
            AbstractInsnNode ain = m.instructions.get(i);
            if (!(ain instanceof MethodInsnNode)) continue;
            MethodInsnNode min = (MethodInsnNode)ain;
            if (!min.owner.equals(owner) || !min.name.equals(name) || !min.desc.equals(sig) || ++counter < n) continue;
            return min;
        }
        throw new ASMException.NoSuchASMMethodInstructionException(cn, m, owner, name, sig, n > 1 ? n : -1);
    }

    public static MethodInsnNode getFirstMethodCallByName(ClassNode cn, MethodNode m, String name) {
        return ReikaASMHelper.getNthMethodCallByName(cn, m, name, 1);
    }

    public static MethodInsnNode getNthMethodCallByName(ClassNode cn, MethodNode m, String name, int n) {
        return ReikaASMHelper.getNthMethodCallByName(cn, m, name, n, 0);
    }

    public static MethodInsnNode getNthMethodCallByName(ClassNode cn, MethodNode m, String name, int n, int index) {
        int counter = 0;
        for (int i = index; i < m.instructions.size(); ++i) {
            AbstractInsnNode ain = m.instructions.get(i);
            if (!(ain instanceof MethodInsnNode)) continue;
            MethodInsnNode min = (MethodInsnNode)ain;
            if (!min.name.equals(name) || ++counter < n) continue;
            return min;
        }
        throw new ASMException.NoSuchASMMethodInstructionException(cn, m, "[unspecified]", name, "[unspecified]", n > 1 ? n : -1);
    }

    public static FieldInsnNode getFirstFieldCallByName(ClassNode cn, MethodNode m, String name) {
        return ReikaASMHelper.getNthFieldCallByName(cn, m, name, 1);
    }

    public static FieldInsnNode getNthFieldCallByName(ClassNode cn, MethodNode m, String name, int n) {
        int counter = 0;
        for (int i = 0; i < m.instructions.size(); ++i) {
            AbstractInsnNode ain = m.instructions.get(i);
            if (!(ain instanceof FieldInsnNode)) continue;
            FieldInsnNode min = (FieldInsnNode)ain;
            if (!min.name.equals(name) || ++counter < n) continue;
            return min;
        }
        throw new ASMException.NoSuchASMFieldInstructionException(cn, m, "[unspecified]", name, n > 1 ? n : -1);
    }

    public static FieldInsnNode getFirstFieldCall(ClassNode cn, MethodNode m, String owner, String name) {
        return ReikaASMHelper.getNthFieldCall(cn, m, owner, name, 1);
    }

    public static FieldInsnNode getNthFieldCall(ClassNode cn, MethodNode m, String owner, String name, int n) {
        int counter = 0;
        for (int i = 0; i < m.instructions.size(); ++i) {
            AbstractInsnNode ain = m.instructions.get(i);
            if (!(ain instanceof FieldInsnNode)) continue;
            FieldInsnNode min = (FieldInsnNode)ain;
            if (!min.owner.equals(owner) || !min.name.equals(name) || ++counter < n) continue;
            return min;
        }
        throw new ASMException.NoSuchASMFieldInstructionException(cn, m, owner, name, n > 1 ? n : -1);
    }

    public static AbstractInsnNode getFirstOpcodeAfter(InsnList li, int idx, int opcode) {
        for (int i = idx; i < li.size(); ++i) {
            AbstractInsnNode ain = li.get(i);
            if (ain.getOpcode() != opcode) continue;
            return ain;
        }
        return null;
    }

    public static AbstractInsnNode getNthOpcodeAfter(InsnList li, int n, int idx, int opcode) {
        int c = 0;
        for (int i = idx; i < li.size(); ++i) {
            AbstractInsnNode ain = li.get(i);
            if (ain.getOpcode() != opcode || ++c != n) continue;
            return ain;
        }
        return null;
    }

    public static InsnList copyInsnList(InsnList li, LabelNode ... pairs) {
        HashMap<LabelNode, LabelNode> map = new HashMap<LabelNode, LabelNode>();
        for (int i = 0; i < pairs.length; i += 2) {
            map.put(pairs[i], pairs[i + 1]);
        }
        return ReikaASMHelper.copyInsnList(li, map);
    }

    public static InsnList copyInsnList(InsnList li, Map<LabelNode, LabelNode> labels) {
        InsnList copy = new InsnList();
        for (int i = 0; i < li.size(); ++i) {
            AbstractInsnNode ain = li.get(i);
            copy.add(ReikaASMHelper.copyInstruction(ain, labels));
        }
        return copy;
    }

    public static AbstractInsnNode copyInstruction(AbstractInsnNode ain) {
        return ReikaASMHelper.copyInstruction(ain, new HashMap<LabelNode, LabelNode>());
    }

    public static AbstractInsnNode copyInstruction(AbstractInsnNode ain, Map<LabelNode, LabelNode> labels) {
        return ain.clone(labels);
    }

    public static String getMethodReturnType(MethodNode m) {
        ArrayList<String> li = ReikaASMHelper.parseMethodSignature(m);
        String type = li.get(li.size() - 1);
        return type;
    }

    public static ArrayList<String> parseMethodSignature(MethodNode min) {
        return ReikaASMHelper.parseMethodSignature(min.desc);
    }

    public static ArrayList<String> parseMethodSignature(String sig) {
        int idx = sig.lastIndexOf(41);
        String ret = sig.substring(idx + 1);
        ArrayList<String> li = ReikaASMHelper.parseMethodDesc(sig);
        li.add(ret);
        return li;
    }

    public static ArrayList<String> parseMethodSignature(MethodInsnNode min) {
        int idx = min.desc.lastIndexOf(41);
        String ret = min.desc.substring(idx + 1);
        ArrayList<String> li = ReikaASMHelper.parseMethodDesc(min.desc);
        li.add(ret);
        return li;
    }

    public static String compileSignature(ArrayList<String> argsAndRet) {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        for (int i = 0; i < argsAndRet.size() - 1; ++i) {
            sb.append(argsAndRet.get(i));
        }
        sb.append(")");
        sb.append(argsAndRet.get(argsAndRet.size() - 1));
        return sb.toString();
    }

    public static String clearAnnotations(List<AnnotationNode> li) {
        if (li == null) {
            return "null";
        }
        if (li.isEmpty()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (AnnotationNode a : li) {
            sb.append(a.desc);
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    public static String clearTypeAnnotations(List<TypeAnnotationNode> li) {
        if (li == null) {
            return "null";
        }
        if (li.isEmpty()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (AnnotationNode annotationNode : li) {
            sb.append(annotationNode.desc);
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    public static MethodNode addMethod(ClassNode cn, InsnList insns, String name, String sig, int flags) {
        if (ReikaASMHelper.getMethodByNameAndSig(cn, name, sig) != null) {
            throw new ASMException.DuplicateASMMethodException(cn, name, sig);
        }
        MethodNode m = new MethodNode(flags, name, sig, null, new String[0]);
        m.invisibleAnnotations = new ArrayList();
        m.invisibleParameterAnnotations = new List[0];
        m.invisibleLocalVariableAnnotations = new ArrayList();
        m.invisibleTypeAnnotations = new ArrayList();
        m.visibleAnnotations = new ArrayList();
        m.visibleLocalVariableAnnotations = new ArrayList();
        m.visibleParameterAnnotations = new List[0];
        m.visibleTypeAnnotations = new ArrayList();
        m.exceptions = new ArrayList();
        m.instructions = insns;
        cn.methods.add(m);
        return m;
    }

    public static MethodNode removeMethod(ClassNode cn, String name, String sig) {
        Iterator it = cn.methods.iterator();
        while (it.hasNext()) {
            MethodNode m = (MethodNode)it.next();
            if (!m.name.equals(name) || !m.desc.equals(sig)) continue;
            it.remove();
            return m;
        }
        return null;
    }

    public static void addField(ClassNode cn, String name, String type, int flags, Object init) {
        try {
            ReikaASMHelper.getFieldByName(cn, name);
            throw new ASMException.DuplicateASMFieldException(cn, name);
        }
        catch (ASMException.NoSuchASMFieldException noSuchASMFieldException) {
            FieldNode m = new FieldNode(flags, name, type, null, init);
            cn.fields.add(m);
            return;
        }
    }

    public static AbstractInsnNode getPattern(InsnList li, Object ... pattern) {
        block0: for (int i = 0; i < li.size(); ++i) {
            if (i + pattern.length > li.size()) continue;
            for (int k = 0; k < pattern.length; ++k) {
                AbstractInsnNode at = li.get(i + k);
                Object o = pattern[k];
                if (!(o instanceof Integer ? at.getOpcode() == ((Integer)o).intValue() : o instanceof AbstractInsnNode && ReikaASMHelper.match(at, (AbstractInsnNode)o))) continue block0;
                if (k != pattern.length - 1) continue;
                return li.get(i);
            }
        }
        return null;
    }

    public static void deleteFrom(ClassNode cn, InsnList li, AbstractInsnNode start, AbstractInsnNode end) {
        if (start == null) {
            throw new ASMException.InvalidASMArgumentException(cn, "Null start instruction");
        }
        if (end == null) {
            throw new ASMException.InvalidASMArgumentException(cn, "Null end instruction");
        }
        AbstractInsnNode loc = start;
        while (loc != end) {
            AbstractInsnNode loc2 = loc.getNext();
            li.remove(loc);
            loc = loc2;
        }
        li.remove(end);
    }

    public static void throwConflict(String patcher, ClassNode cn, MethodNode m, String msg) {
        ReikaASMHelper.throwConflict(patcher, cn, m, msg, null);
    }

    public static void throwConflict(String patcher, ClassNode cn, MethodNode m, String msg, Throwable t) {
        ASMException.ASMConflictException ex = new ASMException.ASMConflictException(activeMod, cn, m, patcher, msg);
        if (t != null) {
            ex.initCause(t);
        }
        ReikaASMHelper.printClassToFile(cn, new File((File)FMLInjectionData.data()[6], "ClassError"));
        throw ex;
    }

    public static void printClassToFile(ClassNode cn, File folder) {
        ClassWriter writer = new ClassWriter(1);
        cn.accept((ClassVisitor)writer);
        byte[] newdata = writer.toByteArray();
        File f = new File(folder, cn.name + ".class");
        try (FileOutputStream out = new FileOutputStream(f);){
            folder.mkdirs();
            out.write(newdata);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean checkForClass(String s) {
        try {
            return Launch.classLoader.getClassBytes(s) != null;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean checkIfClassInheritsMethod(ClassNode cn, MethodNode mn) {
        try {
            String s = cn.superName.replaceAll("/", ".");
            for (Class<?> c = Class.forName(s); c != null; c = c.getSuperclass()) {
                if (!ReikaASMHelper.classContainsMethod(c, mn)) continue;
                return true;
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static AnnotationNode copyAnnotation(AnnotationNode a) {
        AnnotationNode cp = new AnnotationNode(a.desc);
        cp.values.addAll(a.values);
        return cp;
    }

    public static void changeFirstNumericalArgument(InsnList li, int num, int repl) {
        int look = ReikaASMHelper.getOpcodeForNum(num);
        AbstractInsnNode put = ReikaASMHelper.getInsnForNum(repl);
        if (put != null) {
            for (int i = 0; i < li.size(); ++i) {
                AbstractInsnNode ain = li.get(i);
                if (ain.getOpcode() != look || !ReikaASMHelper.matchNumberNode(ain, num)) continue;
                li.insert(ain, put);
                li.remove(ain);
            }
        }
    }

    public static boolean matchNumberNode(AbstractInsnNode ain, int val) {
        switch (ain.getOpcode()) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
            case 16: 
            case 17: {
                return ((IntInsnNode)ain).operand == val;
            }
            case 18: {
                return ((LdcInsnNode)ain).cst.equals(val);
            }
        }
        return false;
    }

    public static AbstractInsnNode getInsnForNum(int val) {
        int set = ReikaASMHelper.getOpcodeForNum(val);
        switch (set) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return new InsnNode(set);
            }
            case 16: 
            case 17: {
                return new IntInsnNode(set, val);
            }
            case 18: {
                return new LdcInsnNode((Object)val);
            }
        }
        return null;
    }

    private static int getOpcodeForNum(int val) {
        if (val == 0) {
            return 3;
        }
        if (val == 1) {
            return 4;
        }
        if (val == 2) {
            return 5;
        }
        if (val == 3) {
            return 6;
        }
        if (val == 4) {
            return 7;
        }
        if (val == 5) {
            return 8;
        }
        if (val <= 255) {
            return 16;
        }
        if (val <= Short.MAX_VALUE) {
            return 17;
        }
        return 18;
    }

    public static MethodInsnNode getCallerInsn(String owner, MethodNode mn) {
        int opcode = 182;
        if ((mn.access & 2) != 0) {
            opcode = 183;
        }
        if (mn.name.equals("<init>")) {
            opcode = 183;
        }
        if ((mn.access & 8) != 0) {
            opcode = 184;
        }
        if ((mn.access & 0x200) != 0) {
            opcode = 185;
        }
        return new MethodInsnNode(opcode, owner, mn.name, mn.desc, opcode == 185);
    }

    public static int getOpcodeForMethodReturn(MethodInsnNode m) {
        ArrayList<String> li = ReikaASMHelper.parseMethodSignature(m);
        String type = li.get(li.size() - 1);
        PrimitiveType p = PrimitiveType.getFromSig(type);
        if (p != null) {
            return p.returnCode;
        }
        return 176;
    }

    public static int getOpcodeForMethodReturn(MethodNode m) {
        ArrayList<String> li = ReikaASMHelper.parseMethodSignature(m);
        String type = li.get(li.size() - 1);
        PrimitiveType p = PrimitiveType.getFromSig(type);
        if (p != null) {
            return p.returnCode;
        }
        return 176;
    }

    public static InsnList getIntReturnInsnList(int val) {
        InsnList li = new InsnList();
        li.add(ReikaASMHelper.getInsnForNum(val));
        li.add((AbstractInsnNode)new InsnNode(172));
        return li;
    }

    public static LabelNode getFirstLabelBefore(InsnList li, int idx) {
        for (int i = idx; i >= 0; --i) {
            AbstractInsnNode ain = li.get(i);
            if (!(ain instanceof LabelNode)) continue;
            return (LabelNode)ain;
        }
        return null;
    }

    public static LabelNode getFirstLabelAfter(InsnList li, int idx) {
        for (int i = idx; i < li.size(); ++i) {
            AbstractInsnNode ain = li.get(i);
            if (!(ain instanceof LabelNode)) continue;
            return (LabelNode)ain;
        }
        return null;
    }

    public static void removeFinal(MethodNode m) {
        m.access &= 0xFFFFFFEF;
    }

    public static String convertClassName(Class c, boolean appendPrePostFixes) {
        String base = c.getName().replace('.', '/');
        return appendPrePostFixes ? "L" + base + ";" : base;
    }

    public static String convertClassName(ClassNode cn, boolean appendPrePostFixes) {
        String base = cn.name.replace('.', '/');
        return appendPrePostFixes ? "L" + base + ";" : base;
    }

    public static Side getSide() {
        return FMLLaunchHandler.side();
    }

    public static void writeClassFile(ClassNode cn, String path) {
        if (FMLForgePlugin.RUNTIME_DEOBF) {
            cn = ReikaASMHelper.copyClassNode(cn);
            ReikaASMHelper.deobfClassFile(cn);
        }
        ClassWriter writer = new ClassWriter(0);
        cn.accept((ClassVisitor)writer);
        byte[] data = writer.toByteArray();
        String cname = cn.name.replaceAll("\\.", "/").replaceAll("\\\\", "/");
        if (activeMod != null) {
            cname = "[BY " + activeMod.toUpperCase(Locale.ENGLISH) + "] " + cname;
        }
        File f = new File(path, cname + ".class");
        f.getParentFile().mkdirs();
        try (FileOutputStream out = new FileOutputStream(f);){
            out.write(data);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static ClassNode copyClassNode(ClassNode cn) {
        ClassWriter writer = new ClassWriter(0);
        cn.accept((ClassVisitor)writer);
        byte[] data = writer.toByteArray();
        ClassNode cn2 = new ClassNode();
        ClassReader classReader = new ClassReader(data);
        classReader.accept((ClassVisitor)cn2, 0);
        return cn2;
    }

    public static void deobfClassFile(ClassNode cn) {
        if (srgMap.isEmpty()) {
            ReikaASMHelper.loadSRGs();
        }
        for (FieldNode f : cn.fields) {
            ReikaASMHelper.deobfField(f);
        }
        for (MethodNode m : cn.methods) {
            ReikaASMHelper.deobfMethod(m);
        }
    }

    private static void deobfField(FieldNode f) {
        String repl = srgMap.get(f.name);
        if (repl != null) {
            f.name = repl;
        }
    }

    private static void deobfMethod(MethodNode m) {
        String repl = srgMap.get(m.name);
        if (repl != null) {
            m.name = repl;
        }
        for (int i = 0; i < m.instructions.size(); ++i) {
            AbstractInsnNode ain = m.instructions.get(i);
            if (ain instanceof FieldInsnNode) {
                FieldInsnNode fin = (FieldInsnNode)ain;
                repl = srgMap.get(fin.name);
                if (repl == null) continue;
                fin.name = repl;
                continue;
            }
            if (!(ain instanceof MethodInsnNode)) continue;
            MethodInsnNode min = (MethodInsnNode)ain;
            repl = srgMap.get(min.name);
            if (repl == null) continue;
            min.name = repl;
        }
    }

    private static void loadSRGs() {
        File f = new File("C:/Users/Reika/.gradle/caches/minecraft/net/minecraftforge/forge/1.7.10-10.13.4.1614-1.7.10/reika/custom/srgs/mcp-srg.srg");
        if (!f.exists()) {
            DragonAPICore.log("SRGs do not exist. Cannot apply deobf.");
            return;
        }
        List<String> li = ReikaFileReader.getFileAsLines(f, true, Charsets.UTF_8);
        for (String s : li) {
            int obfidx;
            String obf;
            int deobfidx;
            String[] parts;
            String deobf;
            if (s.startsWith("CL") || (deobf = (parts = s.split(" "))[deobfidx = s.startsWith("MD") ? 1 : 1]).equals(obf = parts[obfidx = s.startsWith("MD") ? 3 : 2])) continue;
            deobf = deobf.substring(deobf.lastIndexOf(47) + 1);
            obf = obf.substring(obf.lastIndexOf(47) + 1);
            srgMap.put(obf, deobf);
        }
    }

    public static String addLeadingArgument(String sig, String arg) {
        ArrayList<String> li = ReikaASMHelper.parseMethodSignature(sig);
        li.add(0, arg);
        return ReikaASMHelper.compileSignature(li);
    }

    public static String addTrailingArgument(String sig, String arg) {
        ArrayList<String> li = ReikaASMHelper.parseMethodSignature(sig);
        li.add(li.size() - 1, arg);
        return ReikaASMHelper.compileSignature(li);
    }

    public static void addLeadingArgument(MethodNode min, String arg) {
        min.desc = ReikaASMHelper.addLeadingArgument(min.desc, arg);
    }

    public static void addTrailingArgument(MethodNode min, String arg) {
        min.desc = ReikaASMHelper.addTrailingArgument(min.desc, arg);
    }

    public static void addLeadingArgument(MethodInsnNode min, String arg) {
        min.desc = ReikaASMHelper.addLeadingArgument(min.desc, arg);
    }

    public static void addTrailingArgument(MethodInsnNode min, String arg) {
        min.desc = ReikaASMHelper.addTrailingArgument(min.desc, arg);
    }

    public static void changeReturnType(MethodInsnNode min, String arg) {
        min.desc = ReikaASMHelper.changeReturnType(min.desc, arg);
    }

    public static String changeReturnType(String sig, String arg) {
        ArrayList<String> li = ReikaASMHelper.parseMethodSignature(sig);
        li.remove(li.size() - 1);
        li.add(arg);
        return ReikaASMHelper.compileSignature(li);
    }

    public static void replaceInstruction(InsnList li, AbstractInsnNode tgt, AbstractInsnNode repl) {
        li.insertBefore(tgt, repl);
        li.remove(tgt);
    }

    public static void replaceInstruction(InsnList li, AbstractInsnNode tgt, InsnList repl) {
        li.insertBefore(tgt, repl);
        li.remove(tgt);
    }

    public static void clearClass(ClassNode cn) {
        ArrayList c = new ArrayList(cn.methods);
        for (MethodNode m : c) {
            if (m.name.equals("<init>")) continue;
            ReikaASMHelper.clearMethodBody(m);
            cn.methods.remove(m);
            ReikaASMHelper.addMethod(cn, ReikaASMHelper.copyInsnList(m.instructions, new LabelNode[0]), m.name, m.desc, m.access);
        }
    }

    public static void exposeMethod(ClassNode cn, String name, String sig) {
        MethodNode m = ReikaASMHelper.getMethodByName(cn, name, sig);
        m.access &= 0xFFFFFFFD;
        m.access &= 0xFFFFFFFB;
        m.access |= 1;
    }

    public static MethodInsnNode rerouteMethod(ClassNode cn, String name, String ownerNew, String nameNew, String sig) {
        MethodNode m = ReikaASMHelper.getMethodByName(cn, name, sig);
        return ReikaASMHelper.rerouteMethod(cn, m, ownerNew, nameNew);
    }

    public static MethodInsnNode rerouteMethod(ClassNode cn, MethodNode m, String ownerNew, String nameNew) {
        m.instructions.clear();
        ArrayList<String> args = ReikaASMHelper.parseMethodArguments(m);
        String ret = ReikaASMHelper.getMethodReturnType(m);
        boolean stat = (m.access & 8) != 0;
        int idx = stat ? 0 : 1;
        String self = m.desc;
        if (!stat) {
            m.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            self = ReikaASMHelper.addLeadingArgument(m.desc, ReikaASMHelper.convertClassName(cn, true));
        }
        for (String s : args) {
            m.instructions.add((AbstractInsnNode)new VarInsnNode(PrimitiveType.getFromSig((String)s).loadCode, idx));
            ++idx;
        }
        MethodInsnNode call = new MethodInsnNode(184, ownerNew, nameNew, self, false);
        m.instructions.add((AbstractInsnNode)call);
        m.instructions.add((AbstractInsnNode)new InsnNode(ReikaASMHelper.getOpcodeForMethodReturn(m)));
        return call;
    }

    public static ArrayList<AbstractInsnNode> subList(InsnList li, int from, int to) {
        ArrayList<AbstractInsnNode> ret = new ArrayList<AbstractInsnNode>();
        for (int i = from; i <= to; ++i) {
            ret.add(li.get(i));
        }
        return ret;
    }

    public static int getOpcodeByName(String s) {
        if (opcodeNames.isEmpty()) {
            try {
                ReikaASMHelper.loadNames();
            }
            catch (Exception e) {
                ReikaASMHelper.logError("Error loading opcode name map!");
                e.printStackTrace();
            }
        }
        return opcodeNames.get(s);
    }

    private static void loadNames() throws Exception {
        Field[] fds = Opcodes.class.getDeclaredFields();
        boolean primed = false;
        for (Field f : fds) {
            if (f.getType() != Integer.TYPE || !primed && !f.getName().equals("NOP")) continue;
            primed = true;
            opcodeNames.put(f.getName(), f.getInt(null));
        }
    }

    public static MultiMap<String, Patcher> getPatchers(String mod, String pack) {
        activeMod = mod;
        MultiMap<String, Patcher> ret = new MultiMap<String, Patcher>(MultiMap.CollectionType.HASHSET);
        try {
            int patchCount = 0;
            int enabledCount = 0;
            Collection<Class> li = ReikaJavaLibrary.getAllClassesFromPackage(pack, Patcher.class, true, true);
            for (Class c : li) {
                if (LegacyPatcher.class.isAssignableFrom(c)) continue;
                try {
                    ++patchCount;
                    Patcher p = (Patcher)c.newInstance();
                    if (p.isEnabled()) {
                        p.activate();
                        ++enabledCount;
                        String s = !FMLForgePlugin.RUNTIME_DEOBF ? p.deobfName : p.obfName;
                        ret.addValue(s, p);
                        continue;
                    }
                    if (p.isDisabledByDefault()) continue;
                    ReikaASMHelper.log("******************************************************************************************");
                    ReikaASMHelper.log("WARNING: ASM TRANSFORMER '" + p + "' HAS BEEN DISABLED. THIS CAN BREAK MANY THINGS.");
                    ReikaASMHelper.log("IF THIS TRANSFORMER HAS BEEN DISABLED WITHOUT GOOD REASON, TURN IT BACK ON IMMEDIATELY!");
                    ReikaASMHelper.log("******************************************************************************************");
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not create " + mod + " ASM handler " + c, e);
                }
            }
            ReikaASMHelper.log("Registered " + patchCount + " ASM handlers, of which " + enabledCount + " are enabled.");
        }
        catch (IOException e) {
            throw new RuntimeException("Could not find " + mod + " ASM handlers", e);
        }
        activeMod = null;
        return ret;
    }

    static {
        logger = LogManager.getLogger();
        forgeVersion_Major = Integer.parseInt((String)FMLInjectionData.data()[0]);
        forgeVersion_Minor = Integer.parseInt((String)FMLInjectionData.data()[1]);
        forgeVersion_Revision = Integer.parseInt((String)FMLInjectionData.data()[2]);
        forgeVersion_Build = Integer.parseInt((String)FMLInjectionData.data()[3]);
        srgMap = new HashMap();
        opcodeNames = new HashMap();
        try {
            opcodeField = AbstractInsnNode.class.getDeclaredField("opcode");
            opcodeField.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static enum PrimitiveType {
        VOID("V", Void.TYPE, 177, 1, 58),
        INT("I", Integer.TYPE, 172, 21, 54),
        BOOLEAN("Z", Boolean.TYPE, 172, 21, 54),
        BYTE("B", Byte.TYPE, 172, 21, 54),
        LONG("L", Long.TYPE, 173, 22, 55),
        SHORT("S", Short.TYPE, 172, 21, 54),
        FLOAT("F", Float.TYPE, 174, 23, 56),
        DOUBLE("D", Double.TYPE, 175, 24, 57),
        INTARRAY("[I", int[].class, 176, 25, 58),
        BYTEARRAY("[B", byte[].class, 176, 25, 58),
        SHORTARRAY("[S", short[].class, 176, 25, 58),
        DOUBARRAY("[D", double[].class, 176, 25, 58),
        BOOLARRAY("[Z", boolean[].class, 176, 25, 58),
        FLOATARRAY("[F", float[].class, 176, 25, 58),
        OBJECT("L*;", Object.class, 176, 25, 58);

        public final String id;
        public final Class classType;
        public final int returnCode;
        public final int loadCode;
        public final int storeCode;
        private static final HashMap<String, PrimitiveType> map;

        private PrimitiveType(String s, Class c, int retcode, int loadcode, int storecode) {
            this.id = s;
            this.classType = c;
            this.returnCode = retcode;
            this.loadCode = loadcode;
            this.storeCode = storecode;
        }

        public static PrimitiveType getFromSig(String id) {
            return map.containsKey(id) ? map.get(id) : OBJECT;
        }

        static {
            map = new HashMap();
            for (int i = 0; i < PrimitiveType.values().length; ++i) {
                PrimitiveType type = PrimitiveType.values()[i];
                map.put(type.id, type);
            }
        }
    }
}

