/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Libraries.Java;

import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.Minecraft;

public class ReikaJVMParser {
    private static final HashSet<String> args = new HashSet();
    private static final int[] version = ReikaJVMParser.getJavaVersion();

    public static Set<String> getAllArguments() {
        return Collections.unmodifiableSet(args);
    }

    public static boolean isArgumentPresent(String arg) {
        return args.contains(arg);
    }

    public static String getArgumentModifier(String pre) {
        for (String s : args) {
            if (!s.startsWith(pre)) continue;
            return s.substring(pre.length());
        }
        return null;
    }

    public static int getArgumentInteger(String pre) {
        return ReikaJVMParser.getArgumentInteger(pre, -1);
    }

    public static int getArgumentInteger(String pre, int fallback) {
        for (String s : args) {
            if (!s.startsWith(pre)) continue;
            int idx = s.indexOf(61);
            if (idx < 0) {
                return fallback;
            }
            String ret = s.substring(idx + 1);
            return ReikaJavaLibrary.safeIntParse(ret);
        }
        return fallback;
    }

    public static long getAllocatedHeapMemory() {
        for (String s : args) {
            if (!s.startsWith("-Xmx")) continue;
            String ret = s.substring(4);
            char size = ret.charAt(ret.length() - 1);
            if (Character.isLowerCase(size)) {
                size = Character.toUpperCase(size);
            }
            ret = ret.substring(0, ret.length() - 1);
            int base = Integer.parseInt(ret);
            if (size == 'K') {
                return (long)base * 1000L;
            }
            if (size == 'M') {
                return (long)base * 1000000L;
            }
            if (size == 'G') {
                return (long)base * 1000000000L;
            }
            throw new IllegalArgumentException("Invalid memory specification.");
        }
        return 1000000000L;
    }

    private static int[] getJavaVersion() {
        try {
            String v = System.getProperty("java.version");
            String[] parts = v.replaceAll("[^0-9\\._]", "").replaceAll("_", ".").split("\\.");
            int[] ret = new int[parts.length - 1];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = Integer.parseInt(parts[i + 1]);
            }
            return ret;
        }
        catch (Exception e) {
            ReikaJavaLibrary.pConsole("***********************************************************************************************");
            ReikaJavaLibrary.pConsole("UNABLE TO PARSE JAVA VERSION! ARE YOU USING A NONSTANDARD JVM? THIS IS LIKELY TO BREAK THINGS!");
            ReikaJavaLibrary.pConsole(ReikaJVMParser.getFullJavaInfo());
            ReikaJavaLibrary.pConsole("***********************************************************************************************");
            return new int[]{-1, -1, -1};
        }
    }

    public static int getJavaVersion(int subindex) {
        return version[subindex];
    }

    public static String getFullJavaInfo() {
        return System.getProperty("java.version") + " " + System.getProperty("java.vm.name") + " (" + System.getProperty("java.vm.info") + "), " + System.getProperty("java.vm.vendor");
    }

    public static String getLauncher() {
        return FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT ? ReikaJVMParser.getLauncherClient() : "Server";
    }

    @SideOnly(value=Side.CLIENT)
    public static String getLauncherClient() {
        try {
            Field f = Minecraft.class.getDeclaredField("launchedVersion");
            f.setAccessible(true);
            return (String)f.get(Minecraft.func_71410_x());
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.toString();
        }
    }

    static {
        args.addAll(ManagementFactory.getRuntimeMXBean().getInputArguments());
        ReikaJavaLibrary.pConsole("Java Version: " + Arrays.toString(version));
        ReikaJavaLibrary.pConsole("Heap memory allocation: " + ReikaJVMParser.getAllocatedHeapMemory());
        ReikaJavaLibrary.pConsole(args.size() + " Java arguments present: " + args);
    }
}

