/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Libraries.Java;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Exception.MisuseException;
import Reika.DragonAPI.IO.ReikaFileReader;
import Reika.DragonAPI.Libraries.Java.ClassModifiers;
import Reika.DragonAPI.Libraries.Java.ReikaASMHelper;
import Reika.DragonAPI.Libraries.Java.ReikaArrayHelper;
import Reika.DragonAPI.Libraries.Java.ReikaJVMParser;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.ModList;
import com.google.common.reflect.ClassPath;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import org.apache.commons.codec.Charsets;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.Level;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodNode;

public final class ReikaJavaLibrary
extends DragonAPICore {
    private static int maxRecurse = -1;
    public static boolean dumpStack = false;
    public static boolean silent = false;
    private static final boolean printClasses = ReikaJVMParser.isArgumentPresent("-DragonAPI_printClassInit");
    private static final HashMap<String, Object> threadLock = new HashMap();
    private static final char[] IDChars = new char[]{'\u03b1', '\u03b2', '\u03b3', '\u03b4', '\u03b5', '\u03b6', '\u03b7', '\u03b8', '\u03b9', '\u03ba', '\u03bb', '\u03bc', '\u03bd', '\u03be', '\u03bf', '\u03c0', '\u03c1', '\u03c2', '\u03c3', '\u03c4', '\u03c5', '\u03c6', '\u03c7', '\u03c8', '\u03c9', '\u0393', '\u0394', '\u0398', '\u039b', '\u03a0', '\u03a3', '\u03a6', '\u03a8', '\u03a9', '\u0414', '\u0416', '\u0418', '\u0428', '\u042c', '\u042d', '\u042e', '\u042f', '\u05d0', '\u05d1', '\u05d2', '\u05d3', '\u05d4', '\u05d7', '\u05d8', '\u05da', '\u05db', '\u05dc', '\u05dd', '\u05de', '\u05e1', '\u05e2', '\u05e3', '\u05e4', '\u05e6', '\u05e7', '\u05e8', '\u05e9', '\u05ea'};
    public static final Comparator<Comparable> reverseComparator = new Comparator<Comparable>(){

        @Override
        public int compare(Comparable o1, Comparable o2) {
            return o2.compareTo(o1);
        }
    };

    public static void pConsole(Object obj) {
        ReikaJavaLibrary.pConsole(Level.INFO, obj);
    }

    public static void pConsole(Level level, Object obj) {
        if (silent) {
            return;
        }
        if (obj == null) {
            ReikaJavaLibrary.writeLineToConsoleAndLogs(level, "null arg");
        } else {
            Class<?> cl = obj.getClass();
            if (cl != String.class && cl != Integer.class && cl != Boolean.class) {
                ReikaJavaLibrary.writeLineToConsoleAndLogs(level, String.valueOf(obj) + " of " + String.valueOf(cl));
            } else {
                ReikaJavaLibrary.writeLineToConsoleAndLogs(level, String.valueOf(obj));
            }
        }
        if (dumpStack) {
            ReikaJavaLibrary.dumpStack();
        }
    }

    public static void dumpStack() {
        ReikaJavaLibrary.writeLineToConsoleAndLogs(Level.WARN, "Stack Trace:");
        StackTraceElement[] s = new Exception("Stack Trace").getStackTrace();
        for (int i = 1; i < s.length; ++i) {
            ReikaJavaLibrary.writeLineToConsoleAndLogs(Level.WARN, "\t" + s[i].toString());
        }
    }

    private static void writeLineToConsoleAndLogs(Level level, String s) {
        s = s.replaceAll("%", "%%");
        FMLLog.log((Level)level, (String)s, (Object[])new Object[0]);
    }

    public static void spamConsole(Object obj) {
        String sg = String.valueOf(obj);
        for (int i = 0; i < 16; ++i) {
            ReikaJavaLibrary.pConsole(sg);
        }
    }

    public static void writeCoord(World world, int x, int y, int z) {
        ReikaJavaLibrary.pConsole(world.func_147439_a(x, y, z) + ":" + world.func_72805_g(x, y, z) + " @ " + x + ", " + y + ", " + z + " @DIM" + world.field_73011_w.field_76574_g);
    }

    public static void pConsole(Object obj, Side s) {
        if (FMLCommonHandler.instance().getEffectiveSide() == s) {
            ReikaJavaLibrary.pConsole(obj);
        }
    }

    public static void pConsole(Object obj, Side s, boolean con) {
        if (con) {
            ReikaJavaLibrary.pConsole(obj, s);
        }
    }

    public static void pConsole(Object obj, boolean con) {
        if (con) {
            ReikaJavaLibrary.pConsole(obj);
        }
    }

    public static <E> HashSet<E> makeSetFromArray(E[] obj) {
        HashSet<E> li = new HashSet<E>();
        for (int i = 0; i < obj.length; ++i) {
            li.add(obj[i]);
        }
        return li;
    }

    public static <E> ArrayList makeListFromArray(E[] obj) {
        ArrayList<E> li = new ArrayList<E>();
        for (int i = 0; i < obj.length; ++i) {
            li.add(obj[i]);
        }
        return li;
    }

    public static ArrayList<Integer> makeIntListFromArray(int ... obj) {
        ArrayList<Integer> li = new ArrayList<Integer>();
        for (int i = 0; i < obj.length; ++i) {
            li.add(obj[i]);
        }
        return li;
    }

    public static ArrayList<Byte> makeIntListFromArray(byte ... obj) {
        ArrayList<Byte> li = new ArrayList<Byte>();
        for (int i = 0; i < obj.length; ++i) {
            li.add(obj[i]);
        }
        return li;
    }

    public static <E> ArrayList<E> makeListFrom(E obj) {
        ArrayList<E> li = new ArrayList<E>();
        li.add(obj);
        return li;
    }

    public static <E> ArrayList makeListFrom(E ... obj) {
        ArrayList<E> li = new ArrayList<E>();
        for (int i = 0; i < obj.length; ++i) {
            li.add(obj[i]);
        }
        return li;
    }

    public static boolean isValidInteger(String s) {
        if (s.contentEquals("-")) {
            return true;
        }
        try {
            Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public static int safeIntParse(String s) {
        boolean neg = false;
        int num = 0;
        if (s.startsWith("-")) {
            s = s.substring(1);
            neg = true;
        }
        if (s.matches("\\d+")) {
            num = Integer.parseInt(s);
        }
        return neg ? -num : num;
    }

    public static long safeLongParse(String s) {
        boolean neg = false;
        long num = 0L;
        if (s.startsWith("-")) {
            s = s.substring(1);
            neg = true;
        }
        if (s.matches("\\d+")) {
            num = Long.parseLong(s);
        }
        return neg ? -num : num;
    }

    public static void printLine(int length) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            sb.append("-");
        }
        ReikaJavaLibrary.pConsole(sb.toString());
    }

    public static <T, E> T getHashMapKeyByValue(HashMap<T, E> map, E value) {
        for (Map.Entry<T, E> entry : map.entrySet()) {
            if (!value.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    public static boolean doesClassExist(String cl) {
        try {
            Class.forName(cl, false, Thread.currentThread().getContextClassLoader());
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        catch (NoClassDefFoundError e) {
            return false;
        }
    }

    public static Class getClassNoException(String cl) {
        try {
            return Class.forName(cl);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static void initClass(String c) {
        try {
            Class.forName(c, true, ReikaJavaLibrary.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            ReikaJavaLibrary.pConsole("DRAGONAPI: Failed to initalize class " + c + "! Class not found!");
            e.printStackTrace();
        }
        catch (NoClassDefFoundError e) {
            ReikaJavaLibrary.pConsole("DRAGONAPI: Failed to initalize class " + c + "! Class not found!");
            e.printStackTrace();
        }
        catch (LinkageError e) {
            ReikaJavaLibrary.pConsole("DRAGONAPI: Failed to initalize class " + c + "! Class not found!");
            e.printStackTrace();
        }
        catch (RuntimeException e) {
            ReikaJavaLibrary.pConsole("DRAGONAPI: Failed to initalize class " + c + "!");
            String s = e.getMessage();
            if (s.endsWith("for invalid side SERVER")) {
                ReikaJavaLibrary.pConsole("DRAGONAPI: Attemped to load a clientside class on the server! This is a significant programming error!");
            }
            e.printStackTrace();
        }
    }

    public static void initClass(Class c, boolean errorIfFail) {
        if (printClasses) {
            ReikaJavaLibrary.printClassMetadata(c);
        }
        if (c == null) {
            ReikaJavaLibrary.pConsole("DRAGONAPI: Cannot initalize a null class!");
            ReikaJavaLibrary.dumpStack();
            return;
        }
        try {
            ReikaJavaLibrary.pConsole("DRAGONAPI: Initializing class " + c.getName() + " on classloader " + Thread.currentThread().getContextClassLoader());
            Class.forName(c.getName());
        }
        catch (ClassNotFoundException e) {
            if (errorIfFail) {
                throw new RuntimeException(e);
            }
            ReikaJavaLibrary.pConsole("DRAGONAPI: Failed to initalize class " + c.getName() + "! Class not found!");
            e.printStackTrace();
            ReikaJavaLibrary.printClassMetadata(c);
        }
        catch (NoClassDefFoundError e) {
            ReikaJavaLibrary.pConsole("DRAGONAPI: Failed to initalize class " + c.getName() + "! Class not found!");
            e.printStackTrace();
            ReikaJavaLibrary.printClassMetadata(c);
        }
        catch (LinkageError e) {
            ReikaJavaLibrary.pConsole("DRAGONAPI: Failed to initalize class " + c.getName() + "! Class not found!");
            e.printStackTrace();
            ReikaJavaLibrary.printClassMetadata(c);
        }
        catch (RuntimeException e) {
            ReikaJavaLibrary.pConsole("DRAGONAPI: Failed to initalize class " + c.getName() + "!");
            String s = e.getMessage();
            if (s.endsWith("for invalid side SERVER")) {
                ReikaJavaLibrary.pConsole("DRAGONAPI: Attemped to load a clientside class on the server! This is a significant programming error!");
            }
            e.printStackTrace();
        }
    }

    public static void printClassSource(Class c, String path) {
        ReikaJavaLibrary.printClassSource(path + c.getName(), ReikaJavaLibrary.getClassBytes(c));
    }

    public static void printClassMetadata(Class c) {
        ReikaJavaLibrary.printClassMetadata(c.getName(), c);
    }

    public static void printClassASM(Class c) {
        ReikaJavaLibrary.printClassASM(c.getName(), ReikaJavaLibrary.getClassBytes(c));
    }

    public static void printClassSource(Class c) {
        ReikaJavaLibrary.printClassSource(c.getName(), ReikaJavaLibrary.getClassBytes(c));
    }

    public static byte[] getClassBytes(Class c) {
        String className = c.getName();
        String classAsPath = className.replace('.', '/') + ".class";
        InputStream stream = c.getClassLoader().getResourceAsStream(classAsPath);
        try {
            return IOUtils.toByteArray((InputStream)stream);
        }
        catch (IOException e) {
            ReikaJavaLibrary.pConsole("DRAGONAPI: Error converting class to byte[]!");
            e.printStackTrace();
            return new byte[0];
        }
    }

    public static void printClassMetadata(String path, Class c) {
        String filename = "FailedClasses/" + path + ".classdata";
        File f = new File(filename);
        f.getParentFile().mkdirs();
        if (!ReikaJavaLibrary.printClassMetadata(f, c)) {
            ReikaJavaLibrary.pConsole("DRAGONAPI: Error printing class data!");
        }
    }

    private static boolean printClassMetadata(File f, Class c) {
        ArrayList<String> li = new ArrayList<String>();
        ReikaJavaLibrary.printClassMetadata(li, c);
        return ReikaFileReader.writeLinesToFile(f, li, true, Charsets.UTF_8);
    }

    private static void printClassMetadata(ArrayList<String> li, Class c) {
        try {
            li.add("General:");
            li.add("\t" + c.getName());
            li.add("\tAnnotations: " + Arrays.toString(c.getAnnotations()));
            li.add("\tModifiers: " + ReikaJavaLibrary.parseModifiers(c.getModifiers()));
            li.add("\tSuperclass: " + c.getSuperclass());
            li.add("\tInterfaces: " + Arrays.toString(c.getInterfaces()));
            li.add("\tSynthetic: " + c.isSynthetic());
            li.add("");
        }
        catch (Throwable t) {
            li.add("ERRORED ROOT DATA");
            t.printStackTrace();
        }
        try {
            li.add("Internal Classes:");
            for (GenericDeclaration genericDeclaration : c.getDeclaredClasses()) {
                try {
                    li.add("-------------------------");
                    ReikaJavaLibrary.printClassMetadata(li, (Class)genericDeclaration);
                    li.add("-------------------------");
                }
                catch (Throwable t) {
                    li.add("ERRORED INTERNAL CLASS");
                    t.printStackTrace();
                }
            }
            li.add("");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        try {
            li.add("Constructors:");
            for (AnnotatedElement annotatedElement : c.getDeclaredConstructors()) {
                try {
                    li.add("\t\tAnnotations: " + Arrays.toString(((AccessibleObject)annotatedElement).getAnnotations()));
                    li.add("\t\tModifiers: " + ReikaJavaLibrary.parseModifiers(((Constructor)annotatedElement).getModifiers()));
                    li.add("\t\tSignature: " + Arrays.toString(((Constructor)annotatedElement).getParameterTypes()));
                    li.add("\t\tExceptions: " + Arrays.toString(((Constructor)annotatedElement).getExceptionTypes()));
                    li.add("\t\tSynthetic: " + ((Constructor)annotatedElement).isSynthetic() + "");
                }
                catch (Throwable t) {
                    li.add("ERRORED CONSTRUCTOR");
                    t.printStackTrace();
                }
            }
            li.add("");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        try {
            li.add("Fields:");
            for (AnnotatedElement annotatedElement : c.getDeclaredFields()) {
                try {
                    li.add("\t" + ((Field)annotatedElement).getName());
                    li.add("\t\tAnnotations: " + Arrays.toString(((AccessibleObject)annotatedElement).getAnnotations()));
                    li.add("\t\tModifiers: " + ReikaJavaLibrary.parseModifiers(((Field)annotatedElement).getModifiers()));
                    li.add("\t\tType: " + ((Field)annotatedElement).getType());
                    li.add("\t\tSynthetic: " + ((Field)annotatedElement).isSynthetic() + "");
                }
                catch (Throwable t) {
                    li.add("ERRORED FIELD");
                    t.printStackTrace();
                }
            }
            li.add("");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        try {
            li.add("Methods:");
            for (AnnotatedElement annotatedElement : c.getDeclaredMethods()) {
                try {
                    li.add("\t" + ((Method)annotatedElement).getName());
                    li.add("\t\tAnnotations: " + Arrays.toString(((AccessibleObject)annotatedElement).getAnnotations()));
                    li.add("\t\tModifiers: " + ReikaJavaLibrary.parseModifiers(((Method)annotatedElement).getModifiers()));
                    li.add("\t\tSignature: " + Arrays.toString(((Method)annotatedElement).getParameterTypes()));
                    li.add("\t\tExceptions: " + Arrays.toString(((Method)annotatedElement).getExceptionTypes()));
                    li.add("\t\tReturn: " + ((Method)annotatedElement).getReturnType());
                    li.add("\t\tSynthetic: " + ((Method)annotatedElement).isSynthetic() + "");
                }
                catch (Throwable t) {
                    li.add("ERRORED METHOD");
                    t.printStackTrace();
                }
            }
            li.add("");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static String parseModifiers(int modifiers) {
        ArrayList<String> params = new ArrayList<String>();
        for (ClassModifiers mod : ClassModifiers.values()) {
            if (!mod.match(modifiers)) continue;
            params.add(mod.toString());
        }
        return params.toString();
    }

    public static boolean printClassASM(String path, byte[] data) {
        ClassReader reader = new ClassReader(data);
        ClassNode classNode = new ClassNode();
        reader.accept((ClassVisitor)classNode, 0);
        List methods = classNode.methods;
        String filename = path + ".asm";
        File f = new File(filename);
        ArrayList<String> p = new ArrayList<String>();
        for (MethodNode m : methods) {
            InsnList inList = m.instructions;
            p.add(m.name);
            for (int i = 0; i < inList.size(); ++i) {
                p.add(ReikaASMHelper.clearString(inList.get(i)));
            }
        }
        return ReikaFileReader.writeLinesToFile(f, p, true, Charsets.UTF_8);
    }

    public static void printClassSource(String path, byte[] data) {
        String filename = path + ".class";
        try (FileOutputStream fos = new FileOutputStream(filename);){
            fos.write(data);
        }
        catch (IOException e) {
            ReikaJavaLibrary.pConsole("DRAGONAPI: Error printing class!");
            e.printStackTrace();
        }
    }

    public static void initClassWithSubs(Class c, boolean errorIfFail) {
        ReikaJavaLibrary.initClass(c, errorIfFail);
        for (Class<?> c2 : c.getDeclaredClasses()) {
            ReikaJavaLibrary.initClass(c2, errorIfFail);
        }
    }

    public static boolean listContainsArray(List<int[]> li, int[] arr) {
        for (int i = 0; i < li.size(); ++i) {
            if (!Arrays.equals(li.get(i), arr)) continue;
            return true;
        }
        return false;
    }

    public static int getEnumLengthWithoutInitializing(Class<? extends Enum> c) {
        Field[] q = c.getFields();
        int count = 0;
        for (int i = 0; i < q.length; ++i) {
            Field f = q[i];
            if (!f.isEnumConstant()) continue;
            ++count;
        }
        return count;
    }

    public static ArrayList<String> getEnumEntriesWithoutInitializing(Class<? extends Enum> c) {
        ArrayList<String> li = new ArrayList<String>();
        Field[] q = c.getFields();
        for (int i = 0; i < q.length; ++i) {
            Field f = q[i];
            if (!f.isEnumConstant()) continue;
            li.add(f.getName());
        }
        return li;
    }

    public static int getMaximumRecursiveDepth() {
        if (maxRecurse <= 0) {
            ReikaJavaLibrary.recurse(0);
        }
        return maxRecurse;
    }

    private static int recurse(int i) {
        maxRecurse = Math.max(i, maxRecurse);
        try {
            ReikaJavaLibrary.recurse(i + 1);
        }
        catch (StackOverflowError e) {
            return i;
        }
        return 0;
    }

    public static void toggleStackTrace() {
        dumpStack = !dumpStack;
    }

    public static void toggleSilentMode() {
        silent = !silent;
    }

    public static Class[] getObjectClasses(Object ... objs) {
        Class[] c = new Class[objs.length];
        for (int i = 0; i < c.length; ++i) {
            c[i] = ReikaJavaLibrary.getClassOf(objs[i]);
        }
        return c;
    }

    public static Class getClassOf(Object o) {
        Class<?> p = ReikaJavaLibrary.getPrimitiveClass(o);
        return p != null ? p : o.getClass();
    }

    private static Class getPrimitiveClass(Object o) {
        String name = o.getClass().getSimpleName().toLowerCase(Locale.ENGLISH);
        if (name.equals("byte")) {
            return Byte.TYPE;
        }
        if (name.equals("short")) {
            return Short.TYPE;
        }
        if (name.equals("int")) {
            return Integer.TYPE;
        }
        if (name.equals("integer")) {
            return Integer.TYPE;
        }
        if (name.equals("long")) {
            return Long.TYPE;
        }
        if (name.equals("char")) {
            return Character.TYPE;
        }
        if (name.equals("character")) {
            return Character.TYPE;
        }
        if (name.equals("float")) {
            return Float.TYPE;
        }
        if (name.equals("double")) {
            return Double.TYPE;
        }
        if (name.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (name.equals("void")) {
            return Void.TYPE;
        }
        return null;
    }

    public static <K, T> boolean collectionMapContainsValue(Map<K, Collection<T>> map, T value) {
        for (Collection<T> c : map.values()) {
            if (c == null || !c.contains(value)) continue;
            return true;
        }
        return false;
    }

    public static byte[] streamToBytes(InputStream in) {
        ArrayList<Byte> li = new ArrayList<Byte>();
        try {
            int ret = in.read();
            while (ReikaMathLibrary.isValueInsideBoundsIncl(0, 255, ret)) {
                li.add((byte)ret);
                ret = in.read();
            }
            byte[] arr = new byte[li.size()];
            for (int i = 0; i < li.size(); ++i) {
                arr[i] = (Byte)li.get(i);
            }
            return arr;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <I, O> Collection<O> getConstructedCollection(Collection<I> inputs, Class<I> ci, Class<O> co) {
        try {
            return ReikaJavaLibrary.getConstructedCollection(inputs, co.getConstructor(ci));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <I, O> Collection<O> getConstructedCollection(Collection<I> inputs, Constructor<O> c) {
        ArrayList<O> outputs = new ArrayList<O>();
        try {
            for (I in : inputs) {
                O out = c.newInstance(in);
                outputs.add(out);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return outputs;
    }

    public static HashMap sortMapByValues(HashMap map) {
        LinkedList list = new LinkedList(map.entrySet());
        Collections.sort(list, new MapValueSorter());
        LinkedHashMap sortedHashMap = new LinkedHashMap();
        for (Map.Entry entry : list) {
            sortedHashMap.put(entry.getKey(), entry.getValue());
        }
        return sortedHashMap;
    }

    public static <E> E[] collectionToArray(Collection<E> li) {
        Object[] arr = new Object[li.size()];
        int i = 0;
        for (E ps : li) {
            arr[i] = ps;
            ++i;
        }
        return arr;
    }

    public static <E> E getRandomListEntry(Random rand, List<E> li) {
        return li.isEmpty() ? null : (E)li.get(rand.nextInt(li.size()));
    }

    public static <E> E getRandomCollectionEntry(Random rand, Collection<E> c) {
        return c.isEmpty() ? null : (c instanceof List ? (E)ReikaJavaLibrary.getRandomListEntry(rand, (List)c) : (E)ReikaJavaLibrary.getRandomListEntry(rand, new ArrayList<E>(c)));
    }

    public static <E> E getAndRemoveRandomCollectionEntry(Random rand, Collection<E> c) {
        if (c instanceof List) {
            return ((List)c).remove(rand.nextInt(c.size()));
        }
        E val = ReikaJavaLibrary.getRandomCollectionEntry(rand, c);
        c.remove(val);
        return val;
    }

    public static String getTopLevelPackage(Class c) {
        String n = c.getName();
        return n.substring(0, n.indexOf(46));
    }

    public static <E> Collection<E> getCompoundCollection(Collection<Collection<E>> colls) {
        ArrayList<E> c = new ArrayList<E>();
        for (Collection<E> c2 : colls) {
            c.addAll(c2);
        }
        return c;
    }

    public static boolean isAnyModLoaded(ModList[] mods) {
        for (int i = 0; i < mods.length; ++i) {
            if (!mods[i].isLoaded()) continue;
            return true;
        }
        return false;
    }

    public static boolean removeValuesFromMap(Map map, Object value) {
        boolean flag = false;
        while (map.values().contains(value)) {
            flag |= map.values().remove(value);
        }
        return flag;
    }

    public static int getNestedMapSize(Map map) {
        int s = 0;
        for (Object k : map.keySet()) {
            Object o = map.get(k);
            s += o instanceof Map ? ((Map)o).size() : 1;
        }
        return s;
    }

    public static <V> Collection<V> getValuesForMapOfMaps(Map<?, Map<?, V>> map) {
        ArrayList<V> li = new ArrayList<V>();
        for (Object k : map.keySet()) {
            Map<?, V> o = map.get(k);
            li.addAll(o.values());
        }
        return li;
    }

    public static <E> Collection<E> getValuesForMapOfCollections(Map<?, Collection<E>> map) {
        ArrayList<E> li = new ArrayList<E>();
        for (Object k : map.keySet()) {
            Collection<E> o = map.get(k);
            li.addAll(o);
        }
        return li;
    }

    public static void cycleList(List li, int n) {
        if (li.isEmpty()) {
            return;
        }
        boolean neg = n < 0;
        n = Math.abs(n);
        for (int i = 0; i < n; ++i) {
            Object o;
            if (neg) {
                o = li.remove(0);
                li.add(o);
                continue;
            }
            o = li.remove(li.size() - 1);
            li.add(0, o);
        }
    }

    public static void cycleLinkedList(LinkedList li, int n) {
        if (li.isEmpty()) {
            return;
        }
        boolean neg = n < 0;
        n = Math.abs(n);
        for (int i = 0; i < n; ++i) {
            Object o;
            if (neg) {
                o = li.removeFirst();
                li.addLast(o);
                continue;
            }
            o = li.removeLast();
            li.addFirst(o);
        }
    }

    public static <V> Collection<V> combineCollections(Collection<V> ... colls) {
        ArrayList<V> ret = new ArrayList<V>();
        for (int i = 0; i < colls.length; ++i) {
            ret.addAll(colls[i]);
        }
        return ret;
    }

    public static <E> Set<E> getSet(E ... elements) {
        return new HashSet<E>(Arrays.asList(elements));
    }

    public static Thread getThreadByName(String name) {
        ThreadGroup tg = ReikaJavaLibrary.getTopLevelThreadGroup();
        Thread[] all = new Thread[tg.activeCount()];
        tg.enumerate(all, true);
        for (int i = 0; i < all.length; ++i) {
            Thread t = all[i];
            String n = t.getName();
            if (n == null || !n.equals(name)) continue;
            return t;
        }
        return null;
    }

    public static ThreadGroup getTopLevelThreadGroup() {
        ThreadGroup tg = Thread.currentThread().getThreadGroup();
        while (tg.getParent() != null) {
            tg = tg.getParent();
        }
        return tg;
    }

    public static boolean exceptionMentions(Throwable e, Class c) {
        StackTraceElement[] arr = e.getStackTrace();
        for (int i = 0; i < arr.length; ++i) {
            if (!arr[i].getClassName().equals(c.getName())) continue;
            return true;
        }
        return false;
    }

    public static <K> void subtractFromIntMap(Map<K, Integer> map, K key, int num) {
        Integer get = map.get(key);
        int ret = (get != null ? get : 0) - num;
        map.put(key, ret);
    }

    public static <K> void addToIntMap(Map<K, Integer> map, K key, int num) {
        Integer get = map.get(key);
        int ret = (get != null ? get : 0) + num;
        map.put(key, ret);
    }

    public static Collection<Class> getAllClassesFromPackage(String pack, Class parent, boolean skipAbstract, boolean skipDeprecated) throws IOException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        ArrayList<Class> li = new ArrayList<Class>();
        for (ClassPath.ClassInfo info : ClassPath.from((ClassLoader)loader).getTopLevelClasses()) {
            if (!info.getName().startsWith(pack)) continue;
            Class c = info.load();
            if (parent != null && !parent.isAssignableFrom(c) || skipAbstract && (c.getModifiers() & 0x400) != 0 || skipDeprecated && c.isAnnotationPresent(Deprecated.class)) continue;
            li.add(c);
        }
        return li;
    }

    public static char getIDChar(int id) {
        return IDChars[id % IDChars.length];
    }

    public static int[] splitLong(long val) {
        int l1 = (int)(val >>> 32);
        int l2 = (int)(val & 0xFFFFFFFFL);
        return new int[]{l1, l2};
    }

    public static long buildLong(int l1, int l2) {
        return (long)l1 << 32 | (long)l2 & 0xFFFFFFFFL;
    }

    public static byte[] splitInt(int val) {
        byte[] ret = new byte[]{(byte)(val & 0xFF), (byte)(val >>> 8 & 0xFF), (byte)(val >>> 16 & 0xFF), (byte)(val >>> 24 & 0xFF)};
        return ret;
    }

    public static int buildInt(byte b1, byte b2, byte b3, byte b4) {
        return b1 & 0xFF | (b2 & 0xFF) << 8 | (b3 & 0xFF) << 16 | (b4 & 0xFF) << 24;
    }

    public static String getClassLocation(Class c) {
        String ret = c.getResource(c.getSimpleName() + ".class").toString();
        ret = ret.substring("file:\\".length());
        ret = ret.replaceAll("%20", " ");
        return ret;
    }

    public static double buildDoubleFromInts(int i1, int i2) {
        return Double.longBitsToDouble(ReikaJavaLibrary.buildLong(i1, i2));
    }

    public static int[] splitDoubleToInts(double val) {
        return ReikaJavaLibrary.splitLong(Double.doubleToRawLongBits(val));
    }

    public static byte[] splitIntToHexChars(int val) {
        byte[] arr = new byte[8];
        for (int i = 0; i < 8; ++i) {
            byte hex;
            arr[i] = hex = (byte)(val >> i * 4 & 0xF);
        }
        return arr;
    }

    public static int buildIntFromHexChars(byte[] chars) {
        if (chars.length != 8) {
            throw new MisuseException("You cannot build an int from less than or more than 8 nibbles!");
        }
        int val = 0;
        for (int i = 0; i < 8; ++i) {
            val |= chars[i] << i * 4;
        }
        return val;
    }

    public static <V> ArrayList<V> makeSortedListFromCollection(Collection<V> c, Class baseElementType) {
        ArrayList<V> li = new ArrayList<V>(c);
        if (!li.isEmpty()) {
            Collections.sort(li, new FallbackComparator(baseElementType));
        }
        return li;
    }

    public static byte flipBits(byte get) {
        return (byte)(Integer.reverse(get) >>> 24);
    }

    public static <K, V> HashMap<K, V> makeMapOf(K key, V val) {
        HashMap<K, V> map = new HashMap<K, V>();
        map.put(key, val);
        return map;
    }

    public static <E> Collection<E> cloneCollectionObjects(Collection<E> c, CloneCallback<E> call) {
        ArrayList<E> ret = new ArrayList<E>();
        for (E o : c) {
            ret.add(call.clone(o));
        }
        return ret;
    }

    public static <E> boolean collectionsHaveSameValues(Collection<E> c1, Collection<E> c2) {
        return new HashSet<E>(c1).equals(new HashSet<E>(c2));
    }

    public static Object copyObject(Object o) {
        if (o instanceof Object[]) {
            return ReikaArrayHelper.deepCopyArray((Object[])o);
        }
        if (o instanceof ArrayList) {
            return new ArrayList((ArrayList)o);
        }
        if (o instanceof LinkedList) {
            return new LinkedList((LinkedList)o);
        }
        if (o instanceof HashMap) {
            return new HashMap((HashMap)o);
        }
        if (o instanceof TreeMap) {
            return new TreeMap((TreeMap)o);
        }
        if (o instanceof HashSet) {
            return new HashSet((HashSet)o);
        }
        if (o instanceof Map) {
            return new HashMap((Map)o);
        }
        if (o instanceof Collection) {
            return new ArrayList((Collection)o);
        }
        if (o instanceof ItemStack) {
            return ((ItemStack)o).func_77946_l();
        }
        return o;
    }

    public static String getPackageName(Class c) {
        String name = c.getName();
        int idx = name.lastIndexOf(46);
        return name.substring(0, idx);
    }

    public static String getEnumNameList(Class<? extends Enum> e) {
        StringBuilder sb = new StringBuilder();
        Enum[] list = e.getEnumConstants();
        for (int i = 0; i < list.length; ++i) {
            Enum loc = list[i];
            sb.append(loc.name());
            if (i >= list.length - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public static <E extends Enum> EnumSet getConditionalEnumSet(Class<E> cl, Predicate<E> filter) {
        EnumSet<Enum> set = EnumSet.noneOf(cl);
        for (Enum e : (Enum[])cl.getEnumConstants()) {
            if (!filter.test(e)) continue;
            set.add(e);
        }
        return set;
    }

    public static <E> void removeDuplicates(Collection<E> li) {
        HashSet<E> encountered = new HashSet<E>();
        Iterator<E> it = li.iterator();
        while (it.hasNext()) {
            E e = it.next();
            if (encountered.contains(e)) {
                it.remove();
                continue;
            }
            encountered.add(e);
        }
    }

    public static <K> Function<K, Double> createConstFunction(double val) {
        return key -> val;
    }

    public static interface CloneCallback<E> {
        public E clone(E var1);
    }

    private static class FallbackComparator
    implements Comparator {
        private final boolean useDefaultCompare;

        private FallbackComparator(Class test) {
            this.useDefaultCompare = Comparable.class.isAssignableFrom(test);
        }

        public int compare(Object o1, Object o2) {
            if (this.useDefaultCompare) {
                return ((Comparable)o1).compareTo(o2);
            }
            return Integer.compare(o1.hashCode(), o2.hashCode());
        }
    }

    private static class MapValueSorter<V>
    implements Comparator<Map.Entry<V, Comparable>> {
        private MapValueSorter() {
        }

        @Override
        public int compare(Map.Entry<V, Comparable> o1, Map.Entry<V, Comparable> o2) {
            return o1.getValue().compareTo(o2.getValue());
        }
    }
}

