/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Libraries.Java;

import Reika.DragonAPI.Exception.VanillaIntegrityException;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.client.resources.AbstractResourcePack;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.potion.Potion;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraftforge.classloading.FMLForgePlugin;
import net.minecraftforge.common.ForgeHooks;

public class ReikaObfuscationHelper {
    private static final boolean deobf = ReikaObfuscationHelper.testDeobf();
    private static final HashMap<String, Method> methods = new HashMap();
    private static final HashMap<String, Field> fields = new HashMap();
    private static final HashMap<String, Class> classes = new HashMap();
    private static final HashMap<String, String> labels = new HashMap();
    private static final HashSet<ReflectiveAccessExceptionHandler> errorHandlers = new HashSet();

    private static boolean testDeobf() {
        return !FMLForgePlugin.RUNTIME_DEOBF;
    }

    public static void registerExceptionHandler(ReflectiveAccessExceptionHandler h) {
        errorHandlers.add(h);
    }

    public static boolean isDeObfEnvironment() {
        return deobf;
    }

    private static Field getField(String deobf) {
        return fields.get(deobf);
    }

    private static Method getMethod(String deobf) {
        return methods.get(deobf);
    }

    public static Object get(String field, Object ref) {
        try {
            return ReikaObfuscationHelper.getField(field).get(ref);
        }
        catch (Exception e) {
            ReikaObfuscationHelper.handleException(e);
            return null;
        }
    }

    public static void set(String method, Object ref, Object val) {
        try {
            ReikaObfuscationHelper.getField(method).set(ref, val);
        }
        catch (Exception e) {
            ReikaObfuscationHelper.handleException(e);
        }
    }

    public static Object invoke(String method, Object ref, Object ... args) {
        try {
            return ReikaObfuscationHelper.getMethod(method).invoke(ref, args);
        }
        catch (Exception e) {
            ReikaObfuscationHelper.handleException(e);
            return null;
        }
    }

    private static void handleException(Exception e) {
        boolean print = true;
        for (ReflectiveAccessExceptionHandler h : errorHandlers) {
            print &= h.handleException(e);
        }
        if (print) {
            e.printStackTrace();
        }
    }

    public static String getLabelName(String deobf) {
        String sg = labels.get(deobf);
        if (sg == null) {
            throw new IllegalArgumentException("Tried to get obfuscated name for non-mapped deobf field/method " + deobf + "!");
        }
        if (ReikaObfuscationHelper.isDeObfEnvironment()) {
            return deobf;
        }
        return sg;
    }

    private static void addClass(String key, String n) {
        try {
            Class<?> c = Class.forName(n);
            classes.put(key, c);
            ReikaJavaLibrary.pConsole("DRAGONAPI: Registering reflexive field access to class " + c);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Tried to register nonexistent class " + n, e);
        }
    }

    private static void addField(String deobf, String obf, boolean isVisible, String k) {
        ReikaObfuscationHelper.addField(deobf, obf, isVisible, classes.get(k));
    }

    private static void addField(String deobf, String obf, boolean isVisible, Class c) {
        try {
            Field f;
            String sg;
            String string = sg = ReikaObfuscationHelper.isDeObfEnvironment() ? deobf : obf;
            if (isVisible) {
                f = c.getField(sg);
            } else {
                f = c.getDeclaredField(sg);
                f.setAccessible(true);
            }
            fields.put(deobf, f);
            labels.put(deobf, obf);
            ReikaJavaLibrary.pConsole("DRAGONAPI: Registering reflexive field access to " + c + "." + deobf + " (obfuscated as " + obf + ")");
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException("Tried to register nonexistent field " + deobf + "/" + obf, e);
        }
    }

    private static void addMethod(String deobf, String obf, boolean isVisible, Class c, Class ... args) {
        try {
            Method m;
            String sg;
            String string = sg = ReikaObfuscationHelper.isDeObfEnvironment() ? deobf : obf;
            if (isVisible) {
                m = c.getMethod(sg, args);
            } else {
                m = c.getDeclaredMethod(sg, args);
                m.setAccessible(true);
            }
            methods.put(deobf, m);
            labels.put(deobf, obf);
            ReikaJavaLibrary.pConsole("DRAGONAPI: Registering reflexive method access to " + c + "." + deobf + " (obfuscated as " + obf + ")");
        }
        catch (NoSuchMethodException e) {
            throw new VanillaIntegrityException(deobf, c, args);
        }
    }

    private static boolean isClientSide() {
        return FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT;
    }

    static {
        ReikaObfuscationHelper.addClass("SeedEntry", ForgeHooks.class.getName() + "$SeedEntry");
        ReikaObfuscationHelper.addMethod("dropFewItems", "func_70628_a", false, EntityLivingBase.class, Boolean.TYPE, Integer.TYPE);
        ReikaObfuscationHelper.addMethod("dropEquipment", "func_82160_b", false, EntityLivingBase.class, Boolean.TYPE, Integer.TYPE);
        ReikaObfuscationHelper.addMethod("dropRareDrop", "func_70600_l", false, EntityLivingBase.class, Integer.TYPE);
        ReikaObfuscationHelper.addMethod("jump", "func_70664_aZ", false, EntityLivingBase.class, new Class[0]);
        ReikaObfuscationHelper.addMethod("getHurtSound", "func_70621_aR", false, EntityLivingBase.class, new Class[0]);
        ReikaObfuscationHelper.addMethod("canSpawnStructureAtCoords", "func_75047_a", false, MapGenStructure.class, Integer.TYPE, Integer.TYPE);
        ReikaObfuscationHelper.addMethod("getCoordList", "func_75052_o_", false, MapGenStructure.class, new Class[0]);
        ReikaObfuscationHelper.addMethod("tryExtend", "func_150079_i", false, BlockPistonBase.class, World.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
        ReikaObfuscationHelper.addMethod("createStackedBlock", "func_149644_j", false, Block.class, Integer.TYPE);
        if (ReikaObfuscationHelper.isClientSide()) {
            ReikaObfuscationHelper.addMethod("getInputStreamByName", "func_110591_a", false, AbstractResourcePack.class, String.class);
        }
        ReikaObfuscationHelper.addField("potionTypes", "field_76425_a", true, Potion.class);
        ReikaObfuscationHelper.addField("harvesters", "harvesters", false, Block.class);
        ReikaObfuscationHelper.addField("seedList", "seedList", false, ForgeHooks.class);
        ReikaObfuscationHelper.addField("seed", "seed", false, "SeedEntry");
        if (ReikaObfuscationHelper.isClientSide()) {
            // empty if block
        }
    }

    public static interface ReflectiveAccessExceptionHandler {
        public boolean handleException(Exception var1);
    }
}

