/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Libraries.Java;

import Reika.DragonAPI.DragonAPICore;
import java.util.Arrays;

public class SemanticVersionParser {
    public static int compareVersions(String v1, String v2) {
        return new SemanticVersion(v1).compareTo(new SemanticVersion(v2));
    }

    public static boolean isVersionAtLeast(String v1, String v2) {
        return SemanticVersionParser.compareVersions(v1, v2) >= 0;
    }

    public static boolean isVersionAtMost(String v1, String v2) {
        return SemanticVersionParser.compareVersions(v1, v2) <= 0;
    }

    public static SemanticVersion getVersion(String s) {
        return new SemanticVersion(s);
    }

    public static class SemanticVersion
    implements Comparable<SemanticVersion> {
        private final int[] versions;

        private SemanticVersion(String s) {
            String[] parts = s.split("\\.");
            this.versions = new int[parts.length];
            try {
                for (int i = 0; i < parts.length; ++i) {
                    this.versions[i] = Integer.parseInt(parts[i]);
                }
            }
            catch (NumberFormatException e) {
                String err = "'" + s + "' is not a valid semantic version! Must have '#.#.#...' formatting!";
                DragonAPICore.logError("Error parsing a semantic version! " + err);
            }
        }

        @Override
        public int compareTo(SemanticVersion o) {
            for (int i = 0; i < this.versions.length; ++i) {
                int them;
                int us = this.versions[i];
                int n = them = o.versions.length > i ? o.versions[i] : 0;
                if (us == them) continue;
                return us - them;
            }
            return 0;
        }

        public int[] getVersions() {
            return Arrays.copyOf(this.versions, this.versions.length);
        }
    }
}

