/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Libraries.MathSci;

import Reika.DragonAPI.Instantiable.Interpolation;

public class GasPropertyCalculator {
    private static final double GAMMA_STANDARD = 1.4;
    public static final double Rair = 287.0;
    private static final Interpolation gammaCurve = new Interpolation(false);
    public static final double AIR_CP = 1.007;
    public static final double AIR_CV = 0.7192;

    public static double getPressure(double rho, double t) {
        return 287.0 * rho * t;
    }

    public static double getDensity(double p, double t) {
        return p / (287.0 * t);
    }

    public static double getGamma(double temp) {
        return gammaCurve.getValue(temp);
    }

    public static double getGammaMinusOneOverTwo(double temp) {
        return (GasPropertyCalculator.getGamma(temp) - 1.0) / 2.0;
    }

    public static double getGammaMinusOneOverGamma(double temp) {
        return (GasPropertyCalculator.getGamma(temp) - 1.0) / GasPropertyCalculator.getGamma(temp);
    }

    public static double getGammaOverGammaMinusOne(double temp) {
        return GasPropertyCalculator.getGamma(temp) / (GasPropertyCalculator.getGamma(temp) - 1.0);
    }

    static {
        gammaCurve.addPoint(250.0, 1.401);
        gammaCurve.addPoint(300.0, 1.4);
        gammaCurve.addPoint(350.0, 1.398);
        gammaCurve.addPoint(400.0, 1.395);
        gammaCurve.addPoint(450.0, 1.391);
        gammaCurve.addPoint(500.0, 1.387);
        gammaCurve.addPoint(550.0, 1.381);
        gammaCurve.addPoint(600.0, 1.376);
        gammaCurve.addPoint(650.0, 1.37);
        gammaCurve.addPoint(700.0, 1.364);
        gammaCurve.addPoint(750.0, 1.359);
        gammaCurve.addPoint(800.0, 1.354);
        gammaCurve.addPoint(900.0, 1.344);
        gammaCurve.addPoint(1000.0, 1.336);
        gammaCurve.addPoint(1100.0, 1.331);
        gammaCurve.addPoint(1200.0, 1.324);
        gammaCurve.addPoint(1300.0, 1.318);
        gammaCurve.addPoint(1400.0, 1.313);
        gammaCurve.addPoint(1500.0, 1.309);
    }
}

