/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Libraries.Registry;

import Reika.DragonAPI.Base.BlockCustomLeaf;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockBox;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.Maps.BlockMap;
import Reika.DragonAPI.Interfaces.Registry.TreeType;
import Reika.DragonAPI.Libraries.Java.ReikaStringParser;
import Reika.DragonAPI.ModRegistry.ModWoodList;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public enum ReikaTreeHelper implements TreeType
{
    OAK(Blocks.field_150364_r, (Block)Blocks.field_150362_t, Blocks.field_150345_g, new int[]{0, 4, 8, 12}, new int[]{0, 4, 8, 12}, 0),
    SPRUCE(Blocks.field_150364_r, (Block)Blocks.field_150362_t, Blocks.field_150345_g, new int[]{1, 5, 9, 13}, new int[]{1, 5, 9, 13}, 1),
    BIRCH(Blocks.field_150364_r, (Block)Blocks.field_150362_t, Blocks.field_150345_g, new int[]{2, 6, 10, 14}, new int[]{2, 6, 10, 14}, 2),
    JUNGLE(Blocks.field_150364_r, (Block)Blocks.field_150362_t, Blocks.field_150345_g, new int[]{3, 7, 11, 15}, new int[]{3, 7, 11, 15}, 3),
    ACACIA(Blocks.field_150363_s, (Block)Blocks.field_150361_u, Blocks.field_150345_g, new int[]{0, 4, 8, 12}, new int[]{0, 4, 8, 12}, 4),
    DARKOAK(Blocks.field_150363_s, (Block)Blocks.field_150361_u, Blocks.field_150345_g, new int[]{1, 5, 9, 13}, new int[]{1, 5, 9, 13}, 5);

    private int[] leafMeta;
    private int[] logMeta;
    private int saplingMeta;
    private Block leaf;
    private Block log;
    private Block sapling;
    public static final ReikaTreeHelper[] treeList;
    private static final BlockMap<ReikaTreeHelper> logMappings;
    private static final BlockMap<ReikaTreeHelper> leafMappings;
    private static final BlockMap<ReikaTreeHelper> saplingMappings;
    public static final int TREE_MIN_LOG = 2;
    public static final int TREE_MIN_LEAF = 5;

    private ReikaTreeHelper(Block wood, Block leaves, Block tree, int[] logmeta, int[] leafmeta, int saplingmeta) {
        this.log = wood;
        this.leaf = leaves;
        this.sapling = tree;
        this.logMeta = new int[logmeta.length];
        System.arraycopy(logmeta, 0, this.logMeta, 0, logmeta.length);
        this.leafMeta = new int[leafmeta.length];
        System.arraycopy(leafmeta, 0, this.leafMeta, 0, leafmeta.length);
        this.saplingMeta = saplingmeta;
    }

    public static ReikaTreeHelper getTree(Block id, int meta) {
        return logMappings.get(id, meta);
    }

    public static ReikaTreeHelper getTree(ItemStack wood) {
        return ReikaTreeHelper.getTree(Block.func_149634_a((Item)wood.func_77973_b()), wood.func_77960_j());
    }

    public static ReikaTreeHelper getTreeFromLeaf(Block id, int meta) {
        return leafMappings.get(id, meta);
    }

    public static ReikaTreeHelper getTreeFromLeaf(ItemStack leaf) {
        return ReikaTreeHelper.getTreeFromLeaf(Block.func_149634_a((Item)leaf.func_77973_b()), leaf.func_77960_j());
    }

    public static ReikaTreeHelper getTreeFromSapling(Block id, int meta) {
        return saplingMappings.get(id, meta);
    }

    public static ReikaTreeHelper getTreeFromSapling(ItemStack sapling) {
        return ReikaTreeHelper.getTreeFromSapling(Block.func_149634_a((Item)sapling.func_77973_b()), sapling.func_77960_j());
    }

    public boolean isTree(ItemStack wood) {
        return ReikaTreeHelper.getTree(wood) != null;
    }

    public boolean isTree(Block id, int meta) {
        return ReikaTreeHelper.getTree(id, meta) != null;
    }

    public boolean isTreeLeaf(ItemStack leaf) {
        return ReikaTreeHelper.getTreeFromLeaf(leaf) != null;
    }

    public boolean isTreeLeaf(Block id, int meta) {
        return ReikaTreeHelper.getTreeFromLeaf(id, meta) != null;
    }

    public boolean isTreeSapling(ItemStack sapling) {
        return ReikaTreeHelper.getTreeFromSapling(sapling) != null;
    }

    public boolean isTreeSapling(Block id, int meta) {
        return ReikaTreeHelper.getTreeFromSapling(id, meta) != null;
    }

    public BlockKey getLog() {
        return new BlockKey(this.log, this.logMeta[0]);
    }

    public BlockKey getLeaf() {
        return new BlockKey(this.leaf, this.leafMeta[0]);
    }

    public BlockKey getSapling() {
        return new BlockKey(this.sapling, this.saplingMeta);
    }

    public BlockKey getDamagedLog(int dmg) {
        return new BlockKey(this.log, this.logMeta[dmg]);
    }

    public BlockKey getDamagedLeaf(int dmg) {
        return new BlockKey(this.leaf, this.leafMeta[dmg]);
    }

    public int getBaseLeafMeta() {
        return this.leafMeta[0];
    }

    public String getName() {
        return ReikaStringParser.capFirstChar(this.name());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName());
        sb.append(" (LOG " + this.log + ":" + Arrays.toString(this.logMeta) + ";");
        sb.append(" ");
        sb.append("LEAF " + this.leaf + ":" + Arrays.toString(this.leafMeta) + ";");
        sb.append(" ");
        sb.append("SAPLING " + this.sapling + ":" + this.saplingMeta);
        sb.append(")");
        return sb.toString();
    }

    @Override
    public BlockKey getItem() {
        return new BlockKey(this.log, this.logMeta[0]);
    }

    @Override
    public BlockKey getBasicLeaf() {
        return new BlockKey(this.leaf, this.leafMeta[0]);
    }

    @Override
    public Block getLogID() {
        return this.log;
    }

    @Override
    public Block getLeafID() {
        return this.leaf;
    }

    @Override
    public Block getSaplingID() {
        return this.sapling;
    }

    public int getBaseLogMeta() {
        return this.logMeta[0];
    }

    public ArrayList<Integer> getLogMetadatas() {
        ArrayList<Integer> li = new ArrayList<Integer>();
        for (int i = 0; i < this.logMeta.length; ++i) {
            li.add(this.logMeta[i]);
        }
        return li;
    }

    public ArrayList<Integer> getLeafMetadatas() {
        ArrayList<Integer> li = new ArrayList<Integer>();
        for (int i = 0; i < this.leafMeta.length; ++i) {
            li.add(this.leafMeta[i]);
        }
        return li;
    }

    @Override
    public boolean canBePlacedSideways() {
        return true;
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public int getSaplingMeta() {
        return this.saplingMeta;
    }

    public static boolean isNaturalLeaf(World world, int x, int y, int z) {
        Block b = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        if (b instanceof BlockCustomLeaf) {
            return ((BlockCustomLeaf)b).isNatural();
        }
        ModWoodList mod = ModWoodList.getModWoodFromLeaf(b, meta);
        if (mod != null) {
            return mod.isNaturalLeaf(world, x, y, z);
        }
        if (b instanceof BlockLeaves) {
            return (meta & 4) == 0;
        }
        return true;
    }

    @Override
    public BlockBox getTypicalMaximumSize() {
        switch (this) {
            case ACACIA: {
                return BlockBox.origin().expand(9, 12, 9);
            }
            case BIRCH: {
                return BlockBox.origin().expand(5, 9, 5);
            }
            case DARKOAK: {
                return BlockBox.origin().expand(6, 11, 6);
            }
            case JUNGLE: {
                return BlockBox.origin().expand(10, 50, 10);
            }
            case OAK: {
                return BlockBox.origin().expand(15, 25, 15);
            }
            case SPRUCE: {
                return BlockBox.origin().expand(9, 40, 9);
            }
        }
        return BlockBox.nothing();
    }

    static {
        treeList = ReikaTreeHelper.values();
        logMappings = new BlockMap();
        leafMappings = new BlockMap();
        saplingMappings = new BlockMap();
        for (int i = 0; i < treeList.length; ++i) {
            int k;
            ReikaTreeHelper w = treeList[i];
            Block id = w.log;
            Block leaf = w.leaf;
            int[] metas = w.logMeta;
            int[] leafmetas = w.leafMeta;
            Block sapling = w.sapling;
            int saplingMeta = w.saplingMeta;
            for (k = 0; k < metas.length; ++k) {
                logMappings.put(id, metas[k], w);
            }
            for (k = 0; k < leafmetas.length; ++k) {
                leafMappings.put(leaf, leafmetas[k], w);
            }
            saplingMappings.put(sapling, saplingMeta, w);
        }
    }
}

