/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Libraries;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Maps.PluralMap;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Java.ReikaStringParser;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaPhysicsHelper;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ReikaDirectionHelper
extends DragonAPICore {
    public static ForgeDirection getLeftBy90(ForgeDirection dir) {
        switch (dir) {
            case EAST: {
                return ForgeDirection.NORTH;
            }
            case NORTH: {
                return ForgeDirection.WEST;
            }
            case SOUTH: {
                return ForgeDirection.EAST;
            }
            case WEST: {
                return ForgeDirection.SOUTH;
            }
        }
        return dir;
    }

    public static ForgeDirection getRightBy90(ForgeDirection dir) {
        switch (dir) {
            case EAST: {
                return ForgeDirection.SOUTH;
            }
            case NORTH: {
                return ForgeDirection.EAST;
            }
            case SOUTH: {
                return ForgeDirection.WEST;
            }
            case WEST: {
                return ForgeDirection.NORTH;
            }
        }
        return dir;
    }

    public static ForgeDirection getDirectionBetween(int x1, int y1, int z1, int x2, int y2, int z2) {
        int dx = x2 - x1;
        int dy = y2 - y1;
        int dz = z2 - z1;
        for (int i = 0; i < 6; ++i) {
            ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
            if (Math.signum(dir.offsetX) != Math.signum(dx) || Math.signum(dir.offsetY) != Math.signum(dy) || Math.signum(dir.offsetZ) != Math.signum(dz)) continue;
            return dir;
        }
        return null;
    }

    public static ForgeDirection getDirectionBetween(Coordinate c1, Coordinate c2) {
        return ReikaDirectionHelper.getDirectionBetween(c1.xCoord, c1.yCoord, c1.zCoord, c2.xCoord, c2.yCoord, c2.zCoord);
    }

    public static ForgeDirection getDirectionBetween(Point from, Point to) {
        return ReikaDirectionHelper.getDirectionBetween(from.x, 0, from.y, to.x, 0, to.y);
    }

    public static ArrayList<ForgeDirection> getPerpendicularDirections(ForgeDirection dir) {
        ArrayList<ForgeDirection> dirs = new ArrayList<ForgeDirection>();
        for (int i = 0; i < 6; ++i) {
            ForgeDirection d = ForgeDirection.VALID_DIRECTIONS[i];
            if (d == dir || d == dir.getOpposite()) continue;
            dirs.add(d);
        }
        dirs.remove(ForgeDirection.WEST);
        dirs.remove(ForgeDirection.NORTH);
        dirs.remove(ForgeDirection.DOWN);
        return dirs;
    }

    public static ForgeDirection getRandomDirection(boolean vertical, Random rand) {
        int idx = vertical ? rand.nextInt(6) : 2 + rand.nextInt(4);
        return ForgeDirection.VALID_DIRECTIONS[idx];
    }

    public static EnumFacing getOpposite(EnumFacing facing) {
        int val = facing.ordinal() % 2 != 0 ? facing.ordinal() - 1 : facing.ordinal() + 1;
        return EnumFacing.values()[val];
    }

    public static ForgeDirection getSideOfBox(int i, int j, int k, boolean vertical, int size) {
        if (i == size) {
            return ForgeDirection.EAST;
        }
        if (i == 0) {
            return ForgeDirection.WEST;
        }
        if (k == size) {
            return ForgeDirection.SOUTH;
        }
        if (k == 0) {
            return ForgeDirection.NORTH;
        }
        if (vertical && j == size) {
            return ForgeDirection.UP;
        }
        if (vertical && j == 0) {
            return ForgeDirection.DOWN;
        }
        return null;
    }

    public static int getRelativeAngle(ForgeDirection from, ForgeDirection to) {
        int rel = ReikaDirectionHelper.getHeading(to) - ReikaDirectionHelper.getHeading(from);
        return (360 + rel % 360) % 360;
    }

    public static int getHeading(ForgeDirection dir) {
        switch (dir) {
            case NORTH: {
                return 0;
            }
            case EAST: {
                return 90;
            }
            case SOUTH: {
                return 180;
            }
            case WEST: {
                return 270;
            }
        }
        return 0;
    }

    public static ForgeDirection getByHeading(double ang) {
        ang += 360.0;
        int a = (int)((ang %= 360.0) / 90.0);
        switch (a) {
            case 0: {
                return ForgeDirection.NORTH;
            }
            case 1: {
                return ForgeDirection.EAST;
            }
            case 2: {
                return ForgeDirection.SOUTH;
            }
            case 3: {
                return ForgeDirection.WEST;
            }
        }
        return ForgeDirection.UNKNOWN;
    }

    public static double getCompassHeading(double dx, double dz) {
        double phi = ReikaPhysicsHelper.cartesianToPolar(dx, 0.0, -dz)[2];
        return ((phi += 90.0) % 360.0 + 360.0) % 360.0;
    }

    public static ArrayList<ForgeDirection> getRandomOrderedDirections(boolean vertical) {
        ArrayList li = ReikaJavaLibrary.makeListFromArray(ForgeDirection.VALID_DIRECTIONS);
        if (!vertical) {
            li.remove(ForgeDirection.UP.ordinal());
            li.remove(ForgeDirection.DOWN.ordinal());
        }
        Collections.shuffle(li);
        return li;
    }

    public static ForgeDirection getImpactedSide(World world, int x, int y, int z, Entity e) {
        int dx = (int)Math.round((e.field_70165_t - (double)x - 0.5) * 2.0);
        int dz = (int)Math.round((e.field_70161_v - (double)z - 0.5) * 2.0);
        return ReikaDirectionHelper.getByDirection(dx, dz);
    }

    public static ForgeDirection getByDirection(int dx, int dz) {
        if (dx > 0) {
            return ForgeDirection.EAST;
        }
        if (dx < 0) {
            return ForgeDirection.WEST;
        }
        if (dz > 0) {
            return ForgeDirection.SOUTH;
        }
        if (dz < 0) {
            return ForgeDirection.NORTH;
        }
        return ForgeDirection.UNKNOWN;
    }

    public static HashSet<ForgeDirection> setDirections(boolean vertical) {
        HashSet<ForgeDirection> ret = new HashSet<ForgeDirection>();
        ret.add(ForgeDirection.EAST);
        ret.add(ForgeDirection.WEST);
        ret.add(ForgeDirection.NORTH);
        ret.add(ForgeDirection.SOUTH);
        if (vertical) {
            ret.add(ForgeDirection.UP);
            ret.add(ForgeDirection.DOWN);
        }
        return ret;
    }

    public static ForgeDirection getFromLookDirection(EntityLivingBase ep, boolean vertical) {
        if (!vertical || MathHelper.func_76135_e((float)ep.field_70125_A) < 60.0f) {
            int i;
            for (i = MathHelper.func_76128_c((double)((double)(ep.field_70177_z * 4.0f / 360.0f) + 0.5)); i > 3; i -= 4) {
            }
            while (i < 0) {
                i += 4;
            }
            switch (i) {
                case 0: {
                    return ForgeDirection.SOUTH;
                }
                case 1: {
                    return ForgeDirection.WEST;
                }
                case 2: {
                    return ForgeDirection.NORTH;
                }
                case 3: {
                    return ForgeDirection.EAST;
                }
            }
            return ForgeDirection.UNKNOWN;
        }
        if (ep.field_70125_A > 0.0f) {
            return ForgeDirection.DOWN;
        }
        return ForgeDirection.UP;
    }

    public static boolean arePerpendicular(ForgeDirection d1, ForgeDirection d2) {
        return !ReikaDirectionHelper.areCoaxial(d1, d2);
    }

    public static boolean areCoaxial(ForgeDirection d1, ForgeDirection d2) {
        if (d1.offsetX != 0) {
            return Math.abs(d1.offsetX) == Math.abs(d2.offsetX);
        }
        if (d1.offsetY != 0) {
            return Math.abs(d1.offsetY) == Math.abs(d2.offsetY);
        }
        if (d1.offsetZ != 0) {
            return Math.abs(d1.offsetZ) == Math.abs(d2.offsetZ);
        }
        return false;
    }

    public static ForgeDirection getApproximateDirection(int x, int y, int z, int x2, int y2, int z2, boolean vertical) {
        int dx = x2 - x;
        int dy = y2 - y;
        int dz = z2 - z;
        int magx = Math.abs(dx);
        int magy = Math.abs(dy);
        int magz = Math.abs(dz);
        if (vertical && magy > magz && magy > magz) {
            return dy > 0 ? ForgeDirection.UP : ForgeDirection.DOWN;
        }
        if (magx > magz) {
            return dx > 0 ? ForgeDirection.EAST : ForgeDirection.WEST;
        }
        return dz > 0 ? ForgeDirection.SOUTH : ForgeDirection.NORTH;
    }

    public static String getDirectionInfoAsString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 6; ++i) {
            sb.append(String.valueOf(i));
            sb.append(": ");
            sb.append(ReikaStringParser.capFirstChar(ForgeDirection.VALID_DIRECTIONS[i].name()));
            sb.append("\n");
        }
        return sb.toString();
    }

    public static enum FanDirections {
        N(0, -2, 90.0),
        NNE(1, -2, 67.5),
        NE(1, -1, 45.0),
        ENE(2, -1, 22.5),
        E(2, 0, 0.0),
        ESE(2, 1, 337.5),
        SE(1, 1, 315.0),
        SSE(1, 2, 292.5),
        S(0, 2, 270.0),
        SSW(-1, 2, 247.5),
        SW(-1, 1, 225.0),
        WSW(-2, 1, 202.5),
        W(-2, 0, 180.0),
        WNW(-2, -1, 157.5),
        NW(-1, -1, 135.0),
        NNW(-1, -2, 112.5);

        public final int directionX;
        public final int directionZ;
        public final int normalizedX;
        public final int normalizedZ;
        public final double offsetX;
        public final double offsetZ;
        public final double angle;
        public static final FanDirections[] list;
        private static final PluralMap<FanDirections> dirMap;
        private static final HashMap<Double, FanDirections> angleMap;

        private FanDirections(int x, int z, double a) {
            this.directionX = x;
            this.directionZ = z;
            this.normalizedX = z == 0 ? x : x / 2;
            this.normalizedZ = x == 0 ? z : z / 2;
            this.angle = a;
            this.offsetX = Math.cos(Math.toRadians(this.angle));
            this.offsetZ = Math.sin(Math.toRadians(this.angle));
        }

        public FanDirections getRotation(boolean clockwise) {
            return this.getRotation(clockwise, 1);
        }

        public FanDirections getRotation(boolean clockwise, int num) {
            int d = clockwise ? num : -num;
            return FanDirections.getShiftedIndex(this.ordinal(), d);
        }

        public FanDirections getOpposite() {
            return FanDirections.getShiftedIndex(this.ordinal(), 4);
        }

        private static FanDirections getShiftedIndex(int i, int d) {
            int o = ((i + d) % list.length + list.length) % list.length;
            return list[o];
        }

        public static FanDirections getFromVectors(int dx, int dz) {
            if (dx == 0 && Math.abs(dz) == 1) {
                dz *= 2;
            } else if (dz == 0 && Math.abs(dx) == 1) {
                dx *= 2;
            }
            return dirMap.get(dx, dz);
        }

        public static FanDirections getFromPlayerLook(EntityPlayer ep) {
            return FanDirections.getFromAngle(-ep.field_70759_as - 90.0f);
        }

        public static FanDirections getFromAngle(double angle) {
            angle = (angle + 360.0) % 360.0;
            angle = ReikaMathLibrary.roundToNearestFraction(angle, 22.5);
            angle = (angle + 360.0) % 360.0;
            return angleMap.get(angle);
        }

        public boolean isCardinal() {
            return this.directionX == 0 || this.directionZ == 0;
        }

        public boolean isOctagonal() {
            return this.name().length() <= 2;
        }

        static {
            list = FanDirections.values();
            dirMap = new PluralMap(2);
            angleMap = new HashMap();
            for (int i = 0; i < list.length; ++i) {
                dirMap.put(list[i], FanDirections.list[i].directionX, FanDirections.list[i].directionZ);
                angleMap.put(FanDirections.list[i].angle, list[i]);
            }
        }
    }

    public static enum CubeDirections {
        NORTH(0, -1, 90),
        NORTHEAST(1, -1, 45),
        EAST(1, 0, 0),
        SOUTHEAST(1, 1, 315),
        SOUTH(0, 1, 270),
        SOUTHWEST(-1, 1, 225),
        WEST(-1, 0, 180),
        NORTHWEST(-1, -1, 135);

        public final int directionX;
        public final int directionZ;
        public final double offsetX;
        public final double offsetZ;
        public final int angle;
        public final double projectionFactor;
        public static final CubeDirections[] list;
        private static final PluralMap<CubeDirections> dirMap;

        private CubeDirections(int x, int z, int a) {
            this.directionX = x;
            this.directionZ = z;
            this.angle = a;
            this.offsetX = Math.cos(Math.toRadians(this.angle));
            this.offsetZ = Math.sin(Math.toRadians(this.angle));
            this.projectionFactor = ReikaMathLibrary.py3d(this.directionX, 0.0, this.directionZ);
        }

        public CubeDirections getRotation(boolean clockwise) {
            return this.getRotation(clockwise, 1);
        }

        public CubeDirections getRotation(boolean clockwise, int num) {
            int d = clockwise ? num : -num;
            return CubeDirections.getShiftedIndex(this.ordinal(), d);
        }

        public CubeDirections getOpposite() {
            return CubeDirections.getShiftedIndex(this.ordinal(), 4);
        }

        private static CubeDirections getShiftedIndex(int i, int d) {
            int o = ((i + d) % list.length + list.length) % list.length;
            return list[o];
        }

        public static CubeDirections getFromVectors(double dx, double dz) {
            return dirMap.get((int)Math.signum(dx), (int)Math.signum(dz));
        }

        public boolean isCardinal() {
            return this.directionX == 0 || this.directionZ == 0;
        }

        public ForgeDirection getCardinal() {
            return this.isCardinal() ? ReikaDirectionHelper.getByDirection(this.directionX, this.directionZ) : null;
        }

        public static CubeDirections getFromForgeDirection(ForgeDirection dir) {
            return CubeDirections.getFromVectors(dir.offsetX, dir.offsetZ);
        }

        static {
            list = CubeDirections.values();
            dirMap = new PluralMap(2);
            for (int i = 0; i < list.length; ++i) {
                dirMap.put(list[i], CubeDirections.list[i].directionX, CubeDirections.list[i].directionZ);
            }
        }
    }
}

