/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Libraries.Rendering;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Exception.MisuseException;
import Reika.DragonAPI.IO.DelegateFontRenderer;
import Reika.DragonAPI.Instantiable.Data.Maps.RectangleMap;
import Reika.DragonAPI.Instantiable.Data.Maps.RegionMap;
import Reika.DragonAPI.Interfaces.WrappedRecipe;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.Java.ReikaGLHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.ReikaRecipeHelper;
import Reika.DragonAPI.Libraries.Rendering.ReikaColorAPI;
import Reika.DragonAPI.ModList;
import Reika.DragonAPI.Objects.LineType;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.potion.Potion;
import net.minecraft.util.MathHelper;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Rectangle;

@SideOnly(value=Side.CLIENT)
public final class ReikaGuiAPI
extends GuiScreen {
    private int xSize;
    private int ySize;
    public static int NEI_DEPTH = 0;
    public static final ReikaGuiAPI instance = new ReikaGuiAPI();
    private final RectangleMap<String> tooltips = new RectangleMap();
    private final RegionMap<ItemStack> items = new RegionMap();
    private final boolean cacheRenders = ModList.NEI.isLoaded();
    public static final RenderItem itemRenderer = new RenderItem();

    private ReikaGuiAPI() {
        this.field_146297_k = Minecraft.func_71410_x();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public int getScreenXInset() {
        return (this.field_146294_l - this.xSize) / 2;
    }

    public int getScreenYInset() {
        return (this.field_146295_m - this.ySize) / 2 - 8;
    }

    @SubscribeEvent
    public void preDrawScreen(GuiScreenEvent.DrawScreenEvent.Pre evt) {
        if (this.cacheRenders) {
            this.tooltips.clear();
            this.items.clear();
        }
    }

    public void drawCenteredStringNoShadow(FontRenderer par1FontRenderer, String par2Str, int par3, int par4, int par5) {
        par1FontRenderer.func_78276_b(par2Str, par3 - par1FontRenderer.func_78256_a(par2Str) / 2, par4, par5);
    }

    public void func_73733_a(int x1, int y1, int x2, int y2, int c1, int c2) {
        super.func_73733_a(x1, y1, x2, y2, c1, c2);
    }

    public void drawTexturedModalRectInvert(int x, int y, int u, int v, int w, int h, int scale) {
        y += this.ySize / 2;
        y -= scale;
        v -= scale;
        h = scale;
        float var7 = 0.00390625f;
        float var8 = 0.00390625f;
        Tessellator var9 = Tessellator.field_78398_a;
        if (var9.field_78415_z) {
            var9.func_78381_a();
        }
        var9.func_78382_b();
        var9.func_78374_a((double)(x + 0), (double)(y + h), (double)this.field_73735_i, (double)((float)(u + 0) * var7), (double)((float)(v + h) * var8));
        var9.func_78374_a((double)(x + w), (double)(y + h), (double)this.field_73735_i, (double)((float)(u + w) * var7), (double)((float)(v + h) * var8));
        var9.func_78374_a((double)(x + w), (double)(y + 0), (double)this.field_73735_i, (double)((float)(u + w) * var7), (double)((float)(v + 0) * var8));
        var9.func_78374_a((double)(x + 0), (double)(y + 0), (double)this.field_73735_i, (double)((float)(u + 0) * var7), (double)((float)(v + 0) * var8));
        var9.func_78381_a();
    }

    public void drawRect(int par1, int par2, int par3, int par4, int par5, boolean par6) {
        int var5;
        if (!par6) {
            par5 |= 0xFF000000;
        }
        if (par1 < par3) {
            var5 = par1;
            par1 = par3;
            par3 = var5;
        }
        if (par2 < par4) {
            var5 = par2;
            par2 = par4;
            par4 = var5;
        }
        par3 += par1;
        par4 += par2;
        float var10 = (float)(par5 >> 24 & 0xFF) / 255.0f;
        float var6 = (float)(par5 >> 16 & 0xFF) / 255.0f;
        float var7 = (float)(par5 >> 8 & 0xFF) / 255.0f;
        float var8 = (float)(par5 & 0xFF) / 255.0f;
        Tessellator var9 = Tessellator.field_78398_a;
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        ReikaGLHelper.BlendMode.DEFAULT.apply();
        GL11.glColor4f((float)var6, (float)var7, (float)var8, (float)var10);
        if (var9.field_78415_z) {
            var9.func_78381_a();
        }
        var9.func_78382_b();
        var9.func_78377_a((double)par1, (double)par4, 0.0);
        var9.func_78377_a((double)par3, (double)par4, 0.0);
        var9.func_78377_a((double)par3, (double)par2, 0.0);
        var9.func_78377_a((double)par1, (double)par2, 0.0);
        var9.func_78381_a();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    public void dottedLine(int x, int y, int x2, int y2, int t, int color) {
        int i;
        if (x == x2 && y == y2) {
            return;
        }
        if (x != x2 && y == y2) {
            for (i = x; i < x2 - t; ++i) {
                ReikaGuiAPI.func_73734_a((int)i, (int)y, (int)(i + t), (int)y, (int)color);
            }
        }
        if (y != y2 && x == x2) {
            for (i = y; i < y2 - t; ++i) {
                ReikaGuiAPI.func_73734_a((int)x, (int)i, (int)x, (int)(i + t), (int)color);
            }
        }
        if (x != x2 && y != y2) {
            int xdiff = x2 - x;
            int ydiff = y2 - y;
            double slope = (double)ydiff / (double)xdiff;
            while (x < x2 - t) {
                ReikaGuiAPI.func_73734_a((int)x, (int)y, (int)(x + t), (int)(y + t), (int)color);
                x += xdiff;
                y = (int)((double)y + (double)xdiff * slope);
            }
        }
    }

    public void drawLine(double x, double y, double x2, double y2, int color) {
        this.drawLine(x, y, x2, y2, color, LineType.SOLID);
    }

    public void drawLine(double x, double y, double x2, double y2, int color, LineType type) {
        if (type != LineType.THIN && GL11.glGetFloat((int)2849) < 1.5f) {
            GL11.glLineWidth((float)1.5f);
        }
        GL11.glPushAttrib((int)1048575);
        int alpha = ReikaColorAPI.getAlpha(color);
        if (alpha == 0) {
            alpha = 255;
        }
        int red = ReikaColorAPI.getRed(color);
        int green = ReikaColorAPI.getGreen(color);
        int blue = ReikaColorAPI.getBlue(color);
        GL11.glDisable((int)2896);
        if (alpha == 255) {
            GL11.glDisable((int)3042);
        } else {
            GL11.glEnable((int)3042);
        }
        GL11.glDisable((int)3553);
        if (type != LineType.SOLID) {
            type.setMode(2);
        }
        GL11.glBegin((int)1);
        GL11.glColor4f((float)((float)red / 255.0f), (float)((float)green / 255.0f), (float)((float)blue / 255.0f), (float)((float)alpha / 255.0f));
        GL11.glVertex2d((double)x, (double)y);
        GL11.glVertex2d((double)x2, (double)y2);
        GL11.glEnd();
        GL11.glPopAttrib();
    }

    public void drawCircle(double x, double y, double radius, int color) {
        GL11.glPushAttrib((int)1048575);
        int alpha = ReikaColorAPI.getAlpha(color);
        if (alpha == 0) {
            alpha = 255;
        }
        int red = ReikaColorAPI.getRed(color);
        int green = ReikaColorAPI.getGreen(color);
        int blue = ReikaColorAPI.getBlue(color);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBegin((int)2);
        GL11.glColor4f((float)((float)red / 255.0f), (float)((float)green / 255.0f), (float)((float)blue / 255.0f), (float)((float)alpha / 255.0f));
        for (int i = 0; i < 360; ++i) {
            GL11.glVertex2d((double)(x + radius * Math.cos(Math.toRadians(i))), (double)(y + radius * Math.sin(Math.toRadians(i))));
        }
        GL11.glEnd();
        GL11.glPopAttrib();
    }

    public void fillBar(int par1, int par2, int par3, int par4, int par5, int par6, int par7, boolean par8) {
        int var5;
        if (!par8) {
            int color = par5;
            par5 /= 1000000;
            par5 *= 1000000;
            par5 = -16777216 + (color - par5);
        }
        par2 += par7 - par6;
        if (par1 < (par3 += par1)) {
            var5 = par1;
            par1 = par3;
            par3 = var5;
        }
        if (par2 < par4) {
            var5 = par2;
            par2 = par4;
            par4 = var5;
        }
        float var10 = (float)(par5 >> 24 & 0xFF) / 255.0f;
        float var6 = (float)(par5 >> 16 & 0xFF) / 255.0f;
        float var7 = (float)(par5 >> 8 & 0xFF) / 255.0f;
        float var8 = (float)(par5 & 0xFF) / 255.0f;
        Tessellator var9 = Tessellator.field_78398_a;
        GL11.glPushAttrib((int)1048575);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2896);
        ReikaGLHelper.BlendMode.DEFAULT.apply();
        GL11.glColor4f((float)var6, (float)var7, (float)var8, (float)var10);
        if (var9.field_78415_z) {
            var9.func_78381_a();
        }
        var9.func_78382_b();
        var9.func_78377_a((double)par1, (double)par4, 0.0);
        var9.func_78377_a((double)par3, (double)par4, 0.0);
        var9.func_78377_a((double)par3, (double)par2, 0.0);
        var9.func_78377_a((double)par1, (double)par2, 0.0);
        var9.func_78381_a();
        GL11.glPopAttrib();
    }

    public void renderFraction(FontRenderer fr, String num, String den, int x, int y, int color, boolean shadow, boolean center) {
    }

    public void renderRoot(FontRenderer fr, String num, String root, int x, int y, int color, boolean shadow, boolean center) {
    }

    public void renderPower(FontRenderer fr, String base, String pow, int x, int y, int color, boolean shadow, boolean center) {
    }

    public void drawCustomRecipeList(RenderItem render, FontRenderer f, List<IRecipe> lr, int x, int y, int x2, int y2) {
        if (lr == null || lr.size() <= 0) {
            return;
        }
        int k = (int)(System.nanoTime() / 2000000000L) % lr.size();
        IRecipe ir = lr.get(k);
        IRecipe ire = ir instanceof WrappedRecipe ? ((WrappedRecipe)ir).getRecipe() : ir;
        ItemStack isout = ire.func_77571_b();
        ItemStack[] in = ReikaRecipeHelper.getPermutedRecipeArray(ire);
        if (in == null) {
            return;
        }
        boolean noshape = false;
        if (ire instanceof ShapelessRecipes) {
            noshape = true;
        }
        if (ire instanceof ShapelessOreRecipe) {
            noshape = true;
        }
        this.drawRecipe(render, f, x, y, in, x2, y2, isout, noshape);
    }

    public void drawCustomRecipes(RenderItem render, FontRenderer f, List<ItemStack> out, List<IRecipe> ir, int x, int y, int x2, int y2) {
        ArrayList<IRecipe> lr = new ArrayList<IRecipe>();
        for (ItemStack is : out) {
            lr.addAll(ReikaRecipeHelper.getAllRecipesByOutput(ir, is));
        }
        if (lr.size() <= 0) {
            return;
        }
        IRecipe ire = (IRecipe)lr.get((int)(System.nanoTime() / 2000000000L) % lr.size());
        ItemStack isout = ire.func_77571_b();
        ItemStack[] in = ReikaRecipeHelper.getPermutedRecipeArray(ire);
        if (in == null) {
            return;
        }
        boolean noshape = false;
        if (ire instanceof ShapelessRecipes) {
            noshape = true;
        }
        if (ire instanceof ShapelessOreRecipe) {
            noshape = true;
        }
        this.drawRecipe(render, f, x, y, in, x2, y2, isout, noshape);
    }

    private void drawRecipe(RenderItem render, FontRenderer f, int x, int y, ItemStack[] in, int x2, int y2, ItemStack out, boolean shapeless) {
        if (in.length != 9) {
            throw new MisuseException("DrawRecipe() requires 9 input items!");
        }
        int j = this.getScreenXInset();
        int k = this.getScreenYInset();
        for (int ii = 0; ii < 3; ++ii) {
            for (int jj = 0; jj < 3; ++jj) {
                if (in[ii * 3 + jj] == null) continue;
                in[ii * 3 + jj].field_77994_a = 1;
                this.drawItemStackWithTooltip(render, f, in[ii * 3 + jj], x + j + 18 * jj, y + k + 18 * ii);
            }
        }
        if (out != null) {
            this.drawItemStackWithTooltip(render, f, out, x2 + 4 + j, y2 + 4 + k);
        }
        if (shapeless) {
            f.func_78276_b("Shapeless", x2 + j - 35, y2 + k + 27, 0);
        }
    }

    public void drawSmelting(RenderItem render, FontRenderer f, ItemStack out, int x, int y, int x2, int y2) {
        int j = this.getScreenXInset();
        int k = this.getScreenYInset();
        ItemStack in = ReikaRecipeHelper.getFurnaceInput(out);
        if (in != null) {
            this.drawItemStackWithTooltip(render, f, in, x + j, y + k);
        }
        if (out != null) {
            this.drawItemStackWithTooltip(render, f, out, x2 + 4 + j, y2 + 4 + k);
        }
    }

    public void drawItemStack(RenderItem renderer, ItemStack is, int x, int y) {
        this.drawItemStack(renderer, Minecraft.func_71410_x().field_71466_p, is, x, y);
    }

    public void drawItemStack(RenderItem renderer, FontRenderer fr, ItemStack is, int x, int y) {
        this.drawItemStack(renderer, fr, is, x, y, false);
    }

    public void drawItemStack(RenderItem renderer, FontRenderer fr, ItemStack is, int x, int y, boolean forceStackSize) {
        FontRenderer font = null;
        if (is == null) {
            return;
        }
        if (is.func_77973_b() == null) {
            return;
        }
        if (is != null && is.func_77973_b() != null) {
            font = is.func_77973_b().getFontRenderer(is);
        }
        if (font == null) {
            font = fr;
        }
        GL11.glDisable((int)32826);
        RenderHelper.func_74518_a();
        GL11.glDisable((int)2896);
        RenderHelper.func_74520_c();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)32826);
        int short1 = 240;
        int short2 = 240;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((float)short1 / 1.0f), (float)((float)short2 / 1.0f));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        renderer.func_82406_b(font, this.field_146297_k.field_71446_o, is, x, y);
        renderer.func_94148_a(font, this.field_146297_k.field_71446_o, is, x, y, forceStackSize ? String.valueOf(is.field_77994_a) : null);
        if (this.cacheRenders) {
            this.items.addRegionByWH(x, y, 16, 16, is.func_77946_l());
        }
    }

    public void drawItemStackWithTooltip(RenderItem renderer, FontRenderer fr, ItemStack is, int x, int y) {
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)32.0f);
        FontRenderer f2 = Minecraft.func_71410_x().field_71466_p;
        if (f2 != null) {
            fr = f2;
        }
        if (is.func_77960_j() == Short.MAX_VALUE) {
            is = is.func_77946_l();
            is.func_77964_b(0);
        }
        this.drawItemStack(renderer, fr, is, x, y);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)32.0f);
        if (this.isMouseInBox(x, x + 16, y, y + 16)) {
            boolean right;
            String sg = is.func_82833_r();
            if (sg == null) {
                sg = is.toString() + "{" + is.field_77990_d + "}";
            }
            boolean bl = right = this.getMouseRealX() < this.field_146297_k.field_71462_r.field_146294_l / 2;
            if (right) {
                this.drawTooltipAt(fr, sg, this.getMouseRealX() + fr.func_78256_a(sg) + 12, this.getMouseRealY());
            } else {
                this.drawTooltip(fr, sg);
            }
        }
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-64.0f);
    }

    public void drawMultilineTooltip(List<String> li, int x, int y, int spacing, boolean center) {
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)64.0f);
        int dy = y;
        for (String s : li) {
            int dx = center ? x + this.field_146297_k.field_71466_p.func_78256_a(s) / 2 : x;
            this.drawTooltipAt(this.field_146297_k.field_71466_p, s, dx, dy);
            dy += spacing;
        }
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-64.0f);
    }

    public void drawMultilineTooltip(ItemStack is, int x, int y) {
        if (this.isMouseInBox(x, x + 16, y, y + 16)) {
            ArrayList<String> li = new ArrayList<String>();
            li.add(is.func_82833_r());
            is.func_77973_b().func_77624_a(is, (EntityPlayer)Minecraft.func_71410_x().field_71439_g, li, true);
            this.drawMultilineTooltip(li, x, y, 17, false);
        }
    }

    public void drawTooltip(FontRenderer f, String s) {
        int x = this.getMouseRealX() - f.func_78256_a(s) * 0;
        int y = this.getMouseRealY();
        this.drawTooltipAt(f, s, x, y);
    }

    public void drawTooltip(FontRenderer f, String s, int dx, int dy) {
        int x = this.getMouseRealX() - f.func_78256_a(s) * 0;
        int y = this.getMouseRealY();
        this.drawTooltipAt(f, s, x + dx, y + dy);
    }

    public void drawTooltipAt(FontRenderer f, String s, int mx, int my) {
        if (s == null) {
            s = "[null]";
        }
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)1048575);
        GL11.glDisable((int)2929);
        GL11.glDisable((int)3553);
        GL11.glDisable((int)3042);
        GL11.glDisable((int)2896);
        int k = f.func_78256_a(DelegateFontRenderer.stripFlags(s));
        int j2 = mx + 12;
        int k2 = my - 12;
        int i1 = 8;
        if (j2 + k > this.field_146294_l) {
            j2 -= 28 + k;
        }
        if (k2 + i1 + 6 > this.field_146295_m) {
            // empty if block
        }
        this.field_73735_i = 300.0f;
        ReikaGuiAPI.field_146296_j.field_77023_b = 300.0f;
        int j1 = -267386864;
        this.func_73733_a(j2 - 3, k2 - 4, j2 + k + 3, k2 - 3, j1, j1);
        this.func_73733_a(j2 - 3, k2 + i1 + 3, j2 + k + 3, k2 + i1 + 4, j1, j1);
        this.func_73733_a(j2 - 3, k2 - 3, j2 + k + 3, k2 + i1 + 3, j1, j1);
        this.func_73733_a(j2 - 4, k2 - 3, j2 - 3, k2 + i1 + 3, j1, j1);
        this.func_73733_a(j2 + k + 3, k2 - 3, j2 + k + 4, k2 + i1 + 3, j1, j1);
        int k1 = 0x505000FF;
        int l1 = (k1 & 0xFEFEFE) >> 1 | k1 & 0xFF000000;
        this.func_73733_a(j2 - 3, k2 - 3 + 1, j2 - 3 + 1, k2 + i1 + 3 - 1, k1, l1);
        this.func_73733_a(j2 + k + 2, k2 - 3 + 1, j2 + k + 3, k2 + i1 + 3 - 1, k1, l1);
        this.func_73733_a(j2 - 3, k2 - 3, j2 + k + 3, k2 - 3 + 1, k1, k1);
        this.func_73733_a(j2 - 3, k2 + i1 + 2, j2 + k + 3, k2 + i1 + 3, l1, l1);
        GL11.glEnable((int)3553);
        f.func_78261_a(s, j2, k2, -1);
        GL11.glPopAttrib();
        GL11.glPopMatrix();
        if (this.cacheRenders) {
            this.tooltips.addItem(s, mx, my + 8, f.func_78256_a(s) + 24, f.field_78288_b + 8);
        }
    }

    public void drawSplitTooltipAt(FontRenderer f, List<String> li, int mx, int my) {
        GL11.glPushAttrib((int)1048575);
        GL11.glDisable((int)2929);
        GL11.glDisable((int)3553);
        GL11.glDisable((int)3042);
        GL11.glDisable((int)2896);
        int k = -1;
        for (String s : li) {
            k = Math.max(k, f.func_78256_a(DelegateFontRenderer.stripFlags(s)));
        }
        int j2 = mx + 12;
        int k2 = my - 12;
        int i1 = 8 * li.size() + (2 * li.size() - 1) - 1;
        if (j2 + k > this.field_146294_l) {
            j2 -= 28 + k;
        }
        if (k2 + i1 + 6 > this.field_146295_m) {
            // empty if block
        }
        this.field_73735_i = 300.0f;
        ReikaGuiAPI.field_146296_j.field_77023_b = 300.0f;
        int j1 = -267386864;
        this.func_73733_a(j2 - 3, k2 - 4, j2 + k + 3, k2 - 3, j1, j1);
        this.func_73733_a(j2 - 3, k2 + i1 + 3, j2 + k + 3, k2 + i1 + 4, j1, j1);
        this.func_73733_a(j2 - 3, k2 - 3, j2 + k + 3, k2 + i1 + 3, j1, j1);
        this.func_73733_a(j2 - 4, k2 - 3, j2 - 3, k2 + i1 + 3, j1, j1);
        this.func_73733_a(j2 + k + 3, k2 - 3, j2 + k + 4, k2 + i1 + 3, j1, j1);
        int k1 = 0x505000FF;
        int l1 = (k1 & 0xFEFEFE) >> 1 | k1 & 0xFF000000;
        this.func_73733_a(j2 - 3, k2 - 3 + 1, j2 - 3 + 1, k2 + i1 + 3 - 1, k1, l1);
        this.func_73733_a(j2 + k + 2, k2 - 3 + 1, j2 + k + 3, k2 + i1 + 3 - 1, k1, l1);
        this.func_73733_a(j2 - 3, k2 - 3, j2 + k + 3, k2 - 3 + 1, k1, k1);
        this.func_73733_a(j2 - 3, k2 + i1 + 2, j2 + k + 3, k2 + i1 + 3, l1, l1);
        GL11.glEnable((int)3553);
        for (int i = 0; i < li.size(); ++i) {
            String s = li.get(i);
            f.func_78261_a(s, j2, k2 + i * 10, -1);
            if (!this.cacheRenders) continue;
            this.tooltips.addItem(s, mx, my + 8 + i * 10, f.func_78256_a(s) + 24, f.field_78288_b + 8);
        }
        GL11.glPopAttrib();
    }

    public Map<String, Rectangle> getTooltips() {
        return this.tooltips.view();
    }

    public Map<Rectangle, ItemStack> getRenderedItems() {
        return this.items.view();
    }

    public ItemStack getItemRenderAt(int x, int y) {
        return this.items.getRegion(x, y);
    }

    public float getMouseScreenY() {
        return 1.0f - (float)Mouse.getY() / (float)Minecraft.func_71410_x().field_71440_d;
    }

    public float getMouseScreenX() {
        return (float)Mouse.getX() / (float)Minecraft.func_71410_x().field_71443_c;
    }

    public int getMouseRealX() {
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution sr = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
        int w = sr.func_78326_a();
        int x = Mouse.getX() * w / mc.field_71443_c;
        return x;
    }

    public int getMouseRealY() {
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution sr = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
        int h = sr.func_78328_b();
        int y = h - Mouse.getY() * h / mc.field_71440_d - 1;
        return y;
    }

    public boolean isMouseInBox(int minx, int maxx, int miny, int maxy) {
        int x = this.getMouseRealX();
        int y = this.getMouseRealY();
        return x >= minx && x <= maxx && y >= miny && y <= maxy;
    }

    public void renderStatic(int minx, int miny, int maxx, int maxy) {
        for (int i = minx; i <= maxx; ++i) {
            for (int k = miny; k <= maxy; ++k) {
                int br = ReikaRandomHelper.getRandomBetween(0, 255);
                int color = ReikaColorAPI.GStoHex(br);
                ReikaGuiAPI.func_73734_a((int)i, (int)k, (int)(i + 1), (int)(k + 1), (int)(0xFF000000 | color));
            }
        }
    }

    public void drawTexturedModalRectWithDepth(int x, int y, int u, int v, int w, int h, int o) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)0.0, (double)o);
        this.func_73729_b(x, y, u, v, w, h);
        GL11.glPopMatrix();
    }

    public void drawRectFrame(int minx, int miny, int w, int h, int color) {
        this.drawRectFrame(minx, miny, w, h, color, LineType.SOLID);
    }

    public void drawRectFrame(int minx, int miny, int w, int h, int color, LineType type) {
        int maxx = minx + w;
        int maxy = miny + h;
        this.drawLine(minx, miny, maxx, miny, color, type);
        this.drawLine(minx, maxy, maxx, maxy, color, type);
        this.drawLine(minx, miny, minx, maxy, color, type);
        this.drawLine(maxx, miny, maxx, maxy, color, type);
    }

    public void drawVanillaHealthBar(EntityPlayer ep, ScaledResolution sr, int rowHeight) {
        this.drawVanillaHealthBar(ep, sr, rowHeight, null);
    }

    public void drawVanillaHealthBar(EntityPlayer ep, ScaledResolution sr, int rowHeight, HashMap<Integer, Integer> colors) {
        boolean highlight;
        GL11.glEnable((int)3042);
        if (colors != null && !colors.isEmpty()) {
            ReikaTextureHelper.bindFinalTexture(DragonAPICore.class, "Resources/gui.png");
        }
        boolean bl = highlight = ep.field_70172_ad / 3 % 2 == 1;
        if (ep.field_70172_ad < 10) {
            highlight = false;
        }
        IAttributeInstance attrMaxHealth = ep.func_110148_a(SharedMonsterAttributes.field_111267_a);
        int health = MathHelper.func_76123_f((float)ep.func_110143_aJ());
        int healthLast = MathHelper.func_76123_f((float)ep.field_70735_aL);
        float healthMax = (float)attrMaxHealth.func_111126_e();
        float absorb = ep.func_110139_bj();
        int healthRows = MathHelper.func_76123_f((float)((healthMax + absorb) / 2.0f / 10.0f));
        int left = sr.func_78326_a() / 2 - 91;
        int top = sr.func_78328_b() - GuiIngameForge.left_height;
        GuiIngameForge.left_height += healthRows * rowHeight;
        if (rowHeight != 10) {
            GuiIngameForge.left_height += 10 - rowHeight;
        }
        int regen = -1;
        if (ep.func_70644_a(Potion.field_76428_l)) {
            regen = (int)(System.currentTimeMillis() / 50L) % 25;
        }
        int upper = 9 * (ep.field_70170_p.func_72912_H().func_76093_s() ? 5 : 0);
        int back = highlight ? 25 : 16;
        int margin = 16;
        if (ep.func_70644_a(Potion.field_76436_u)) {
            margin += 36;
        } else if (ep.func_70644_a(Potion.field_82731_v)) {
            margin += 72;
        }
        float absorbRemaining = absorb;
        for (int i = MathHelper.func_76123_f((float)((healthMax + absorb) / 2.0f)) - 1; i >= 0; --i) {
            Integer color;
            int row = MathHelper.func_76123_f((float)((float)(i + 1) / 10.0f)) - 1;
            int x = left + i % 10 * 8;
            int y = top - row * rowHeight;
            if (health <= 4) {
                y += ReikaRandomHelper.getRandomPlusMinus(2, 1);
            }
            if (i == regen) {
                y -= 2;
            }
            this.func_73729_b(x, y, back, upper, 9, 9);
            if (highlight) {
                if (i * 2 + 1 < healthLast) {
                    this.func_73729_b(x, y, margin + 54, upper, 9, 9);
                } else if (i * 2 + 1 == healthLast) {
                    this.func_73729_b(x, y, margin + 63, upper, 9, 9);
                }
            }
            if (absorbRemaining > 0.0f) {
                if (absorbRemaining == absorb && absorb % 2.0f == 1.0f) {
                    this.func_73729_b(x, y, margin + 153, upper, 9, 9);
                } else {
                    this.func_73729_b(x, y, margin + 144, upper, 9, 9);
                }
                absorbRemaining -= 2.0f;
                continue;
            }
            if (colors != null && (color = colors.get(i)) != null) {
                float red = (float)ReikaColorAPI.getRed(color) / 255.0f;
                float green = (float)ReikaColorAPI.getGreen(color) / 255.0f;
                float blue = (float)ReikaColorAPI.getBlue(color) / 255.0f;
                GL11.glColor3f((float)red, (float)green, (float)blue);
            }
            if (i * 2 + 1 < health) {
                this.func_73729_b(x, y, margin + 36, upper, 9, 9);
            } else if (i * 2 + 1 == health) {
                this.func_73729_b(x, y, margin + 45, upper, 9, 9);
            }
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        }
        ReikaTextureHelper.bindHUDTexture();
        GL11.glDisable((int)3042);
    }

    public void setZLevel(float z) {
        this.field_73735_i = z;
    }

    public float getZLevel() {
        return this.field_73735_i;
    }
}

