/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Libraries.World;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Interfaces.Entity.DestroyOnUnload;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.ReikaEntityHelper;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraft.world.gen.ChunkProviderServer;

public final class ReikaChunkHelper
extends DragonAPICore {
    public static Chunk getChunk(World world, int x, int z) {
        Chunk in = world.func_72938_d(x, z);
        return in;
    }

    public static void regenChunk(WorldServer world, int x, int z) {
        ChunkProviderServer prov = (ChunkProviderServer)world.func_72863_F();
        IChunkProvider gen = prov.field_73246_d;
        Chunk regen = gen.func_73154_d(x >> 4, z >> 4);
        ReikaChunkHelper.copyChunk(world.func_72938_d(x, z), regen);
        gen.func_73153_a((IChunkProvider)prov, x >> 4, z >> 4);
        GameRegistry.generateWorld((int)(x >> 4), (int)(z >> 4), (World)world, (IChunkProvider)gen, (IChunkProvider)prov);
        regen.func_76630_e();
        world.func_72807_a(x + 16, z + 16).func_76728_a((World)world, rand, x, z);
    }

    private static void copyChunk(Chunk tgt, Chunk repl) {
        tgt.func_76602_a(repl.func_76587_i());
        tgt.func_76616_a(repl.func_76605_m());
        for (ChunkPosition cc : tgt.field_150816_i.keySet()) {
            tgt.func_150805_f(cc.field_151329_a, cc.field_151327_b, cc.field_151328_c);
        }
        tgt.field_150816_i = repl.field_150816_i;
        for (TileEntity te : tgt.field_150816_i.values()) {
            tgt.func_150813_a(te);
        }
    }

    public static void emptyChunk(World world, int x, int z) {
        while (x % 16 > 0) {
            --x;
        }
        while (z % 16 > 0) {
            --z;
        }
        AxisAlignedBB chunk = AxisAlignedBB.func_72330_a((double)x, (double)0.0, (double)z, (double)(x + 16), (double)255.0, (double)(z + 16));
        List inChunk = world.func_72872_a(Entity.class, chunk);
        for (int i = 0; i < inChunk.size(); ++i) {
            Entity ent = (Entity)inChunk.get(i);
            if (ent instanceof EntityPlayer) continue;
            ent.func_70106_y();
        }
    }

    public static void deleteChunk(World world, int x, int z, Block id) {
        for (Block b : Block.field_149771_c) {
            if (id == b) continue;
            ReikaChunkHelper.removeIDFromChunk(world, x, z, b);
        }
    }

    public static void removeFromChunk(World world, int x, int z, Class entityClass) {
        while (x % 16 > 0) {
            --x;
        }
        while (z % 16 > 0) {
            --z;
        }
        AxisAlignedBB chunk = AxisAlignedBB.func_72330_a((double)x, (double)0.0, (double)z, (double)(x + 16), (double)255.0, (double)(z + 16));
        List inChunk = world.func_72872_a(entityClass, chunk);
        for (int i = 0; i < inChunk.size(); ++i) {
            Entity ent = (Entity)inChunk.get(i);
            ent.func_70106_y();
        }
    }

    public static void removeBlocksFromChunk(World world, int x, int z, Block id, int meta) {
        if (meta == -1) {
            ReikaChunkHelper.removeIDFromChunk(world, x, z, id);
            return;
        }
        ReikaChunkHelper.replaceBlocksInChunk(world, x, z, id, meta, Blocks.field_150350_a, 0);
    }

    public static void replaceBlocksInChunk(World world, int x, int z, Block id, int meta, Block setid, int setmeta) {
        boolean nx = false;
        boolean nz = false;
        if (x < 0) {
            x = -x;
            nx = true;
        }
        if (z < 0) {
            z = -z;
            nz = true;
        }
        while (x % 16 > 0) {
            if (nx) {
                ++x;
                continue;
            }
            --x;
        }
        while (z % 16 > 0) {
            if (nx) {
                ++z;
                continue;
            }
            --z;
        }
        if (nx) {
            x = -x;
        }
        if (nz) {
            z = -z;
        }
        if (meta == -1) {
            ReikaChunkHelper.replaceIDInChunk(world, x, z, id, setid, setmeta);
            return;
        }
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                for (int k = 0; k < 256; ++k) {
                    Block idread = world.func_147439_a(x + i, k, z + j);
                    int metaread = world.func_72805_g(x + i, k, z + j);
                    if (idread != id || metaread != meta) continue;
                    world.func_147465_d(x + i, k, z + j, setid, setmeta, 3);
                }
            }
        }
    }

    private static void replaceIDInChunk(World world, int x, int z, Block id, Block setid, int setmeta) {
        boolean nx = false;
        boolean nz = false;
        if (x < 0) {
            x = -x;
            nx = true;
        }
        if (z < 0) {
            z = -z;
            nz = true;
        }
        while (x % 16 > 0) {
            if (nx) {
                ++x;
                continue;
            }
            --x;
        }
        while (z % 16 > 0) {
            if (nx) {
                ++z;
                continue;
            }
            --z;
        }
        if (nx) {
            x = -x;
        }
        if (nz) {
            z = -z;
        }
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                for (int k = 0; k < 256; ++k) {
                    Block idread = world.func_147439_a(x + i, k, z + j);
                    if (idread != id) continue;
                    world.func_147465_d(x + i, k, z + j, setid, setmeta, 3);
                }
            }
        }
    }

    private static void removeIDFromChunk(World world, int x, int z, Block id) {
        ReikaChunkHelper.replaceIDInChunk(world, x, z, id, Blocks.field_150350_a, 0);
    }

    public static double getPoplnDensity(World world, Entity entity, double x, double y, double z, double r) {
        Entity entityfound = world.func_72857_a(entity.getClass(), AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1.0), (double)(y + 1.0), (double)(z + 1.0)).func_72314_b(r, r, r), entity);
        if (entityfound == null) {
            return -1.0;
        }
        double dist = ReikaMathLibrary.py3d(x - entityfound.field_70165_t, y - entityfound.field_70163_u, z - entityfound.field_70161_v);
        return dist;
    }

    public static int getChunkPopln(World world, Class entity, int x, int z) {
        while (x % 16 > 0) {
            --x;
        }
        while (z % 16 > 0) {
            --z;
        }
        int entitiesfound = world.func_72872_a(entity, AxisAlignedBB.func_72330_a((double)x, (double)0.0, (double)z, (double)(x + 16), (double)255.0, (double)(z + 16))).size();
        return entitiesfound;
    }

    public static int getChunkRangePopln(World world, Class entity, int x, int z, int x2, int z2) {
        while (x % 16 > 0) {
            --x;
        }
        while (z % 16 > 0) {
            --z;
        }
        while (x % 16 > 0) {
            --x2;
        }
        while (z % 16 > 0) {
            ++z2;
        }
        int entitiesfound = world.func_72872_a(entity, AxisAlignedBB.func_72330_a((double)x, (double)0.0, (double)z, (double)x2, (double)255.0, (double)z2)).size();
        return entitiesfound;
    }

    public static Collection<Entity> getEntities(Chunk ch, ReikaEntityHelper.ClassEntitySelector sel) {
        ArrayList<Entity> c = new ArrayList<Entity>();
        for (int i = 0; i < ch.field_76645_j.length; ++i) {
            List li = ch.field_76645_j[i];
            for (Entity e : li) {
                if (sel != null && !sel.func_82704_a(e)) continue;
                c.add(e);
            }
        }
        return c;
    }

    public static void clearEntities(Chunk ch, ReikaEntityHelper.ClassEntitySelector sel) {
        for (int i = 0; i < ch.field_76645_j.length; ++i) {
            List li = ch.field_76645_j[i];
            for (Entity e : li) {
                if (sel != null && !sel.func_82704_a(e)) continue;
                e.func_70106_y();
            }
        }
    }

    public static void clearUnloadableEntities(Chunk ch) {
        for (int i = 0; i < ch.field_76645_j.length; ++i) {
            List li = ch.field_76645_j[i];
            for (Entity e : li) {
                if (!(e instanceof DestroyOnUnload)) continue;
                ((DestroyOnUnload)e).destroy();
            }
        }
    }

    public static boolean chunkContainsBiome(World world, int cx, int cz, BiomeGenBase b) {
        int x = cx << 4;
        int z = cz << 4;
        return ReikaChunkHelper.chunkContainsBiomeBlockCoords(world, x, z, b);
    }

    public static boolean chunkContainsBiomeBlockCoords(World world, int x, int z, BiomeGenBase b) {
        return world.func_72807_a(x, z) == b || world.func_72807_a(x + 15, z) == b || world.func_72807_a(x, z + 15) == b || world.func_72807_a(x + 15, z + 15) == b;
    }

    public static boolean chunkContainsBiomeType(World world, int cx, int cz, Class<? extends BiomeGenBase> c) {
        int x = cx << 4;
        int z = cz << 4;
        return ReikaChunkHelper.chunkContainsBiomeTypeBlockCoords(world, x, z, c);
    }

    public static boolean chunkContainsBiomeTypeBlockCoords(World world, int x, int z, Class<? extends BiomeGenBase> c) {
        return c.isInstance(world.func_72807_a(x, z)) || c.isInstance(world.func_72807_a(x + 15, z)) || c.isInstance(world.func_72807_a(x, z + 15)) || c.isInstance(world.func_72807_a(x + 15, z + 15));
    }

    private static ExtendedBlockStorage getStorageInChunk(Chunk c, int y) {
        return c.func_76587_i()[y >> 4];
    }

    private static ExtendedBlockStorage getOrCreateStorageInChunk(Chunk c, int y) {
        ExtendedBlockStorage exb = ReikaChunkHelper.getStorageInChunk(c, y);
        if (exb == null) {
            c.func_76587_i()[y >> 4] = exb = new ExtendedBlockStorage(y >> 4 << 4, !c.field_76637_e.field_73011_w.field_76576_e);
        }
        return exb;
    }

    public static Block[] getChunkAsColumnData(Chunk c) {
        Block[] data = new Block[65536];
        for (int i = 0; i < 16; ++i) {
            for (int k = 0; k < 16; ++k) {
                for (int j = 0; j < 256; ++j) {
                    int idx = j + 256 * (i * 16 + k);
                    Block b = null;
                    ExtendedBlockStorage exb = ReikaChunkHelper.getStorageInChunk(c, j);
                    if (exb != null) {
                        b = exb.func_150819_a(i, j & 0xF, k);
                    }
                    if (b == Blocks.field_150350_a) {
                        b = null;
                    }
                    data[idx] = b;
                }
            }
        }
        return data;
    }

    public static void writeBlockColumnToChunk(Chunk c, Block[] data) {
        for (int i = 0; i < 16; ++i) {
            for (int k = 0; k < 16; ++k) {
                for (int j = 0; j < 256; ++j) {
                    int idx = j + 256 * (i * 16 + k);
                    if (data[idx] == null) {
                        data[idx] = Blocks.field_150350_a;
                    }
                    ExtendedBlockStorage exb = ReikaChunkHelper.getOrCreateStorageInChunk(c, j);
                    exb.func_150818_a(i, j & 0xF, k, data[idx]);
                }
            }
        }
    }

    public static Chunk getRandomLoadedChunk(World world) {
        ChunkCoordIntPair p = (ChunkCoordIntPair)ReikaJavaLibrary.getRandomCollectionEntry(rand, world.field_72993_I);
        return world.func_72964_e(p.field_77276_a, p.field_77275_b);
    }

    public static boolean isSpawn(Chunk c) {
        ChunkCoordinates spawn = c.field_76637_e.func_72861_E();
        return c.field_76635_g == spawn.field_71574_a >> 4 && c.field_76647_h == spawn.field_71573_c >> 4;
    }

    public static Coordinate searchForBlock(World world, int x, int z, Block b) {
        Chunk c = world.func_72964_e(x, z);
        int top = c.func_76625_h() + 15;
        for (int j = 0; j < 256 && j <= top; ++j) {
            for (int i = 0; i < 16; ++i) {
                for (int k = 0; k < 16; ++k) {
                    Block at;
                    int idx = j + 256 * (i * 16 + k);
                    ExtendedBlockStorage exb = ReikaChunkHelper.getStorageInChunk(c, j);
                    Block block = at = exb != null ? exb.func_150819_a(i, j & 0xF, k) : null;
                    if (at != b) continue;
                    return new Coordinate(c.field_76635_g * 16 + i, j, c.field_76647_h * 16 + k);
                }
            }
        }
        return null;
    }

    public static ArrayList<Coordinate> getChunkCoords(int x, int z) {
        ArrayList<Coordinate> ret = new ArrayList<Coordinate>();
        for (int i = 0; i < 16; ++i) {
            for (int k = 0; k < 16; ++k) {
                ret.add(new Coordinate(x + i, 0, z + k));
            }
        }
        return ret;
    }
}

